/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.AddNotificationsAction;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.AddNotificationsForm;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.AddUsersForm;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddUsersAction
extends AddNotificationsAction {
    private Log log = LogFactory.getLog(AddUsersAction.class);

    protected ActionForward process(ActionMapping mapping, AddNotificationsForm form, HttpServletRequest request, Map<String, Integer> params) throws Exception {
        AddUsersForm addForm = (AddUsersForm)form;
        ActionForward forward = this.checkSubmit(request, mapping, (ActionForm)form, params);
        HttpSession session = request.getSession();
        Subject subject = RequestUtils.getSubject((HttpServletRequest)request);
        if (forward != null) {
            if (addForm.isCancelClicked() || addForm.isResetClicked()) {
                this.log.debug((Object)"removing pending user list");
                SessionUtils.removeList((HttpSession)session, (String)"pendingUsers");
            } else if (addForm.isAddClicked()) {
                this.log.debug((Object)"adding to pending user list");
                SessionUtils.addToList((HttpSession)session, (String)"pendingUsers", (Integer[])addForm.getAvailableUsers());
                this.log.debug((Object)("@@@@@@@@@@" + addForm.getAvailableUsers().toString()));
                for (int i = 0; i < addForm.getAvailableUsers().length; ++i) {
                    this.log.debug((Object)("Avalilable Users " + addForm.getAvailableUsers()[i]));
                }
            } else if (addForm.isRemoveClicked()) {
                this.log.debug((Object)"removing from pending user list");
                SessionUtils.removeFromList((HttpSession)session, (String)"pendingUsers", (Integer[])addForm.getPendingUsers());
            }
            return forward;
        }
        this.log.debug((Object)"getting pending user list");
        Integer[] pendingUserIds = SessionUtils.getList((HttpSession)session, (String)"pendingUsers");
        for (int i = 0; i < pendingUserIds.length; ++i) {
            this.log.debug((Object)("adding user [" + pendingUserIds[i] + "] for alert definition [" + addForm.getAd() + "]"));
        }
        AlertNotificationManagerLocal alertNotificationManager = LookupUtil.getAlertNotificationManager();
        alertNotificationManager.addSubjectNotifications(subject, addForm.getAd(), pendingUserIds);
        this.log.debug((Object)"remove pending user list");
        SessionUtils.removeList((HttpSession)session, (String)"pendingUsers");
        RequestUtils.setConfirmation((HttpServletRequest)request, (String)"alerts.config.confirm.AddRoles");
        return this.returnSuccess(request, mapping, params);
    }
}

