/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.notification.SnmpNotification;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.action.resource.ResourceForm;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.AlertDefUtil;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.SnmpTrapForm;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpTrapFormAction
extends BaseAction {
    private Log log = LogFactory.getLog(SnmpTrapFormAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SnmpNotification snmpNotification;
        SnmpTrapForm snmpTrapForm = (SnmpTrapForm)form;
        AlertDefinition alertDefinition = AlertDefUtil.getAlertDefinition((HttpServletRequest)request);
        PageControl pageControl = WebUtility.getPageControl((ServletRequest)request);
        Subject subject = RequestUtils.getSubject((HttpServletRequest)request);
        AlertNotificationManagerLocal alertNotificationManager = LookupUtil.getAlertNotificationManager();
        if (snmpTrapForm.isDeleteClicked()) {
            snmpNotification = this.getExistingSnmpNotification(alertDefinition, pageControl);
            if (snmpNotification != null) {
                alertNotificationManager.removeNotifications(subject, Integer.valueOf(alertDefinition.getId()), new Integer[]{snmpNotification.getId()});
            }
        } else {
            snmpNotification = new SnmpNotification(alertDefinition, snmpTrapForm.getHost(), snmpTrapForm.getPort(), snmpTrapForm.getOid());
            alertNotificationManager.setSnmpNotification(subject, Integer.valueOf(alertDefinition.getId()), snmpNotification);
        }
        Map requestParams = this.createRequestParamsMap(snmpTrapForm);
        return this.returnSuccess(request, mapping, requestParams);
    }

    @Nullable
    private SnmpNotification getExistingSnmpNotification(AlertDefinition alertDefinition, PageControl pageControl) {
        SnmpNotification snmpNotification;
        AlertNotificationManagerLocal alertNotificationManager = LookupUtil.getAlertNotificationManager();
        PageList snmpNotifications = alertNotificationManager.getSnmpNotifications(Integer.valueOf(alertDefinition.getId()), pageControl);
        if (!snmpNotifications.isEmpty()) {
            if (snmpNotifications.size() > 1) {
                this.log.error((Object)("More than one SNMP notification found for alert definition " + alertDefinition + ", but the GUI currently only supports up to one SNMP notification per alert definition."));
            }
            snmpNotification = (SnmpNotification)snmpNotifications.get(0);
        } else {
            snmpNotification = null;
        }
        return snmpNotification;
    }

    private Map<String, Integer> createRequestParamsMap(SnmpTrapForm snmpTrapForm) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("ad", snmpTrapForm.getAd());
        ResourceForm.FormContext context = snmpTrapForm.getContext();
        if (context == ResourceForm.FormContext.Type) {
            params.put("type", snmpTrapForm.getType());
        } else if (context == ResourceForm.FormContext.Resource) {
            params.put("id", snmpTrapForm.getId());
        } else if (context == ResourceForm.FormContext.Group) {
            params.put("groupId", snmpTrapForm.getGroupId());
        } else {
            throw new IllegalArgumentException("Unsupported context: " + context);
        }
        return params;
    }
}

