/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.util.MessageResources;
import org.rhq.core.clientapi.util.ArrayUtil;
import org.rhq.core.clientapi.util.StringUtil;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.MeasurementBaseline;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.NumericType;
import org.rhq.core.domain.measurement.composite.MeasurementDataNumericHighLowComposite;
import org.rhq.core.domain.measurement.util.MeasurementConverter;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageControl;
import org.rhq.enterprise.gui.common.servlet.HighLowMetricValue;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.WebUserPreferences;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.MetricDisplayRangeFormPrepareAction;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.MetricRange;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.ViewChartForm;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.ViewChartFormPrepareAction;
import org.rhq.enterprise.gui.legacy.beans.ChartDataBean;
import org.rhq.enterprise.gui.legacy.beans.ChartedMetricBean;
import org.rhq.enterprise.gui.legacy.beans.NumericMetricDataPoint;
import org.rhq.enterprise.gui.legacy.exception.ParameterNotFoundException;
import org.rhq.enterprise.gui.legacy.util.MonitorUtils;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.auth.SessionNotFoundException;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.measurement.AvailabilityPoint;
import org.rhq.enterprise.server.measurement.BaselineCreationException;
import org.rhq.enterprise.server.measurement.MeasurementBaselineManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementChartsManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementNotFoundException;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.measurement.uibean.MetricDisplaySummary;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewChartFormPrepareAction
extends MetricDisplayRangeFormPrepareAction {
    private static final int NUMBER_OF_DATA_POINTS = 60;
    private static final int DEFAULT_MAX_RESOURCES = 10;
    private final Log log = LogFactory.getLog(ViewChartFormPrepareAction.class);
    MeasurementDataManagerLocal dataManager;
    MeasurementScheduleManagerLocal scheduleManager;
    MeasurementChartsManagerLocal chartsManager;
    ResourceManagerLocal resMgr;
    ResourceGroupManagerLocal resGrpMgr;
    ResourceTypeManagerLocal resTypeMgr;
    private static final BaseMetricDisplayComparator comp = new BaseMetricDisplayComparator(null);

    public ActionForward workflow(ComponentContext cc, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.workflow(cc, mapping, form, request, response);
        ViewChartForm chartForm = (ViewChartForm)form;
        Subject subject = WebUtility.getSubject((HttpServletRequest)request);
        int groupId = -1;
        Resource resource = RequestUtils.getResource((HttpServletRequest)request);
        int parent = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"parent", (int)-1);
        int type = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"type", (int)-1);
        if (resource == null && (groupId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"groupId", (int)-1)) == -1 && parent == 1) {
            return this.removeBadDashboardLink(request);
        }
        this.dataManager = LookupUtil.getMeasurementDataManager();
        this.scheduleManager = LookupUtil.getMeasurementScheduleManager();
        this.chartsManager = LookupUtil.getMeasurementChartsManager();
        this.resMgr = LookupUtil.getResourceManager();
        this.resGrpMgr = LookupUtil.getResourceGroupManager();
        this.resTypeMgr = LookupUtil.getResourceTypeManager();
        if (resource != null) {
            chartForm.setId(Integer.valueOf(resource.getId()));
            chartForm.setCategory(resource.getResourceType().getCategory().name());
            try {
                int childResourceTypeId = WebUtility.getChildResourceTypeId((HttpServletRequest)request);
                chartForm.setCtype(Integer.valueOf(childResourceTypeId));
                chartForm.setType(Integer.valueOf(childResourceTypeId));
            }
            catch (ParameterNotFoundException e) {}
        } else if (groupId > 0 || parent > 0) {
            int definitionId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"definitionId", (int)-1);
            if (definitionId > 0) {
                chartForm.setM(new Integer[]{definitionId});
            }
            if (parent > 0) {
                chartForm.setCtype(Integer.valueOf(type));
                chartForm.setParent(parent);
                Resource parentResource = this.resMgr.getResourceById(subject, parent);
                ResourceType childType = this.resTypeMgr.getResourceTypeById(subject, type);
                String name = parentResource.getName() + "/" + childType.getName();
                chartForm.setChartName(name);
            }
            if (groupId > 0) {
                chartForm.setGroupId(groupId);
                ResourceGroup group = this.resGrpMgr.getResourceGroupById(subject, groupId, GroupCategory.COMPATIBLE);
                chartForm.setChartName(group.getName());
            }
        }
        this._setupDateRange(request, chartForm);
        this._setupMetricIds(request, chartForm);
        ArrayList<Object> resources = null;
        Object allResources = null;
        String[] r = request.getParameterValues("r");
        String[] resourceIdsParam = request.getParameterValues("resourceIds");
        if (resource != null) {
            resources = this._setupResources(request, chartForm, resource, subject);
            allResources = (List)resources.get(0);
        } else if (groupId > 0 || parent > 0) {
            List<Integer> resIds;
            allResources = groupId > 0 ? this.resGrpMgr.findResourcesForResourceGroup(subject, groupId, GroupCategory.COMPATIBLE) : this.resGrpMgr.findResourcesForAutoGroup(subject, parent, type);
            ArrayList<Resource> checked = new ArrayList<Resource>(10);
            int i = 0;
            Integer[] resourceIds = chartForm.getResourceIds();
            if (resourceIds != null) {
                resIds = Arrays.asList(resourceIds);
            } else {
                if (null != r && r.length > 0) {
                    resourceIds = new Integer[r.length];
                    resIds = new ArrayList<Integer>();
                    for (int j = 0; j < r.length; ++j) {
                        if (j >= 10) continue;
                        Integer resourceId = 0;
                        try {
                            resourceId = Integer.valueOf(r[j]);
                        }
                        catch (NumberFormatException e) {
                            resourceId = -1;
                        }
                        resIds.add(resourceId);
                        resourceIds[j] = resourceId;
                    }
                } else {
                    int allResourcesSize = allResources.size();
                    resourceIds = new Integer[allResourcesSize];
                    resIds = new ArrayList<Integer>();
                    for (int j = 0; j < allResourcesSize; ++j) {
                        if (j >= 10) continue;
                        Integer resourceId = ((Resource)allResources.get(j)).getId();
                        resIds.add(resourceId);
                        resourceIds[j] = resourceId;
                    }
                }
                chartForm.setResourceIds(resourceIds);
            }
            for (Resource res : allResources) {
                if (i >= 10) break;
                if (!resIds.contains(res.getId())) continue;
                checked.add(res);
                ++i;
            }
            resources = new ArrayList(2);
            resources.add(allResources);
            resources.add(checked);
            request.setAttribute("resources", (Object)allResources.toArray(new Resource[allResources.size()]));
            request.setAttribute("resourcesSize", (Object)allResources.size());
            request.setAttribute("checkedResources", (Object)checked.toArray(new Resource[checked.size()]));
            request.setAttribute("checkedResourcesSize", (Object)checked.size());
        } else if (r != null && r.length > 0 || resourceIdsParam != null && resourceIdsParam.length > 0) {
            if (resourceIdsParam != null && r == null) {
                r = resourceIdsParam;
            }
            int length = r.length;
            resources = new ArrayList(2);
            int[] resIds = new int[length];
            for (int i = 0; i < length; ++i) {
                resIds[i] = Integer.parseInt(r[i]);
            }
            allResources = this.resMgr.findResourceByIds(subject, resIds, false, PageControl.getUnlimitedInstance());
            resources.add(allResources);
            ArrayList<Resource> checked = new ArrayList<Resource>(allResources.size());
            if (resourceIdsParam != null && resourceIdsParam.length > 0) {
                block10: for (String tmp : resourceIdsParam) {
                    int id = Integer.parseInt(tmp);
                    for (Resource re : allResources) {
                        if (re.getId() != id) continue;
                        checked.add(re);
                        continue block10;
                    }
                }
            } else {
                checked.addAll((Collection<Resource>)allResources);
            }
            resources.add(checked);
            request.setAttribute("resources", (Object)allResources.toArray(new Resource[allResources.size()]));
            request.setAttribute("resourcesSize", (Object)allResources.size());
            request.setAttribute("checkedResources", (Object)checked.toArray(new Resource[checked.size()]));
            request.setAttribute("checkedResourcesSize", (Object)checked.size());
        } else {
            resources = new ArrayList<Object>(2);
            allResources = new ArrayList();
            resources.add(allResources);
            resources.add(allResources);
        }
        if (allResources.isEmpty()) {
            return this.removeBadDashboardLink(request);
        }
        try {
            List checkedResources = (List)resources.get(1);
            this._setupMetricData(request, chartForm, checkedResources, subject);
        }
        catch (MeasurementNotFoundException e) {
            return this.removeBadDashboardLink(request);
        }
        request.setAttribute("canSaveChart", (Object)"true");
        this._setupPageData(request, chartForm, (List)allResources, subject);
        this._setupBaselineExpectedRange(request, chartForm, (List)allResources, subject);
        this._setupParentResources(request, subject);
        return null;
    }

    private void _setupParentResources(HttpServletRequest request, Subject subject) {
        Resource[] resources = (Resource[])request.getAttribute("resources");
        for (int i = 0; i < resources.length; ++i) {
            Resource resource = resources[i];
            Resource parent = this.resMgr.getParentResource(resource.getId());
            resource.setParentResource(parent);
        }
    }

    private ActionForward removeBadDashboardLink(HttpServletRequest request) throws Exception, SessionNotFoundException {
        String query = request.getQueryString();
        WebUser user = SessionUtils.getWebUser((HttpSession)request.getSession());
        WebUserPreferences preferences = user.getWebPreferences();
        WebUserPreferences.SavedChartsPortletPreferences savedCharts = preferences.getSavedChartsPortletPreferences();
        savedCharts.removeByURL(query);
        return null;
    }

    private void _setupDateRange(HttpServletRequest request, ViewChartForm chartForm) {
        MetricRange range = (MetricRange)request.getAttribute("metricRange");
        if (null == range) {
            range = new MetricRange();
            range.setBegin(Long.valueOf(chartForm.getStartDate().getTime()));
            range.setEnd(Long.valueOf(chartForm.getEndDate().getTime()));
            range.shiftNow();
            request.setAttribute("metricRange", (Object)range);
        }
        chartForm.synchronizeDisplayRange();
    }

    private void _setupMetricIds(HttpServletRequest request, ViewChartForm chartForm) {
        String[] m = request.getParameterValues("m");
        Integer[] metricIds = ArrayUtil.stringToInteger((String[])m);
        chartForm.setM(metricIds);
        String[] origM = request.getParameterValues("origM");
        if (origM != null && origM.length != 0) {
            Integer[] originallySelectedMetricIds = ArrayUtil.stringToInteger((String[])origM);
            chartForm.setOrigM(originallySelectedMetricIds);
        } else {
            chartForm.setOrigM((Integer[])chartForm.getM().clone());
        }
    }

    private List<List<Resource>> _setupResources(HttpServletRequest request, ViewChartForm chartForm, Resource resource, Subject subject) throws Exception {
        ArrayList<List<Resource>> resources = new ArrayList<List<Resource>>();
        ArrayList<Resource> allResources = new ArrayList<Resource>();
        resources.add(allResources);
        ArrayList checkedResources = new ArrayList();
        resources.add(checkedResources);
        if (chartForm.getCtype() != null && chartForm.getCtype() != -1) {
            ArrayList childResources = new ArrayList();
            Object[] resourceIds = RequestUtils.getResourceIds((HttpServletRequest)request);
            if (resourceIds != null) {
                this.log.debug((Object)("r=" + StringUtil.arrayToString((Object[])resourceIds)));
                for (Resource childResource : childResources) {
                    boolean bl = false;
                    for (Object resourceId : resourceIds) {
                        if (childResource.getId() != ((Integer)resourceId).intValue()) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    this.log.debug((Object)("removing resource: " + childResource.getId()));
                    childResources.remove(childResource);
                }
            }
        } else {
            allResources.add(resource);
        }
        request.setAttribute("resources", (Object)allResources.toArray(new Resource[allResources.size()]));
        request.setAttribute("resourcesSize", (Object)allResources.size());
        Object[] resourceIds = RequestUtils.getResourceIds((HttpServletRequest)request);
        chartForm.setResourceIds((Integer[])resourceIds);
        if (null == resourceIds || resourceIds.length == 0) {
            int maxResources = this._getMaxResources(request, allResources.size());
            this.log.debug((Object)("maxResources=" + maxResources));
            checkedResources.addAll(allResources.subList(0, maxResources));
            Object[] rids = new Integer[checkedResources.size()];
            for (int i = 0; i < rids.length; ++i) {
                rids[i] = ((Resource)checkedResources.get(i)).getId();
            }
            chartForm.setResourceIds((Integer[])rids);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("no resourceIds specified: " + StringUtil.arrayToString((Object[])rids)));
            }
        } else {
            for (Integer n : resourceIds) {
                for (Resource aResource : allResources) {
                    if (aResource.getId() != n.intValue()) continue;
                    checkedResources.add(resource);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("resourceIds specified: " + StringUtil.arrayToString((Object[])resourceIds)));
            }
        }
        request.setAttribute("checkedResources", (Object)checkedResources.toArray(new Resource[checkedResources.size()]));
        request.setAttribute("checkedResourcesSize", (Object)checkedResources.size());
        return resources;
    }

    private void _setupMetricData(HttpServletRequest request, ViewChartForm chartForm, List<Resource> resources, Subject subject) throws Exception {
        AvailabilityManagerLocal availabilityManager = LookupUtil.getAvailabilityManager();
        Integer[] metricDefIds = chartForm.getM();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("number of metrics: " + metricDefIds.length));
            this.log.trace((Object)("number of resources: " + resources.size()));
        }
        String[] chartKeys = new String[metricDefIds.length];
        ArrayList chartDataPointsListList = new ArrayList(metricDefIds.length);
        boolean displayAvailability = false;
        ArrayList availabilityChartDataPointsList = new ArrayList();
        ArrayList<Integer> metricDefIdList = new ArrayList<Integer>();
        for (int i = 0; i < metricDefIds.length; ++i) {
            int metricDefId = metricDefIds[i];
            ArrayList chartDataPointsList = new ArrayList(resources.size());
            chartKeys[i] = String.valueOf(System.currentTimeMillis()) + metricDefId;
            request.getSession().setAttribute(chartKeys[i], (Object)new ChartDataBean(chartDataPointsList));
            metricDefIdList.add(metricDefId);
            chartDataPointsListList.add(chartDataPointsList);
        }
        int[] metricDefinitionIds = new int[metricDefIdList.size()];
        for (int i = 0; i < metricDefIdList.size(); ++i) {
            metricDefinitionIds[i] = (Integer)metricDefIdList.get(i);
        }
        long startDate = chartForm.getStartDate().getTime();
        long endDate = chartForm.getEndDate().getTime();
        for (Resource resource : resources) {
            List metricDataPointsList = this.dataManager.findDataForResource(subject, resource.getId(), metricDefinitionIds, startDate, endDate, 60);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Found " + metricDataPointsList.size() + " data points."));
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("data: " + metricDataPointsList));
                }
            }
            if (displayAvailability) {
                List availabilityPoints = availabilityManager.findAvailabilitiesForResource(subject, resource.getId(), startDate, endDate, 60, false);
                ArrayList<NumericMetricDataPoint> chartDataPoints = new ArrayList<NumericMetricDataPoint>(availabilityPoints.size());
                for (AvailabilityPoint availabilityPoint : availabilityPoints) {
                    NumericMetricDataPoint chartDataPoint = new NumericMetricDataPoint(availabilityPoint);
                    chartDataPoints.add(chartDataPoint);
                }
                availabilityChartDataPointsList.add(chartDataPoints);
            }
            for (int i = 0; i < metricDataPointsList.size(); ++i) {
                List metricDataPoints = (List)metricDataPointsList.get(i);
                int metricId = metricDefinitionIds[i];
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("mtid=" + metricId + ", rid=" + resource.getId() + ", startDate=" + startDate + ", endDate=" + endDate));
                }
                ArrayList<HighLowMetricValue> chartDataPoints = new ArrayList<HighLowMetricValue>(metricDataPoints.size());
                for (MeasurementDataNumericHighLowComposite metricDataPoint : metricDataPoints) {
                    HighLowMetricValue chartDataPoint = new HighLowMetricValue(metricDataPoint);
                    chartDataPoints.add(chartDataPoint);
                }
                List chartDataPointsList = (List)chartDataPointsListList.get(i);
                chartDataPointsList.add(chartDataPoints);
            }
        }
        request.getSession().setAttribute("chartDataKeys", (Object)chartKeys);
        request.getSession().setAttribute("chartDataKeysSize", (Object)chartKeys.length);
    }

    private void _setupPageData(HttpServletRequest request, ViewChartForm chartForm, List<Resource> resources, Subject subject) throws Exception {
        int[] metricDefinitionIds = new int[chartForm.getOrigM().length];
        for (int i = 0; i < chartForm.getOrigM().length; ++i) {
            metricDefinitionIds[i] = chartForm.getOrigM()[i];
        }
        ArrayList allMetricSummaries = new ArrayList();
        for (Resource resource : resources) {
            int[] metricScheduleIds = new int[metricDefinitionIds.length];
            for (int i = 0; i < metricDefinitionIds.length; ++i) {
                int definitionId = metricDefinitionIds[i];
                MeasurementSchedule schedule = this.scheduleManager.getSchedule(subject, resource.getId(), definitionId, false);
                metricScheduleIds[i] = schedule.getId();
            }
            List metricSummariesList = this.chartsManager.getMetricDisplaySummariesForResource(subject, resource.getId(), metricScheduleIds, chartForm.getStartDate().getTime(), chartForm.getEndDate().getTime());
            MonitorUtils.formatMetrics((List)metricSummariesList, (Locale)request.getLocale(), (MessageResources)this.getResources(request));
            allMetricSummaries.addAll(metricSummariesList);
        }
        Collections.sort(allMetricSummaries, comp);
        request.setAttribute("metricSummaries", allMetricSummaries);
        request.setAttribute("metricSummariesSize", (Object)allMetricSummaries.size());
        ChartedMetricBean[] chartedMetrics = new ChartedMetricBean[chartForm.getM().length];
        block3: for (int i = 0; i < chartedMetrics.length; ++i) {
            for (MetricDisplaySummary metricSummary : allMetricSummaries) {
                if (!metricSummary.getDefinitionId().equals(chartForm.getM()[i])) continue;
                MeasurementUnits units = MeasurementUnits.valueOf((String)metricSummary.getUnits());
                chartedMetrics[i] = new ChartedMetricBean(metricSummary.getLabel(), units, metricSummary.getCollectionType().intValue());
                continue block3;
            }
        }
        request.setAttribute("chartedMetrics", (Object)chartedMetrics);
    }

    private void _setupBaselineExpectedRange(HttpServletRequest request, ViewChartForm chartForm, List<Resource> resources, Subject subject) throws Exception {
        MeasurementDefinitionManagerLocal definitionManager = LookupUtil.getMeasurementDefinitionManager();
        MeasurementScheduleManagerLocal scheduleManager = LookupUtil.getMeasurementScheduleManager();
        MeasurementBaselineManagerLocal baselineManager = LookupUtil.getMeasurementBaselineManager();
        int metricId = chartForm.getM()[0];
        if (chartForm.getMode().equals("chartSingleMetricSingleResource") && metricId != 0) {
            Resource resource = resources.get(0);
            MeasurementSchedule schedule = scheduleManager.getSchedule(subject, resource.getId(), metricId, true);
            if (schedule.getDefinition().getNumericType() != NumericType.DYNAMIC) {
                chartForm.setSuppressBaselineSection(true);
                return;
            }
            MeasurementBaseline newBLValue = null;
            try {
                newBLValue = baselineManager.calculateAutoBaseline(subject, Integer.valueOf(schedule.getId()), chartForm.getStartDate().getTime(), chartForm.getEndDate().getTime(), false);
            }
            catch (BaselineCreationException e) {
                this.log.debug((Object)"Baseline could not be calculated, possibly  due to lack of data", (Throwable)e);
            }
            if (newBLValue != null) {
                chartForm.setNewBaseline(MeasurementConverter.format((Double)newBLValue.getMean(), (MeasurementUnits)schedule.getDefinition().getUnits(), (boolean)true));
                chartForm.setNewBaselineRaw(String.valueOf(newBLValue.getMean()));
            }
            this.setBaselineValues(schedule.getDefinition(), schedule.getBaseline(), chartForm);
            this.postProcessBaselines(request, chartForm);
        } else if (chartForm.getMode().equals("chartSingleMetricMultiResource") && metricId != 0) {
            MeasurementDefinition definition = definitionManager.getMeasurementDefinition(subject, metricId);
            if (definition.getNumericType() != NumericType.DYNAMIC) {
                chartForm.setSuppressBaselineSection(true);
                return;
            }
            MeasurementBaseline newBaseline = null;
            try {
                newBaseline = baselineManager.calculateAutoBaseline(LookupUtil.getSubjectManager().getOverlord(), chartForm.getGroupId(), chartForm.getM()[0].intValue(), chartForm.getStartDate().getTime(), chartForm.getEndDate().getTime(), false);
            }
            catch (BaselineCreationException e) {
                this.log.debug((Object)"Baseline could not be calculated, possibly  due to lack of data", (Throwable)e);
            }
            if (newBaseline != null) {
                chartForm.setNewBaseline(MeasurementConverter.format((Double)newBaseline.getMean(), (MeasurementUnits)definition.getUnits(), (boolean)true));
                chartForm.setNewBaselineRaw(String.valueOf(newBaseline.getMean()));
            }
            MeasurementBaseline baselineIfEqual = baselineManager.getBaselineIfEqual(subject, chartForm.getGroupId(), metricId);
            this.setBaselineValues(definition, baselineIfEqual, chartForm);
            this.postProcessBaselines(request, chartForm);
        }
    }

    private void setBaselineValues(MeasurementDefinition definition, MeasurementBaseline baseline, ViewChartForm chartForm) {
        if (baseline != null) {
            if (baseline.getMean() != null) {
                if (Math.abs(baseline.getMean() + 1.0) < 1.0E-9) {
                    chartForm.setBaseline("Multiple Values");
                    chartForm.setBaselineRaw("Multiple Values");
                } else {
                    chartForm.setBaseline(MeasurementConverter.format((Double)baseline.getMean(), (MeasurementUnits)definition.getUnits(), (boolean)true));
                    chartForm.setBaselineRaw(String.valueOf(baseline.getMean()));
                }
            }
            if (baseline.getMax() != null) {
                if (Math.abs(baseline.getMax() + 1.0) < 1.0E-9) {
                    chartForm.setHighRange("Multiple Values");
                    chartForm.setHighRangeRaw("Multiple Values");
                } else {
                    chartForm.setHighRange(MeasurementConverter.format((Double)baseline.getMax(), (MeasurementUnits)definition.getUnits(), (boolean)true));
                    chartForm.setHighRangeRaw(String.valueOf(baseline.getMax()));
                }
            }
            if (baseline.getMin() != null) {
                if (Math.abs(baseline.getMin() + 1.0) < 1.0E-9) {
                    chartForm.setLowRange("Multiple Values");
                    chartForm.setLowRangeRaw("Multiple Values");
                } else {
                    chartForm.setLowRange(MeasurementConverter.format((Double)baseline.getMin(), (MeasurementUnits)definition.getUnits(), (boolean)true));
                    chartForm.setLowRangeRaw(String.valueOf(baseline.getMin()));
                }
            }
        }
    }

    private void postProcessBaselines(HttpServletRequest request, ViewChartForm chartForm) {
        if (chartForm.getBaseline() == null || chartForm.getBaseline().length() == 0) {
            chartForm.setShowBaseline(false);
        } else {
            Boolean justSavedBaseline = (Boolean)request.getAttribute("justSavedBaseline");
            if (justSavedBaseline != null && justSavedBaseline.booleanValue()) {
                chartForm.setShowBaseline(true);
                Boolean baselineWasNull = (Boolean)request.getAttribute("baselineWasNull");
                if (baselineWasNull != null && baselineWasNull.booleanValue()) {
                    chartForm.setShowLowRange(true);
                    chartForm.setShowHighRange(true);
                }
            }
        }
        if (chartForm.getHighRange() == null || chartForm.getHighRange().length() == 0) {
            chartForm.setShowHighRange(false);
        } else {
            Boolean justSavedHighRange = (Boolean)request.getAttribute("justSavedHighRange");
            if (justSavedHighRange != null && justSavedHighRange.booleanValue()) {
                chartForm.setShowHighRange(true);
            }
        }
        if (chartForm.getLowRange() == null || chartForm.getLowRange().length() == 0) {
            chartForm.setShowLowRange(false);
        } else {
            Boolean justSavedLowRange = (Boolean)request.getAttribute("justSavedLowRange");
            if (justSavedLowRange != null && justSavedLowRange.booleanValue()) {
                chartForm.setShowLowRange(true);
            }
        }
    }

    private int _getMaxResources(HttpServletRequest request, int allResourcesLength) {
        int maxResources = 10;
        String maxResourcesS = RequestUtils.message((HttpServletRequest)request, (String)"resource.common.monitor.visibility.chart.MaxResources");
        if (null != maxResourcesS && !maxResourcesS.startsWith("???")) {
            try {
                maxResources = Integer.parseInt(maxResourcesS);
            }
            catch (NumberFormatException e) {
                this.log.trace((Object)("invalid resource.common.monitor.visibility.chart.MaxResources resource: " + maxResourcesS));
            }
        }
        if (maxResources > allResourcesLength) {
            maxResources = allResourcesLength;
        }
        return maxResources;
    }
}

