/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.hub;

import java.rmi.RemoteException;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.LabelValueBean;
import org.apache.struts.util.MessageResources;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.composite.ResourceGroupComposite;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.gui.legacy.HubConstants;
import org.rhq.enterprise.gui.legacy.Portal;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.action.resource.hub.GroupHubForm;
import org.rhq.enterprise.gui.legacy.action.resource.hub.HubForm;
import org.rhq.enterprise.gui.legacy.util.HubUtils;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.auth.SessionNotFoundException;
import org.rhq.enterprise.server.auth.SessionTimeoutException;
import org.rhq.enterprise.server.resource.InventorySummary;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupHubPortalAction
extends BaseAction {
    private static final String ALL_PLATFORMS_KEY = "resource.hub.filter.AllPlatformTypes";
    private static final String ALL_SERVERS_KEY = "resource.hub.filter.AllServerTypes";
    private static final String ALL_SERVICES_KEY = "resource.hub.filter.AllServiceTypes";
    public static final int SELECTOR_GROUP_COMPAT = 1;
    public static final int SELECTOR_GROUP_ADHOC = 2;
    protected Log log = LogFactory.getLog(GroupHubPortalAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String pluginName;
        GroupHubForm hubForm = (GroupHubForm)form;
        PageControl pageControl = WebUtility.getPageControl((ServletRequest)request);
        Subject subject = RequestUtils.getSubject((HttpServletRequest)request);
        HttpSession session = request.getSession();
        WebUser user = SessionUtils.getWebUser((HttpSession)request.getSession());
        HubUtils.initView((HubForm)hubForm, (WebUser)user);
        String groupName = this.getGroupName(request, hubForm);
        String resourceTypeName = HubConstants.ALL_RESOURCE_TYPES;
        ResourceCategory resourceCategory = null;
        if (hubForm.getResourceType() != null) {
            int typeId = 0;
            try {
                typeId = Integer.parseInt(hubForm.getResourceType().trim());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (typeId == -1) {
                resourceCategory = ResourceCategory.PLATFORM;
            } else if (typeId == -2) {
                resourceCategory = ResourceCategory.SERVER;
            } else if (typeId == -3) {
                resourceCategory = ResourceCategory.SERVICE;
            } else {
                resourceTypeName = this.decode(hubForm.getResourceType());
                if (resourceTypeName.equals("") || resourceTypeName.equals("ALL")) {
                    resourceTypeName = HubConstants.ALL_RESOURCE_TYPES;
                }
            }
        }
        if ((pluginName = hubForm.getPlugin()) != null && pluginName.trim().equals("")) {
            pluginName = null;
        }
        if (pluginName != null) {
            pluginName = this.decode(pluginName);
        }
        if (hubForm.getGroupCategory() == null) {
            hubForm.setGroupCategory(HubConstants.DEFAULT_GROUP_CATEGORY);
        }
        GroupCategory groupCategory = GroupCategory.valueOf((String)hubForm.getGroupCategory());
        PageList groups = this.getGroups(subject, groupCategory, resourceCategory, resourceTypeName, pluginName, groupName, pageControl);
        request.setAttribute("AllResources", (Object)groups);
        this.initGroupTypesPulldownMenu(request, hubForm, subject, groupCategory, groupName, resourceCategory, resourceTypeName, pluginName);
        this.initInventorySummary(subject, request);
        SessionUtils.resetReturnPath((HttpSession)request.getSession());
        Portal portal = Portal.createPortal((String)"resource.hub.ResourceHubTitle", (String)".group.hub");
        request.setAttribute("portal", (Object)portal);
        String navHierarchy = HubUtils.buildNavHierarchy((String)groupCategory.toString(), (String)resourceTypeName);
        request.setAttribute("navHierarchy", (Object)navHierarchy);
        return this.returnSuccess(request, mapping);
    }

    private void initInventorySummary(Subject user, HttpServletRequest request) throws SessionNotFoundException, SessionTimeoutException, RemoteException {
        InventorySummary summary = LookupUtil.getResourceBoss().getInventorySummary(user);
        request.setAttribute("ResourceSummary", (Object)summary);
    }

    private String getGroupName(HttpServletRequest request, GroupHubForm hubForm) {
        MessageResources res = this.getResources(request);
        String jsInserted = res.getMessage("resource.hub.search.KeywordSearchText");
        String groupName = hubForm.getKeywords();
        if (groupName != null && (groupName.equals("") || groupName.equals(jsInserted))) {
            groupName = HubConstants.DEFAULT_GROUP_NAME;
            hubForm.setKeywords(groupName);
        }
        return groupName;
    }

    private void initGroupTypesPulldownMenu(HttpServletRequest request, GroupHubForm hubForm, Subject subject, GroupCategory groupCategory, String nameFilter, ResourceCategory resourceCategory, String resourceTypeName, String pluginName) throws Exception {
        hubForm.addType(this.createMenuLabel(request, "resource.hub.filter.AllGroupTypes", "ALL"));
        if (groupCategory == GroupCategory.COMPATIBLE) {
            List allResourceTypes = LookupUtil.getResourceTypeManager().getResourceTypesForCompatibleGroups(subject, pluginName);
            TreeSet<String> platformTypes = new TreeSet<String>();
            TreeSet<String> serverTypes = new TreeSet<String>();
            TreeSet<String> serviceTypes = new TreeSet<String>();
            for (ResourceType type : allResourceTypes) {
                ResourceCategory category = type.getCategory();
                if (category == ResourceCategory.PLATFORM) {
                    platformTypes.add(type.getName());
                    continue;
                }
                if (category == ResourceCategory.SERVER) {
                    serverTypes.add(type.getName());
                    continue;
                }
                if (category == ResourceCategory.SERVICE) {
                    serviceTypes.add(type.getName());
                    continue;
                }
                throw new IllegalArgumentException("Unsupported ResourceCategory '" + category.name() + "' in GroupHubPortalAction.initGroupTypesPulldownMenu");
            }
            this.addResourceTypeMenuItems((HubForm)hubForm, platformTypes, RequestUtils.message((HttpServletRequest)request, (String)ALL_PLATFORMS_KEY), "-1");
            this.addResourceTypeMenuItems((HubForm)hubForm, serverTypes, RequestUtils.message((HttpServletRequest)request, (String)ALL_SERVERS_KEY), "-2");
            this.addResourceTypeMenuItems((HubForm)hubForm, serviceTypes, RequestUtils.message((HttpServletRequest)request, (String)ALL_SERVICES_KEY), "-3");
            hubForm.addPlugin(this.createMenuLabel(request, "resource.hub.filter.AllPlugins", ""));
            List plugins = LookupUtil.getResourceMetadataManager().getPluginsByResourceTypeAndCategory(resourceTypeName, resourceCategory);
            for (Plugin plugin : plugins) {
                hubForm.addPlugin(new LabelValueBean(plugin.getDisplayName(), this.encode(plugin.getName())));
            }
        }
    }

    public void addResourceTypeMenuItems(HubForm form, Set<String> typeNames, String headerLabel, String headerValue) {
        if (!typeNames.isEmpty()) {
            form.addType(new LabelValueBean("", ""));
            form.addType(new LabelValueBean(headerLabel, headerValue));
            for (String resourceTypeName : typeNames) {
                form.addType(new LabelValueBean(resourceTypeName, this.encode(resourceTypeName)));
            }
        }
    }

    protected LabelValueBean createMenuLabel(HttpServletRequest req, String key, String value) {
        MessageResources messages = this.getResources(req);
        return new LabelValueBean(messages.getMessage(key), value);
    }

    private PageList<ResourceGroupComposite> getGroups(Subject subject, GroupCategory groupCategory, ResourceCategory resourceCategory, String resourceTypeName, String pluginName, String nameFilter, PageControl pageControl) throws Exception {
        this.log.debug((Object)("Finding all " + groupCategory + "s with " + "resource category [" + resourceCategory + "] and " + "resource type [" + resourceTypeName + "] and " + "resource name [" + nameFilter + "]..."));
        if (groupCategory != GroupCategory.COMPATIBLE && groupCategory != GroupCategory.MIXED) {
            throw new RuntimeException("ResourceHub doesn't currently support " + groupCategory.toString() + " groupCategory");
        }
        this.log.debug((Object)"getting compatible group list");
        PageList groups = LookupUtil.getResourceGroupManager().findResourceGroupComposites(subject, groupCategory, resourceCategory, resourceTypeName, pluginName, nameFilter, null, null, pageControl);
        this.log.debug((Object)("found " + groups.size() + " groups"));
        return groups;
    }

    private String encode(String parameter) {
        return parameter.replaceAll(" ", "_");
    }

    private String decode(String parameter) {
        return parameter.replaceAll("_", " ");
    }
}

