/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.portlet.addresource;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.LabelValueBean;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.gui.util.StringUtility;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.WebUserPreferences;
import org.rhq.enterprise.gui.legacy.portlet.addresource.AddResourcesForm;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class AddResourcesPrepareAction
extends Action {
    private static final int DEFAULT_RESOURCE_TYPE = -1;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Log log = LogFactory.getLog(AddResourcesPrepareAction.class);
        AddResourcesForm addForm = (AddResourcesForm)form;
        HttpSession session = request.getSession();
        WebUser user = RequestUtils.getWebUser((HttpServletRequest)request);
        Subject subject = user.getSubject();
        ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
        PageControl pcAvail = WebUtility.getPageControl((ServletRequest)request, (String)"a");
        PageControl pcPending = WebUtility.getPageControl((ServletRequest)request, (String)"p");
        log.trace((Object)("available page control: " + pcAvail));
        log.trace((Object)("pending page control: " + pcPending));
        log.debug((Object)"check session if there are pending resources");
        List pendingResourceList = new ArrayList();
        if (session.getAttribute("PendingSessionResources") == null) {
            log.debug((Object)"get pending resources from user preferences");
            WebUserPreferences preferences = user.getWebPreferences();
            pendingResourceList = preferences.getPreferenceAsList(addForm.getKey(), "|");
            if (pendingResourceList != null) {
                log.debug((Object)"put entire list of pending resources in session");
                session.setAttribute("PendingSessionResources", pendingResourceList);
            }
        } else {
            pendingResourceList = SessionUtils.getListAsList((HttpSession)session, (String)"PendingSessionResources");
        }
        log.debug((Object)"get page of pending resources selected by user");
        int[] pendingResourceArray = StringUtility.getIntArray(pendingResourceList);
        PageList pendingResources = resourceManager.findResourceByIds(subject, pendingResourceArray, false, pcPending);
        log.debug((Object)"put selected page of pending resources in request");
        request.setAttribute("PendingResources", (Object)pendingResources);
        request.setAttribute("NumPendingResources", (Object)pendingResources.getTotalSize());
        log.debug((Object)"determine if user wants to filter available resources");
        Integer typeIdFilter = addForm.getType() == null || addForm.getType() == -1 ? null : addForm.getType();
        ResourceCategory categoryFilter = addForm.getCategory() != null ? ResourceCategory.valueOf((String)addForm.getCategory().toUpperCase()) : ResourceCategory.PLATFORM;
        int[] excludeIds = StringUtility.getIntArray(pendingResourceList);
        PageList availableResources = null;
        availableResources = resourceManager.findAvailableResourcesForDashboardPortlet(subject, typeIdFilter, categoryFilter, excludeIds, pcAvail);
        log.debug((Object)"put selected page of available resources in request");
        request.setAttribute("AvailableResources", (Object)availableResources);
        request.setAttribute("NumAvailableResources", (Object)availableResources.getTotalSize());
        log.debug((Object)"get the available resources user can filter by");
        this.setDropDowns(addForm, request, subject, categoryFilter);
        return null;
    }

    private void setDropDowns(AddResourcesForm addForm, HttpServletRequest request, Subject subject, ResourceCategory category) throws Exception {
        for (ResourceCategory nextCategory : ResourceCategory.values()) {
            addForm.addFunction(new LabelValueBean(nextCategory.toString(), nextCategory.name()));
        }
        ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
        List resourceTypes = resourceTypeManager.getUtilizedResourceTypesByCategory(subject, category, null);
        for (ResourceType nextType : resourceTypes) {
            addForm.addType(new LabelValueBean(nextType.getName(), String.valueOf(nextType.getId())));
        }
    }
}

