/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.taglib.display;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.enterprise.gui.legacy.taglib.display.AvailabilityDecorator;
import org.rhq.enterprise.gui.legacy.taglib.display.ColumnDecorator;
import org.rhq.enterprise.gui.legacy.taglib.display.ColumnTag;

public class AvailabilityDecorator
extends ColumnDecorator
implements Tag {
    private static final String ICON_WIDTH = "15";
    private static final String ICON_HEIGHT = "15";
    private static final String ICON_BORDER = "0";
    private static final String ICON_UP = "/images/icons/availability_green_16.png";
    private static final String ICON_DOWN = "/images/icons/availability_red_16.png";
    private static final String ICON_WARN = "/images/icons/availability_yellow_16.png";
    private static final String ICON_ERR = "/images/icons/availability_grey_16.png";
    private PageContext context;
    private Tag parent;

    public String decorate(Object obj) throws Exception {
        return this.getOutputByValue(obj);
    }

    private String getOutputByValue(Object availability) throws JspException {
        String availabilityMessage;
        HttpServletRequest req = (HttpServletRequest)this.context.getRequest();
        StringBuilder iconURL = new StringBuilder(req.getContextPath());
        if (availability instanceof AvailabilityType) {
            availabilityMessage = ((AvailabilityType)availability).name();
            switch (1.$SwitchMap$org$rhq$core$domain$measurement$AvailabilityType[((AvailabilityType)availability).ordinal()]) {
                case 1: {
                    iconURL.append(ICON_UP);
                    availabilityMessage = "Up";
                    break;
                }
                case 2: {
                    iconURL.append(ICON_DOWN);
                    availabilityMessage = "Down";
                }
            }
        } else if (availability instanceof Number) {
            double a = ((Number)availability).doubleValue();
            if (a == 1.0) {
                iconURL.append(ICON_UP);
                availabilityMessage = "Up";
            } else if (a == 0.0) {
                iconURL.append(ICON_DOWN);
                availabilityMessage = "Down";
            } else if (a > 0.0 && a < 1.0) {
                iconURL.append(ICON_WARN);
                availabilityMessage = "Mixed";
            } else {
                iconURL.append(ICON_ERR);
                availabilityMessage = "Unknown";
            }
        } else if (availability == null) {
            iconURL.append(ICON_ERR);
            availabilityMessage = "Unknown";
        } else {
            throw new IllegalStateException("Value of property attribute must be of type AvailabilityType or Number - its type is " + availability.getClass().getName() + ".");
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<img src=\"").append((CharSequence)iconURL).append("\" ");
        buf.append("width=\"").append("15").append("\" ");
        buf.append("height=\"").append("15").append("\" ");
        buf.append("alt=\"").append(availabilityMessage).append("\" ");
        buf.append("title=\"").append(availabilityMessage).append("\" ");
        buf.append("border=\"").append(ICON_BORDER).append("\">");
        return buf.toString();
    }

    public int doStartTag() throws JspTagException {
        ColumnTag ancestorTag = (ColumnTag)TagSupport.findAncestorWithClass((Tag)this, ColumnTag.class);
        if (ancestorTag == null) {
            throw new JspTagException("An AvailabilityDecorator must be used within a ColumnTag.");
        }
        ancestorTag.setDecorator((ColumnDecorator)this);
        return 0;
    }

    public int doEndTag() {
        return 6;
    }

    public Tag getParent() {
        return this.parent;
    }

    public void setParent(Tag t) {
        this.parent = t;
    }

    public void setPageContext(PageContext pc) {
        this.context = pc;
    }

    public void release() {
        this.parent = null;
        this.context = null;
    }
}

