/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.measurement;

import java.util.ArrayList;
import java.util.List;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.DisplayType;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraitListBean {
    private List<List<MeasurementDataTrait>> traitPairs;
    private int totalTraits;
    private MeasurementDataManagerLocal dataManager = LookupUtil.getMeasurementDataManager();

    private void load() {
        int resourceId = EnterpriseFacesContextUtility.getResource().getId();
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        List traits = this.dataManager.findCurrentTraitsForResource(subject, resourceId, DisplayType.SUMMARY);
        this.totalTraits = traits.size();
        int middleIndex = (this.totalTraits + 1) / 2;
        this.traitPairs = new ArrayList(middleIndex);
        if (this.totalTraits > 0) {
            List leftColumnTraits = traits.subList(0, middleIndex);
            List rightColumnTraits = traits.subList(middleIndex, this.totalTraits);
            for (int i = 0; i < leftColumnTraits.size(); ++i) {
                ArrayList traitPair = new ArrayList(2);
                traitPair.add(leftColumnTraits.get(i));
                if (i < rightColumnTraits.size()) {
                    traitPair.add(rightColumnTraits.get(i));
                } else {
                    traitPair.add(null);
                }
                this.traitPairs.add(traitPair);
            }
        }
    }

    public List<List<MeasurementDataTrait>> getTraitPairs() {
        if (this.traitPairs == null) {
            try {
                this.load();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.traitPairs;
    }

    public int getTotalTraits() {
        if (this.traitPairs == null) {
            this.load();
        }
        return this.totalTraits;
    }
}

