/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.uibeans;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import org.rhq.enterprise.gui.image.data.ITreeNode;

public class TreeNode
implements ITreeNode,
Serializable {
    public static final int NO_CTYPE = -1;
    private String desc;
    private String name;
    private ArrayList rectangles = new ArrayList(2);
    private boolean selected;
    protected ArrayList upChildren = new ArrayList();
    protected ArrayList downChildren = new ArrayList();

    public TreeNode(String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.desc;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public Rectangle[] getRectangles() {
        return this.rectangles.toArray(new Rectangle[0]);
    }

    public void addRectangle(int x, int y, int cx, int cy) {
        this.rectangles.add(new Rectangle(x, y, cx, cy));
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void addUpChild(ITreeNode child) {
        this.upChildren.add(child);
    }

    public void addUpChildren(ITreeNode[] children) {
        for (int i = 0; i < children.length; ++i) {
            this.upChildren.add(children[i]);
        }
    }

    public ITreeNode[] getUpChildren() {
        return this.upChildren.toArray(new ITreeNode[0]);
    }

    public int getUpChildrenCount() {
        return this.upChildren.size();
    }

    public boolean hasUpChildren() {
        return this.getUpChildrenCount() > 0;
    }

    public void addDownChild(ITreeNode child) {
        this.downChildren.add(child);
    }

    public void addDownChildren(ITreeNode[] children) {
        for (int i = 0; i < children.length; ++i) {
            this.downChildren.add(children[i]);
        }
    }

    public void replaceDownChildren(ITreeNode[] children) {
        this.downChildren.clear();
        this.addDownChildren(children);
    }

    public void replaceUpChildren(ITreeNode[] children) {
        this.upChildren.clear();
        this.addUpChildren(children);
    }

    public ITreeNode[] getDownChildren() {
        return this.downChildren.toArray(new ITreeNode[0]);
    }

    public int getDownChildrenCount() {
        return this.downChildren.size();
    }

    public boolean hasDownChildren() {
        return this.getDownChildrenCount() > 0;
    }

    public void clear() {
        this.upChildren.clear();
        this.downChildren.clear();
    }

    public void reset() {
        this.rectangles.clear();
    }

    public boolean equals(Object o) {
        boolean thisHasDescription;
        if (!(o instanceof TreeNode)) {
            return false;
        }
        TreeNode other = (TreeNode)o;
        if (other == null) {
            return false;
        }
        boolean otherHasDescription = other.getDescription() != null;
        boolean bl = thisHasDescription = this.getDescription() != null;
        if (otherHasDescription != thisHasDescription) {
            return false;
        }
        if (otherHasDescription && thisHasDescription && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        return other.getName().equals(this.getName()) && other.isSelected() == this.isSelected() && other.hasDownChildren() == this.hasDownChildren() && other.hasUpChildren() == this.hasUpChildren();
    }

    public int hashCode() {
        int result = 19;
        int pri = 13;
        result = pri * result + (this.getName() != null ? this.getName().length() : 0);
        result = pri * result + (this.getDescription() != null ? this.getDescription().length() : 0);
        Rectangle[] rects = this.getRectangles();
        if (rects != null) {
            for (int i = 0; i < rects.length; ++i) {
                result = pri * result + (int)rects[i].getX();
                result = pri * result + (int)rects[i].getY();
                result = pri * result + (int)rects[i].getWidth();
                result = pri * result + (int)rects[i].getLocation().getX();
                result = pri * result + (int)rects[i].getLocation().getY();
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" name:").append(this.getName()).append(" description:").append(this.getDescription()).append(" isSel:").append(this.isSelected());
        Rectangle[] rects = this.getRectangles();
        if (rects != null) {
            for (int i = 0; i < rects.length; ++i) {
                sb.append(" rect[").append(i).append("]:").append(rects[i]);
            }
        }
        return sb.toString();
    }
}

