/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.client;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import mazz.i18n.Logger;
import org.rhq.enterprise.communications.command.client.ClientCommandSenderConfiguration;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommandQueue
implements BlockingQueue<Runnable> {
    private static final Logger LOG = CommI18NFactory.getLogger(CommandQueue.class);
    private LinkedBlockingQueue<Runnable> m_queue;
    private Semaphore m_throttleSemaphore;
    private Object m_throttleLock;
    private long m_queueThrottleMaxCommands;
    private long m_queueThrottleBurstPeriodDurationMillis;
    private AtomicInteger m_waitingForAcquire;

    public CommandQueue(ClientCommandSenderConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException(LOG.getMsgString("CommandQueue.null-config", new Object[0]));
        }
        this.m_throttleLock = new Object();
        this.m_throttleSemaphore = null;
        this.m_waitingForAcquire = new AtomicInteger(0);
        this.m_queue = config.queueSize > 0 ? new LinkedBlockingQueue(config.queueSize) : new LinkedBlockingQueue();
        this.setQueueThrottleParameters(config);
        if (config.enableQueueThrottling) {
            this.enableQueueThrottling();
        } else {
            this.disableQueueThrottling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueueThrottleParameters(ClientCommandSenderConfiguration config) {
        Object object = this.m_throttleLock;
        synchronized (object) {
            this.m_queueThrottleMaxCommands = config.queueThrottleMaxCommands;
            this.m_queueThrottleBurstPeriodDurationMillis = config.queueThrottleBurstPeriodMillis;
            LOG.debug("CommandQueue.configured", new Object[]{this.m_queueThrottleMaxCommands, this.m_queueThrottleBurstPeriodDurationMillis});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableQueueThrottling() {
        Object object = this.m_throttleLock;
        synchronized (object) {
            if (this.isThrottlingEnabled()) {
                this.disableQueueThrottling();
            }
            this.m_throttleSemaphore = new Semaphore((int)this.m_queueThrottleMaxCommands);
            ThrottleRunnable throttleRunnable = new ThrottleRunnable((int)this.m_queueThrottleMaxCommands, this.m_queueThrottleBurstPeriodDurationMillis);
            Thread thread = new Thread((Runnable)throttleRunnable, "RHQ Command Queue Throttle Thread");
            thread.setDaemon(true);
            thread.start();
            LOG.debug("CommandQueue.enabled", new Object[]{this.m_queueThrottleMaxCommands, this.m_queueThrottleBurstPeriodDurationMillis});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableQueueThrottling() {
        Object object = this.m_throttleLock;
        synchronized (object) {
            if (this.m_throttleSemaphore != null) {
                this.m_throttleSemaphore.release(this.m_waitingForAcquire.get() + 1000);
            }
            this.m_throttleSemaphore = null;
            this.m_throttleLock.notifyAll();
        }
        LOG.debug("CommandQueue.disabled", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isThrottlingEnabled() {
        Object object = this.m_throttleLock;
        synchronized (object) {
            return this.m_throttleSemaphore != null;
        }
    }

    @Override
    public void put(Runnable obj) throws InterruptedException {
        this.m_queue.put(obj);
    }

    @Override
    public boolean offer(Runnable obj, long timeout, TimeUnit timeunit) throws InterruptedException {
        return this.m_queue.offer(obj, timeout, timeunit);
    }

    @Override
    public boolean offer(Runnable o) {
        try {
            return this.offer(o, 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public Runnable take() throws InterruptedException {
        this.acquireSemaphorePermit();
        Runnable ret_obj = this.m_queue.take();
        return ret_obj;
    }

    @Override
    public Runnable poll(long timeout, TimeUnit timeunit) throws InterruptedException {
        this.acquireSemaphorePermit();
        Runnable ret_val = this.m_queue.poll(timeout, timeunit);
        return ret_val;
    }

    @Override
    public Runnable poll() {
        try {
            return this.poll(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public Runnable peek() {
        return this.m_queue.peek();
    }

    @Override
    public int drainTo(Collection<? super Runnable> c, int maxElements) {
        return this.m_queue.drainTo(c, maxElements);
    }

    @Override
    public int drainTo(Collection<? super Runnable> c) {
        return this.m_queue.drainTo(c);
    }

    @Override
    public int remainingCapacity() {
        return this.m_queue.remainingCapacity();
    }

    @Override
    public boolean add(Runnable o) {
        if (!this.offer(o)) {
            throw new IllegalStateException();
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Runnable> c) {
        boolean changed = false;
        for (Runnable runnable : c) {
            if (!this.offer(runnable)) {
                throw new IllegalArgumentException("Cannot add: " + runnable);
            }
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.drainTo(new LinkedList());
    }

    @Override
    public boolean contains(Object o) {
        return this.m_queue.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.m_queue.containsAll(c);
    }

    @Override
    public Runnable element() {
        return (Runnable)this.m_queue.element();
    }

    @Override
    public boolean isEmpty() {
        return this.m_queue.isEmpty();
    }

    @Override
    public Iterator<Runnable> iterator() {
        return this.m_queue.iterator();
    }

    @Override
    public Runnable remove() {
        Runnable task = this.poll();
        if (task == null) {
            throw new NoSuchElementException();
        }
        return task;
    }

    @Override
    public boolean remove(Object o) {
        return this.m_queue.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.m_queue.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.m_queue.retainAll(c);
    }

    @Override
    public int size() {
        return this.m_queue.size();
    }

    @Override
    public Object[] toArray() {
        return this.m_queue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.m_queue.toArray(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireSemaphorePermit() throws InterruptedException {
        Semaphore semaphore = null;
        Object object = this.m_throttleLock;
        synchronized (object) {
            if (this.m_throttleSemaphore != null) {
                semaphore = this.m_throttleSemaphore;
                this.m_waitingForAcquire.incrementAndGet();
            }
        }
        if (semaphore != null) {
            semaphore.acquire();
            this.m_waitingForAcquire.decrementAndGet();
        }
    }

    private class ThrottleRunnable
    implements Runnable {
        private long m_sleepMillis;
        private int m_numPermits;

        public ThrottleRunnable(int num_permits, long sleep_millis) {
            this.m_numPermits = num_permits;
            this.m_sleepMillis = sleep_millis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = CommandQueue.this.m_throttleLock;
            synchronized (object) {
                while (CommandQueue.this.m_throttleSemaphore != null) {
                    try {
                        CommandQueue.this.m_throttleLock.wait(this.m_sleepMillis);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (CommandQueue.this.m_throttleSemaphore == null) continue;
                    CommandQueue.this.m_throttleSemaphore.release(this.m_numPermits - CommandQueue.this.m_throttleSemaphore.availablePermits());
                }
            }
        }
    }
}

