/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine.jms;

import java.io.Serializable;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import org.rhq.enterprise.server.alert.engine.jms.CachedConditionProducerLocal;
import org.rhq.enterprise.server.alert.engine.jms.model.ActiveAlertConditionMessage;
import org.rhq.enterprise.server.alert.engine.jms.model.InactiveAlertConditionMessage;
import org.rhq.enterprise.server.alert.engine.model.AbstractCacheElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class CachedConditionProducerBean
implements CachedConditionProducerLocal {
    @Resource(mappedName="java:/JmsXA")
    private ConnectionFactory factory;
    @Resource(mappedName="queue/AlertConditionQueue")
    private Queue alertConditionQueue;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public <T extends AbstractCacheElement<S>, S> void sendActivateAlertConditionMessage(int alertConditionId, long timestamp, S value, Object ... extraParams) throws JMSException {
        Connection connection = this.factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer sender = session.createProducer((Destination)this.alertConditionQueue);
        ActiveAlertConditionMessage conditionMessage = new ActiveAlertConditionMessage(alertConditionId, timestamp, value.toString(), extraParams);
        ObjectMessage message = session.createObjectMessage((Serializable)conditionMessage);
        sender.send((Message)message);
        connection.close();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void sendDeactivateAlertConditionMessage(int alertConditionId, long timestamp) throws JMSException {
        Connection connection = this.factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer sender = session.createProducer((Destination)this.alertConditionQueue);
        InactiveAlertConditionMessage conditionMessage = new InactiveAlertConditionMessage(alertConditionId, timestamp);
        ObjectMessage message = session.createObjectMessage((Serializable)conditionMessage);
        sender.send((Message)message);
        connection.close();
    }
}

