/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.search.translation;

import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.server.search.SearchExpressionException;
import org.rhq.enterprise.server.search.translation.SearchTranslator;
import org.rhq.enterprise.server.search.translation.antlr.RHQLComparisonOperator;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSearchTranslator
implements SearchTranslator {
    private int subjectId;
    private boolean requiresAuthorizationFragment;

    public AbstractSearchTranslator(Subject subject) {
        this.subjectId = subject.getId();
        this.requiresAuthorizationFragment = !LookupUtil.getAuthorizationManager().isInventoryManager(subject);
    }

    public int getSubjectId() {
        return this.subjectId;
    }

    public boolean requiresAuthorizationFragment() {
        return this.requiresAuthorizationFragment;
    }

    protected final String conditionallyAddAuthzFragment(String fragment) {
        if (!this.requiresAuthorizationFragment) {
            return "";
        }
        return " AND " + fragment;
    }

    protected String getJPQLForEnum(String fragment, RHQLComparisonOperator operator, String value, Class<? extends Enum<?>> enumClass, boolean useOrdinal) {
        if (operator == RHQLComparisonOperator.NULL || operator == RHQLComparisonOperator.NOT_NULL) {
            return fragment + operator.getDefaultTranslation();
        }
        if (operator == RHQLComparisonOperator.EQUALS || operator == RHQLComparisonOperator.EQUALS_STRICT || operator == RHQLComparisonOperator.NOT_EQUALS || operator == RHQLComparisonOperator.NOT_EQUALS_STRICT) {
            return fragment + operator.getDefaultTranslation() + this.getEnum(enumClass, value, useOrdinal);
        }
        throw new SearchExpressionException("Unsupported operator " + (Object)((Object)operator));
    }

    private String getEnum(Class<? extends Enum<?>> enumClass, String value, boolean useOrdinal) {
        value = value.toLowerCase();
        for (Enum<?> nextEnum : enumClass.getEnumConstants()) {
            if (!nextEnum.name().toLowerCase().equals(value)) continue;
            if (useOrdinal) {
                return String.valueOf(nextEnum.ordinal());
            }
            return this.quote(nextEnum.name());
        }
        throw new SearchExpressionException("No enum of type '" + enumClass.getSimpleName() + "' with name matching '" + value + "'");
    }

    protected String quote(String data) {
        return "'" + data + "'";
    }

    protected final String addFragmentIfParameterNotValue(String fragment, String parameter, String value) {
        if (!parameter.equalsIgnoreCase(value)) {
            return fragment;
        }
        return "";
    }
}

