/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.server.discovery;

import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.remoting.network.NetworkNotification;
import org.rhq.enterprise.communications.ServiceContainer;
import org.rhq.enterprise.communications.command.server.CommandMBean;
import org.rhq.enterprise.communications.command.server.discovery.AutoDiscoveryException;
import org.rhq.enterprise.communications.command.server.discovery.AutoDiscoveryMBean;

public abstract class AutoDiscovery
extends CommandMBean
implements AutoDiscoveryMBean,
NotificationListener {
    private static final String DEFAULT_NETWORK_REGISTRY_NAME = ServiceContainer.OBJECTNAME_NETWORK_REGISTRY.toString();
    private ObjectName m_networkRegistryName = null;
    private boolean m_listening = false;

    public String getNetworkRegistryName() {
        return this.m_networkRegistryName.toString();
    }

    public void setNetworkRegistryName(String name) {
        if (this.m_networkRegistryName != null) {
            try {
                this.unregisterNotificationListener();
            }
            catch (AutoDiscoveryException ade) {
                this.getLog().warn((Throwable)ade, "AutoDiscovery.failed-to-stop-listening", new Object[0]);
            }
        }
        try {
            this.m_networkRegistryName = new ObjectName(name);
        }
        catch (MalformedObjectNameException moe) {
            throw new IllegalArgumentException(this.getLog().getMsgString("AutoDiscovery.invalid-registry-name", new Object[]{moe}));
        }
        this.getLog().info("AutoDiscovery.registry-name", new Object[]{name});
        try {
            this.registerNotificationListener();
        }
        catch (AutoDiscoveryException ade) {
            this.getLog().warn((Throwable)ade, "AutoDiscovery.failed-to-start-listening", new Object[]{name});
        }
    }

    public ObjectName getNetworkRegistryObjectName() {
        return this.m_networkRegistryName;
    }

    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof NetworkNotification) {
            NetworkNotification networkNotification = (NetworkNotification)notification;
            String notifType = networkNotification.getType();
            if ("jboss.network.server.added".equals(notifType)) {
                this.discoveredNewServers(networkNotification);
            } else if ("jboss.network.server.removed".equals(notifType)) {
                this.discoveredRemovedServers(networkNotification);
            } else if ("jboss.network.server.updated".equals(notifType)) {
                this.discoveredUpdatedServers(networkNotification);
            } else if ("jboss.network.domain.changed".equals(notifType)) {
                this.discoveredChangedDomain(networkNotification);
            } else {
                this.getLog().warn("AutoDiscovery.unknown-notif-type", new Object[]{notifType});
            }
        } else {
            this.getLog().warn("AutoDiscovery.unknown-notif", new Object[]{notification.getClass()});
        }
    }

    public void stopService() {
        try {
            this.unregisterNotificationListener();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerNotificationListener() throws AutoDiscoveryException {
        if (!this.m_listening) {
            try {
                if (this.m_networkRegistryName == null) {
                    this.setNetworkRegistryName(DEFAULT_NETWORK_REGISTRY_NAME);
                }
                this.getMBeanServer().addNotificationListener(this.m_networkRegistryName, this, null, null);
                this.m_listening = true;
            }
            catch (Exception e) {
                throw new AutoDiscoveryException(this.getLog().getMsgString("AutoDiscovery.failed-to-start-listening", new Object[]{this.m_networkRegistryName}), e);
            }
        }
    }

    private void unregisterNotificationListener() throws AutoDiscoveryException {
        if (this.m_listening) {
            try {
                this.getMBeanServer().removeNotificationListener(this.m_networkRegistryName, this);
            }
            catch (ListenerNotFoundException e) {
            }
            catch (InstanceNotFoundException e) {
            }
            catch (Exception e) {
                throw new AutoDiscoveryException(this.getLog().getMsgString("AutoDiscovery.unregister-failure", new Object[]{this.m_networkRegistryName}), e);
            }
            this.m_listening = false;
        }
    }

    public abstract void discoveredNewServers(NetworkNotification var1);

    public abstract void discoveredRemovedServers(NetworkNotification var1);

    public abstract void discoveredUpdatedServers(NetworkNotification var1);

    public abstract void discoveredChangedDomain(NetworkNotification var1);
}

