/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client.proxy;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javax.jws.WebParam;
import org.rhq.core.domain.resource.ResourceCreationDataType;
import org.rhq.enterprise.client.ClientMain;
import org.rhq.enterprise.client.RemoteClient;
import org.rhq.enterprise.client.proxy.ResourceClientProxy;
import org.rhq.enterprise.client.utility.ConfigurationClassBuilder;

public class ResourceClientFactory {
    private ClientMain clientMain;
    private RemoteClient remoteClient;
    private static AtomicInteger classIndex = new AtomicInteger();

    public ResourceClientFactory(ClientMain clientMain) {
        this.clientMain = clientMain;
        this.remoteClient = clientMain.getRemoteClient();
    }

    public ResourceClientProxy getResource(int resourceId) {
        ResourceClientProxy proxy = new ResourceClientProxy(this.clientMain, resourceId);
        Class customInterface = null;
        try {
            ClassPool pool = ClassPool.getDefault();
            CtClass customClass = pool.makeInterface(ResourceClientProxy.class.getName() + "__Custom__" + classIndex.getAndIncrement());
            for (String key : proxy.allProperties.keySet()) {
                Object prop = proxy.allProperties.get(key);
                if (prop instanceof ResourceClientProxy.Measurement) {
                    ResourceClientProxy.Measurement m = (ResourceClientProxy.Measurement)prop;
                    String name = ResourceClientProxy.getterName(key);
                    try {
                        ResourceClientProxy.class.getMethod(name, new Class[0]);
                    }
                    catch (NoSuchMethodException nsme) {
                        CtMethod method = CtNewMethod.abstractMethod((CtClass)pool.get(ResourceClientProxy.Measurement.class.getName()), (String)ResourceClientProxy.getterName(key), (CtClass[])new CtClass[0], (CtClass[])new CtClass[0], (CtClass)customClass);
                        customClass.addMethod(method);
                    }
                    continue;
                }
                if (!(prop instanceof ResourceClientProxy.Operation)) continue;
                ResourceClientProxy.Operation o = (ResourceClientProxy.Operation)prop;
                LinkedHashMap<String, CtClass> types = ConfigurationClassBuilder.translateParameters(o.getDefinition().getParametersConfigurationDefinition());
                CtClass[] params = new CtClass[types.size()];
                int x = 0;
                for (String param : types.keySet()) {
                    params[x++] = types.get(param);
                }
                CtMethod method = CtNewMethod.abstractMethod((CtClass)ConfigurationClassBuilder.translateConfiguration(o.getDefinition().getResultsConfigurationDefinition()), (String)ResourceClientProxy.simpleName(key), (CtClass[])params, (CtClass[])new CtClass[0], (CtClass)customClass);
                Annotation[][] newAnnotations = new Annotation[params.length][1];
                int i = 0;
                for (String paramName : types.keySet()) {
                    newAnnotations[i] = new Annotation[1];
                    newAnnotations[i][0] = new Annotation(WebParam.class.getName(), method.getMethodInfo().getConstPool());
                    newAnnotations[i][0].addMemberValue("name", (MemberValue)new StringMemberValue(paramName, method.getMethodInfo().getConstPool()));
                    ++i;
                }
                ParameterAnnotationsAttribute newAnnotationsAttribute = new ParameterAnnotationsAttribute(method.getMethodInfo().getConstPool(), "RuntimeVisibleParameterAnnotations");
                newAnnotationsAttribute.setAnnotations(newAnnotations);
                method.getMethodInfo().addAttribute((AttributeInfo)newAnnotationsAttribute);
                customClass.addMethod(method);
            }
            customInterface = customClass.toClass();
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (customInterface != null) {
            ArrayList<Class<ResourceClientProxy.ContentBackedResource>> interfaces = new ArrayList<Class<ResourceClientProxy.ContentBackedResource>>();
            interfaces.add(customInterface);
            if (proxy.resourceConfigurationDefinition != null) {
                interfaces.add(ResourceClientProxy.ResourceConfigurable.class);
            }
            if (proxy.pluginConfigurationDefinition != null) {
                interfaces.add(ResourceClientProxy.PluginConfigurable.class);
            }
            if (proxy.getResourceType().getCreationDataType() == ResourceCreationDataType.CONTENT) {
                interfaces.add(ResourceClientProxy.ContentBackedResource.class);
            }
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.setInterfaces(interfaces.toArray(new Class[interfaces.size()]));
            proxyFactory.setSuperclass(ResourceClientProxy.class);
            ResourceClientProxy proxied = null;
            try {
                proxied = (ResourceClientProxy)proxyFactory.create(new Class[0], new Object[0], (MethodHandler)new ResourceClientProxy.ClientProxyMethodHandler(proxy, this.remoteClient));
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return proxied;
        }
        return proxy;
    }
}

