/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client.proxy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.MethodHandler;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PluginConfigurationUpdate;
import org.rhq.core.domain.configuration.ResourceConfigurationUpdate;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.content.InstalledPackage;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.criteria.MeasurementDefinitionCriteria;
import org.rhq.core.domain.criteria.OperationDefinitionCriteria;
import org.rhq.core.domain.criteria.PackageVersionCriteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.criteria.ResourceOperationHistoryCriteria;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementCategory;
import org.rhq.core.domain.measurement.MeasurementData;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.domain.util.Summary;
import org.rhq.core.server.MeasurementConverter;
import org.rhq.enterprise.client.ClientMain;
import org.rhq.enterprise.client.RemoteClient;
import org.rhq.enterprise.client.proxy.ConfigurationEditor;
import org.rhq.enterprise.client.proxy.ResourceClientFactory;
import org.rhq.enterprise.client.utility.ConfigurationClassBuilder;
import org.rhq.enterprise.client.utility.LazyLoadScenario;
import org.rhq.enterprise.client.utility.ScriptUtil;
import org.rhq.enterprise.client.utility.ShortOutput;
import org.rhq.enterprise.server.content.ContentManagerRemote;
import org.rhq.enterprise.server.operation.ResourceOperationSchedule;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceClientProxy {
    private ClientMain client;
    private RemoteClient remoteClient;
    private int resourceId;
    private Resource resource;
    Map<String, Object> allProperties = new HashMap<String, Object>();
    private List<MeasurementDefinition> measurementDefinitions;
    private Map<String, Measurement> measurementMap = new HashMap<String, Measurement>();
    private List<OperationDefinition> operationDefinitions;
    private Map<String, Operation> operationMap = new HashMap<String, Operation>();
    private Map<String, ContentType> contentTypes = new HashMap<String, ContentType>();
    private List<ResourceClientProxy> children;
    ConfigurationDefinition resourceConfigurationDefinition;
    ConfigurationDefinition pluginConfigurationDefinition;

    public ResourceClientProxy() {
    }

    public ResourceClientProxy(ResourceClientProxy parentProxy) {
        this.client = parentProxy.client;
        this.remoteClient = parentProxy.remoteClient;
        this.resourceId = parentProxy.resourceId;
        this.resource = parentProxy.resource;
        this.allProperties = parentProxy.allProperties;
        this.measurementDefinitions = parentProxy.measurementDefinitions;
        this.measurementMap = parentProxy.measurementMap;
        this.children = parentProxy.children;
    }

    public ResourceClientProxy(ClientMain clientMain, int resourceId) {
        this.client = clientMain;
        this.remoteClient = this.client.getRemoteClient();
        this.resourceId = resourceId;
        this.init();
    }

    @Summary(index=0)
    public int getId() {
        return this.resourceId;
    }

    @Summary(index=1)
    public String getName() {
        return this.resource.getName();
    }

    public String getDescription() {
        return this.resource.getDescription();
    }

    @Summary(index=2)
    public String getVersion() {
        return this.resource.getVersion();
    }

    @Summary(index=3)
    public ResourceType getResourceType() {
        return this.resource.getResourceType();
    }

    public Date getCreatedDate() {
        return new Date(this.resource.getCtime());
    }

    public Date getModifiedDate() {
        return new Date(this.resource.getCtime());
    }

    public Measurement getMeasurement(String name) {
        return this.measurementMap.get(name);
    }

    public Measurement[] getMeasurements() {
        return this.measurementMap.values().toArray(new Measurement[this.measurementMap.size()]);
    }

    public Operation[] getOperations() {
        return this.operationMap.values().toArray(new Operation[this.operationMap.size()]);
    }

    public Map<String, ContentType> getContentTypes() {
        return this.contentTypes;
    }

    public ResourceClientProxy[] getChildren() {
        if (this.children == null && LazyLoadScenario.isShouldLoad()) {
            this.children = new ArrayList<ResourceClientProxy>();
            this.initChildren();
        }
        return this.children.toArray(new ResourceClientProxy[this.children.size()]);
    }

    public ResourceClientProxy getChild(String name) {
        for (ResourceClientProxy child : this.getChildren()) {
            if (!name.equals(child.getName())) continue;
            return child;
        }
        return null;
    }

    public String toString() {
        return "[" + this.resourceId + "] " + this.resource.getName() + " (" + this.resource.getResourceType().getName() + "::" + this.resource.getResourceType().getPlugin() + ")";
    }

    public void init() {
        this.resource = this.remoteClient.getResourceManagerRemote().getResource(this.remoteClient.getSubject(), this.resourceId);
        this.initMeasurements();
        this.initOperations();
        this.initConfigDefs();
        this.initContent();
    }

    private void initConfigDefs() {
        this.resourceConfigurationDefinition = this.remoteClient.getConfigurationManagerRemote().getResourceConfigurationDefinitionWithTemplatesForResourceType(this.remoteClient.getSubject(), this.resource.getResourceType().getId());
        this.pluginConfigurationDefinition = this.remoteClient.getConfigurationManagerRemote().getPluginConfigurationDefinitionForResourceType(this.remoteClient.getSubject(), this.resource.getResourceType().getId());
    }

    private void initChildren() {
        ResourceCriteria criteria = new ResourceCriteria();
        criteria.addFilterParentResourceId(Integer.valueOf(this.resourceId));
        PageList childResources = this.remoteClient.getResourceManagerRemote().findResourcesByCriteria(this.remoteClient.getSubject(), criteria);
        for (Resource child : childResources) {
            this.children.add(new ResourceClientFactory(this.client).getResource(child.getId()));
        }
    }

    private void initMeasurements() {
        MeasurementDefinitionCriteria criteria = new MeasurementDefinitionCriteria();
        criteria.addFilterResourceTypeId(Integer.valueOf(this.resource.getResourceType().getId()));
        this.measurementDefinitions = this.remoteClient.getMeasurementDefinitionManagerRemote().findMeasurementDefinitionsByCriteria(this.remoteClient.getSubject(), criteria);
        this.measurementMap = new HashMap<String, Measurement>();
        for (MeasurementDefinition def : this.measurementDefinitions) {
            Measurement m = new Measurement(def);
            String name = def.getDisplayName().replaceAll("\\W", "");
            name = ResourceClientProxy.decapitalize(name);
            this.measurementMap.put(name, m);
            this.allProperties.put(name, m);
        }
    }

    public void initOperations() {
        OperationDefinitionCriteria criteria = new OperationDefinitionCriteria();
        criteria.addFilterResourceIds(new Integer[]{this.resourceId});
        criteria.fetchParametersConfigurationDefinition(true);
        criteria.fetchResultsConfigurationDefinition(true);
        this.operationDefinitions = this.remoteClient.getOperationManagerRemote().findOperationDefinitionsByCriteria(this.remoteClient.getSubject(), criteria);
        for (OperationDefinition def : this.operationDefinitions) {
            Operation o = new Operation(def);
            this.operationMap.put(o.getName(), o);
            this.allProperties.put(o.getName(), o);
        }
    }

    private void initContent() {
        ContentManagerRemote contentManager = this.remoteClient.getContentManagerRemote();
        List types = null;
        try {
            types = contentManager.findPackageTypes(this.remoteClient.getSubject(), this.resource.getResourceType().getName(), this.resource.getResourceType().getPlugin());
            for (PackageType packageType : types) {
                this.contentTypes.put(packageType.getName(), new ContentType(packageType));
            }
        }
        catch (ResourceTypeNotFoundException e) {
            e.printStackTrace();
        }
    }

    static String simpleName(String name) {
        return ResourceClientProxy.decapitalize(name.replaceAll("\\W", ""));
    }

    private static String decapitalize(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1, name.length());
    }

    static String getterName(String name) {
        return "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1, name.length());
    }

    public static void main(String[] args) throws Exception {
        RemoteClient rc = new RemoteClient("localhost", 7080);
        rc.login("rhqadmin", "rhqadmin");
        ClientMain cm = new ClientMain();
        cm.setRemoteClient(rc);
        ResourceClientFactory factory = new ResourceClientFactory(cm);
        ResourceClientProxy resource = factory.getResource(10571);
        for (Measurement m : resource.getMeasurements()) {
            System.out.println(m.toString());
        }
    }

    public static interface ContentBackedResource {
        public InstalledPackage getBackingContent();

        public void updateBackingContent(String var1);

        public void retrieveBackingContent(String var1) throws IOException;
    }

    public static interface ResourceConfigurable {
        public Configuration getResourceConfiguration();

        public ConfigurationDefinition getResourceConfigurationDefinition();

        public ResourceConfigurationUpdate updateResourceConfiguration(Configuration var1);

        public void editResourceConfiguration();
    }

    public static interface PluginConfigurable {
        public Configuration getPluginConfiguration();

        public ConfigurationDefinition getPluginConfigurationDefinition();

        public PluginConfigurationUpdate updatePluginConfiguration(Configuration var1);

        public void editPluginConfiguration();
    }

    public static class ClientProxyMethodHandler
    implements MethodHandler,
    ContentBackedResource,
    PluginConfigurable,
    ResourceConfigurable {
        ResourceClientProxy resourceClientProxy;
        RemoteClient remoteClient;

        public ClientProxyMethodHandler(ResourceClientProxy resourceClientProxy, RemoteClient remoteClient) {
            this.resourceClientProxy = resourceClientProxy;
            this.remoteClient = remoteClient;
        }

        public Configuration getPluginConfiguration() {
            if (!LazyLoadScenario.isShouldLoad()) {
                return null;
            }
            return this.remoteClient.getConfigurationManagerRemote().getPluginConfiguration(this.remoteClient.getSubject(), this.resourceClientProxy.resourceId);
        }

        public ConfigurationDefinition getPluginConfigurationDefinition() {
            return this.resourceClientProxy.pluginConfigurationDefinition;
        }

        public PluginConfigurationUpdate updatePluginConfiguration(Configuration configuration) {
            PluginConfigurationUpdate update = this.remoteClient.getConfigurationManagerRemote().updatePluginConfiguration(this.remoteClient.getSubject(), this.resourceClientProxy.getId(), configuration);
            return update;
        }

        public void editPluginConfiguration() {
            ConfigurationEditor editor = new ConfigurationEditor(this.resourceClientProxy.client);
            Configuration config = editor.editConfiguration(this.getPluginConfigurationDefinition(), this.getPluginConfiguration());
            if (config != null) {
                this.updatePluginConfiguration(config);
            }
        }

        public void editResourceConfiguration() {
            ConfigurationEditor editor = new ConfigurationEditor(this.resourceClientProxy.client);
            Configuration config = editor.editConfiguration(this.getResourceConfigurationDefinition(), this.getResourceConfiguration());
            if (config != null) {
                this.updateResourceConfiguration(config);
            }
        }

        public Configuration getResourceConfiguration() {
            if (!LazyLoadScenario.isShouldLoad()) {
                return null;
            }
            return this.remoteClient.getConfigurationManagerRemote().getResourceConfiguration(this.remoteClient.getSubject(), this.resourceClientProxy.resourceId);
        }

        public ConfigurationDefinition getResourceConfigurationDefinition() {
            return this.resourceClientProxy.resourceConfigurationDefinition;
        }

        public ResourceConfigurationUpdate updateResourceConfiguration(Configuration configuration) {
            ResourceConfigurationUpdate update = this.remoteClient.getConfigurationManagerRemote().updateResourceConfiguration(this.remoteClient.getSubject(), this.resourceClientProxy.getId(), configuration);
            return update;
        }

        public InstalledPackage getBackingContent() {
            return this.remoteClient.getContentManagerRemote().getBackingPackageForResource(this.remoteClient.getSubject(), this.resourceClientProxy.resourceId);
        }

        public void updateBackingContent(String filename) {
            File file = new File(filename);
            if (!file.exists()) {
                throw new IllegalArgumentException("File not found: " + file.getAbsolutePath());
            }
            if (file.isDirectory()) {
                throw new IllegalArgumentException("File expected, found directory: " + file.getAbsolutePath());
            }
            InstalledPackage oldPackage = this.getBackingContent();
            String oldVersion = oldPackage.getPackageVersion().getVersion();
            String newVersion = "1.0";
            if (oldVersion != null && oldVersion.length() != 0) {
                String[] parts = oldVersion.split("[^a-zA-Z0-9]");
                String lastPart = parts[parts.length - 1];
                try {
                    int lastNumber = Integer.parseInt(lastPart);
                    newVersion = oldVersion.substring(0, oldVersion.length() - lastPart.length()) + (lastNumber + 1);
                }
                catch (NumberFormatException nfe) {
                    newVersion = oldVersion + ".1";
                }
            }
            byte[] fileContents = new ScriptUtil(null).getFileBytes(filename);
            PackageVersion pv = this.remoteClient.getContentManagerRemote().createPackageVersion(this.remoteClient.getSubject(), oldPackage.getPackageVersion().getGeneralPackage().getName(), oldPackage.getPackageVersion().getGeneralPackage().getPackageType().getId(), newVersion, Integer.valueOf(oldPackage.getPackageVersion().getArchitecture().getId()), fileContents);
            this.remoteClient.getContentManagerRemote().deployPackages(this.remoteClient.getSubject(), new int[]{this.resourceClientProxy.getId()}, new int[]{pv.getId()});
        }

        public void retrieveBackingContent(String fileName) throws IOException {
            InstalledPackage installedPackage = this.getBackingContent();
            if (fileName == null) {
                fileName = installedPackage.getPackageVersion().getFileName();
            }
            File file = new File(fileName);
            byte[] data = this.remoteClient.getContentManagerRemote().getPackageBytes(this.remoteClient.getSubject(), this.resourceClientProxy.resourceId, installedPackage.getId());
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(data);
            fos.close();
        }

        public Object invoke(Object proxy, Method method, Method proceedMethod, Object[] args) throws Throwable {
            if (proceedMethod != null) {
                Method realMethod = ResourceClientProxy.class.getMethod(method.getName(), method.getParameterTypes());
                return realMethod.invoke((Object)this.resourceClientProxy, args);
            }
            try {
                Method localMethod = ClientProxyMethodHandler.class.getDeclaredMethod(method.getName(), method.getParameterTypes());
                return localMethod.invoke((Object)this, args);
            }
            catch (NoSuchMethodException nsme) {
                String name = method.getName();
                Object key = this.resourceClientProxy.allProperties.get(name);
                if (key == null) {
                    name = ResourceClientProxy.decapitalize(method.getName().substring(3, method.getName().length()));
                    key = this.resourceClientProxy.allProperties.get(name);
                }
                if (key != null) {
                    if (key instanceof Measurement) {
                        return key;
                    }
                    if (key instanceof Operation) {
                        System.out.println("Invoking operation " + ((Operation)key).getName());
                        return ((Operation)key).invoke(args);
                    }
                }
                throw new RuntimeException("Can't find custom method: " + method);
            }
        }
    }

    public class Operation {
        OperationDefinition definition;

        public Operation(OperationDefinition definition) {
            this.definition = definition;
        }

        @Summary(index=0)
        public String getName() {
            return ResourceClientProxy.simpleName(this.definition.getDisplayName());
        }

        @Summary(index=1)
        public String getDescription() {
            return this.definition.getDescription();
        }

        public OperationDefinition getDefinition() {
            return this.definition;
        }

        public Object invoke(Object[] args) throws Exception {
            if (!LazyLoadScenario.isShouldLoad()) {
                return null;
            }
            Configuration parameters = ConfigurationClassBuilder.translateParametersToConfig(this.definition.getParametersConfigurationDefinition(), args);
            ResourceOperationSchedule schedule = ResourceClientProxy.this.remoteClient.getOperationManagerRemote().scheduleResourceOperation(ResourceClientProxy.this.remoteClient.getSubject(), ResourceClientProxy.this.resourceId, this.definition.getName(), 0L, 0L, 0, 30000, parameters, "Executed from commandline");
            ResourceOperationHistoryCriteria criteria = new ResourceOperationHistoryCriteria();
            criteria.addFilterJobId(schedule.getJobId());
            criteria.addFilterResourceIds(new Integer[]{ResourceClientProxy.this.resourceId});
            criteria.addSortStartTime(PageOrdering.DESC);
            criteria.setPaging(0, 1);
            criteria.fetchOperationDefinition(true);
            criteria.fetchParameters(true);
            criteria.fetchResults(true);
            int retries = 10;
            ResourceOperationHistory history = null;
            while (history == null && retries-- > 0) {
                Thread.sleep(1000L);
                PageList histories = ResourceClientProxy.this.remoteClient.getOperationManagerRemote().findResourceOperationHistoriesByCriteria(ResourceClientProxy.this.remoteClient.getSubject(), criteria);
                if (histories.size() <= 0 || ((ResourceOperationHistory)histories.get(0)).getStatus() == OperationRequestStatus.INPROGRESS) continue;
                history = (ResourceOperationHistory)histories.get(0);
            }
            Configuration result = history != null ? history.getResults() : null;
            Object returnResults = ConfigurationClassBuilder.translateResults(this.definition.getResultsConfigurationDefinition(), result);
            return returnResults;
        }
    }

    public class Measurement
    implements ShortOutput {
        MeasurementDefinition definition;

        public Measurement(MeasurementDefinition definition) {
            this.definition = definition;
        }

        @Summary(index=0)
        public String getName() {
            return this.definition.getDisplayName();
        }

        @Summary(index=1)
        public String getDisplayValue() {
            Object val = this.getValue();
            if (val instanceof Number) {
                return MeasurementConverter.format((Double)((Number)val).doubleValue(), (MeasurementUnits)this.getUnits(), (boolean)true);
            }
            return String.valueOf(val);
        }

        @Summary(index=2)
        public String getDescription() {
            return this.definition.getDescription();
        }

        public DataType getDataType() {
            return this.definition.getDataType();
        }

        public MeasurementCategory getCategory() {
            return this.definition.getCategory();
        }

        public MeasurementUnits getUnits() {
            return this.definition.getUnits();
        }

        public Object getValue() {
            try {
                Set d = ResourceClientProxy.this.remoteClient.getMeasurementDataManagerRemote().findLiveData(ResourceClientProxy.this.remoteClient.getSubject(), ResourceClientProxy.this.resourceId, new int[]{this.definition.getId()});
                MeasurementData data = (MeasurementData)d.iterator().next();
                return data.getValue();
            }
            catch (Exception e) {
                return "?";
            }
        }

        public String toString() {
            return this.getName();
        }

        public String getShortOutput() {
            return this.getDisplayValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ContentType {
        private PackageType packageType;

        public ContentType(PackageType packageType) {
            this.packageType = packageType;
        }

        public PackageType getPackageType() {
            return this.packageType;
        }

        public List<PackageVersion> getInstalledPackages() {
            ContentManagerRemote contentManager = ResourceClientProxy.this.remoteClient.getContentManagerRemote();
            PackageVersionCriteria criteria = new PackageVersionCriteria();
            criteria.addFilterResourceId(Integer.valueOf(ResourceClientProxy.this.resourceId));
            return contentManager.findPackageVersionsByCriteria(ResourceClientProxy.this.remoteClient.getSubject(), criteria);
        }

        public String toString() {
            return this.packageType.getDisplayName();
        }
    }
}

