/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.server;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.composite.MeasurementNumericValueAndUnits;
import org.rhq.core.domain.measurement.util.MeasurementConversionException;
import org.rhq.core.server.MeasurementConverter;

public class MeasurementParser {
    private static final String NUMBER_OPTIONAL_UNIT_PATTERN_STRING = "([\\+\\-]?[0-9\\.\\,]{1,})([\\%a-z]*)";
    private static final Pattern NUMBER_OPTIONAL_UNIT_PATTERN = Pattern.compile("([\\+\\-]?[0-9\\.\\,]{1,})([\\%a-z]*)", 2);

    public static MeasurementNumericValueAndUnits parse(String input, MeasurementUnits targetUnits) throws MeasurementConversionException {
        MeasurementUnits fromUnits;
        Matcher matcher = NUMBER_OPTIONAL_UNIT_PATTERN.matcher(input = input.replaceAll("\\s", ""));
        if (!matcher.matches()) {
            throw new MeasurementConversionException("The passed input '" + input + "' could not be parsed correctly " + "by the regular expression " + NUMBER_OPTIONAL_UNIT_PATTERN_STRING);
        }
        String magnitude = matcher.group(1);
        String units = matcher.group(2);
        if (units.equals("")) {
            fromUnits = targetUnits;
        } else {
            fromUnits = MeasurementUnits.getUsingDisplayUnits((String)units, (MeasurementUnits.Family)targetUnits.getFamily());
            if (fromUnits == null || !fromUnits.isComparableTo(targetUnits)) {
                throw new MeasurementConversionException("The units in '" + input + "' were not valid, " + "expected '" + targetUnits.getFamily() + "' units, received '" + units + "' units");
            }
        }
        try {
            Double scaledMagnitude;
            if (magnitude.startsWith("+")) {
                magnitude = magnitude.substring(1);
            }
            Number convertedMagnitude = DecimalFormat.getInstance().parse(magnitude);
            if (MeasurementUnits.Family.RELATIVE == targetUnits.getFamily()) {
                scaledMagnitude = MeasurementUnits.scaleDown((Double)convertedMagnitude.doubleValue(), (MeasurementUnits)targetUnits);
            } else {
                MeasurementNumericValueAndUnits valueAndUnits = new MeasurementNumericValueAndUnits(Double.valueOf(convertedMagnitude.doubleValue()), fromUnits);
                scaledMagnitude = MeasurementConverter.scale(valueAndUnits, targetUnits);
            }
            return new MeasurementNumericValueAndUnits(scaledMagnitude, targetUnits);
        }
        catch (ParseException pe) {
            throw new MeasurementConversionException("The magnitude in '" + input + "' did not parse correctly " + "as a valid, localized, stringified number ");
        }
    }

    public static MeasurementNumericValueAndUnits parse(String input, MeasurementSchedule targetSchedule) throws MeasurementConversionException {
        MeasurementUnits targetUnits = targetSchedule.getDefinition().getUnits();
        return MeasurementParser.parse(input, targetUnits);
    }
}

