/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core.plugin;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.descriptor.AgentPluginDescriptorUtil;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.H2DatabaseType;
import org.rhq.core.db.OracleDatabaseType;
import org.rhq.core.db.PostgresqlDatabaseType;
import org.rhq.core.db.SQLServerDatabaseType;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.core.plugin.ProductPluginDeployer;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentPluginScanner {
    private Log log = LogFactory.getLog(AgentPluginScanner.class);
    private DatabaseType dbType = null;
    private Map<File, Plugin> agentPluginsOnFilesystem = new HashMap<File, Plugin>();
    private final ProductPluginDeployer agentPluginDeployer = new ProductPluginDeployer();
    private List<ProductPluginDeployer.DeploymentInfo> scanned = new ArrayList<ProductPluginDeployer.DeploymentInfo>();

    ProductPluginDeployer getAgentPluginDeployer() {
        return this.agentPluginDeployer;
    }

    void registerAgentPlugins() throws Exception {
        for (ProductPluginDeployer.DeploymentInfo di : this.scanned) {
            this.log.debug((Object)("Hot deploying agent plugin [" + di.url + "]..."));
            this.agentPluginDeployer.pluginDetected(di);
        }
        this.scanned.clear();
        this.agentPluginDeployer.registerPlugins();
    }

    void agentPluginScan() throws Exception {
        this.log.debug((Object)"Scanning for agent plugins");
        List<File> updatedFiles1 = this.agentPluginScanFilesystem();
        List<File> updatedFiles2 = this.agentPluginScanDatabase();
        ArrayList<File> allUpdatedFiles = new ArrayList<File>();
        allUpdatedFiles.addAll(updatedFiles1);
        allUpdatedFiles.addAll(updatedFiles2);
        for (File updatedFile : allUpdatedFiles) {
            ProductPluginDeployer.DeploymentInfo di = new ProductPluginDeployer.DeploymentInfo(updatedFile.toURI().toURL());
            this.log.debug((Object)("Scan detected agent plugin [" + di.url + "]..."));
            this.scanned.add(di);
        }
    }

    List<File> agentPluginScanFilesystem() {
        ArrayList<File> updated = new ArrayList<File>();
        File[] pluginJars = this.agentPluginDeployer.getPluginDir().listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        ArrayList<File> doomedPluginFiles = new ArrayList<File>();
        for (File cachedPluginFile : this.agentPluginsOnFilesystem.keySet()) {
            boolean existsOnFileSystem = false;
            for (File filesystemPluginFile : pluginJars) {
                if (!cachedPluginFile.equals(filesystemPluginFile)) continue;
                existsOnFileSystem = true;
                break;
            }
            if (existsOnFileSystem) continue;
            doomedPluginFiles.add(cachedPluginFile);
        }
        for (File deletedPluginFile : doomedPluginFiles) {
            this.agentPluginsOnFilesystem.remove(deletedPluginFile);
        }
        for (File pluginJar : pluginJars) {
            String md5 = null;
            Plugin plugin = this.agentPluginsOnFilesystem.get(pluginJar);
            try {
                if (plugin != null) {
                    if (pluginJar.lastModified() == 0L) {
                        md5 = MessageDigestGenerator.getDigestString((File)pluginJar);
                        if (!md5.equals(plugin.getMd5())) {
                            plugin = null;
                        }
                    } else if (pluginJar.lastModified() != plugin.getMtime()) {
                        plugin = null;
                    }
                }
                if (plugin != null) continue;
                this.cacheFilesystemAgentPluginJar(pluginJar, md5);
                updated.add(pluginJar);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to scan agent plugin [" + pluginJar + "] found on filesystem. Skipping. Cause: " + e));
                this.agentPluginsOnFilesystem.remove(pluginJar);
                updated.remove(pluginJar);
            }
        }
        doomedPluginFiles.clear();
        HashMap<String, Plugin> pluginsByName = new HashMap<String, Plugin>();
        for (Map.Entry<File, Plugin> currentPluginFileEntry : this.agentPluginsOnFilesystem.entrySet()) {
            Plugin currentPlugin = currentPluginFileEntry.getValue();
            Plugin existingPlugin = (Plugin)pluginsByName.get(currentPlugin.getName());
            if (existingPlugin == null) {
                pluginsByName.put(currentPlugin.getName(), currentPlugin);
                continue;
            }
            Plugin obsolete = AgentPluginDescriptorUtil.determineObsoletePlugin((Plugin)currentPlugin, (Plugin)existingPlugin);
            if (obsolete == null) {
                obsolete = currentPlugin;
            }
            doomedPluginFiles.add(new File(this.agentPluginDeployer.getPluginDir(), obsolete.getPath()));
            if (obsolete != existingPlugin) continue;
            pluginsByName.put(currentPlugin.getName(), currentPlugin);
        }
        for (File doomedPluginFile : doomedPluginFiles) {
            if (doomedPluginFile.delete()) {
                this.log.info((Object)("Deleted an obsolete agent plugin file: " + doomedPluginFile));
                this.agentPluginsOnFilesystem.remove(doomedPluginFile);
                updated.remove(doomedPluginFile);
                continue;
            }
            this.log.warn((Object)("Failed to delete what was deemed an obsolete agent plugin file: " + doomedPluginFile));
        }
        return updated;
    }

    private Plugin cacheFilesystemAgentPluginJar(File pluginJar, String md5) throws Exception {
        if (md5 == null) {
            md5 = MessageDigestGenerator.getDigestString((File)pluginJar);
        }
        URL pluginUrl = pluginJar.toURI().toURL();
        PluginDescriptor descriptor = AgentPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)pluginUrl);
        String version = AgentPluginDescriptorUtil.getPluginVersion((File)pluginJar, (PluginDescriptor)descriptor).toString();
        String name = descriptor.getName();
        Plugin plugin = new Plugin(name, pluginJar.getName());
        plugin.setMd5(md5);
        plugin.setVersion(version);
        plugin.setMtime(pluginJar.lastModified());
        this.agentPluginsOnFilesystem.put(pluginJar, plugin);
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<File> agentPluginScanDatabase() throws Exception {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<Plugin> updatedPlugins = new ArrayList<Plugin>();
        ArrayList<File> updatedFiles = new ArrayList<File>();
        try {
            DataSource ds = LookupUtil.getDataSource();
            conn = ds.getConnection();
            ps = conn.prepareStatement("SELECT NAME, PATH, MD5, MTIME, VERSION FROM RHQ_PLUGIN WHERE DEPLOYMENT = 'AGENT' AND ENABLED=?");
            this.setEnabledFlag(conn, ps, 1, true);
            rs = ps.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                String path = rs.getString(2);
                String md5 = rs.getString(3);
                long mtime = rs.getLong(4);
                String version = rs.getString(5);
                File expectedFile = new File(this.agentPluginDeployer.getPluginDir(), path);
                File currentFile = null;
                Plugin cachedPluginOnFilesystem = this.agentPluginsOnFilesystem.get(expectedFile);
                if (cachedPluginOnFilesystem != null) {
                    currentFile = expectedFile;
                    if (!cachedPluginOnFilesystem.getName().equals(name)) {
                        this.log.warn((Object)("For some reason, the plugin file [" + expectedFile + "] is plugin [" + cachedPluginOnFilesystem.getName() + "] but the database says it should be [" + name + "]"));
                    } else {
                        this.log.debug((Object)("File system and database agree on a plugin location for [" + expectedFile + "]"));
                    }
                } else {
                    for (Map.Entry<File, Plugin> cachePluginEntry : this.agentPluginsOnFilesystem.entrySet()) {
                        if (!cachePluginEntry.getValue().getName().equals(name)) continue;
                        currentFile = cachePluginEntry.getKey();
                        cachedPluginOnFilesystem = cachePluginEntry.getValue();
                        this.log.info((Object)("Filesystem has a plugin [" + name + "] at the file [" + currentFile + "] which is different than where the DB thinks it should be [" + expectedFile + "]"));
                        break;
                    }
                }
                if (cachedPluginOnFilesystem != null && currentFile != null && currentFile.exists()) {
                    Plugin dbPlugin = new Plugin(name, path);
                    dbPlugin.setMd5(md5);
                    dbPlugin.setVersion(version);
                    dbPlugin.setMtime(mtime);
                    Plugin obsoletePlugin = AgentPluginDescriptorUtil.determineObsoletePlugin((Plugin)dbPlugin, (Plugin)cachedPluginOnFilesystem);
                    if (obsoletePlugin == cachedPluginOnFilesystem) {
                        StringBuilder logMsg = new StringBuilder();
                        logMsg.append("Found agent plugin [").append(name);
                        logMsg.append("] in the DB that is newer than the one on the filesystem: ");
                        logMsg.append("DB path=[").append(path);
                        logMsg.append("]; file path=[").append(currentFile.getName());
                        logMsg.append("]; DB MD5=[").append(md5);
                        logMsg.append("]; file MD5=[").append(cachedPluginOnFilesystem.getMd5());
                        logMsg.append("]; DB version=[").append(version);
                        logMsg.append("]; file version=[").append(cachedPluginOnFilesystem.getVersion());
                        logMsg.append("]; DB timestamp=[").append(new Date(mtime));
                        logMsg.append("]; file timestamp=[").append(new Date(cachedPluginOnFilesystem.getMtime()));
                        logMsg.append("]");
                        this.log.info((Object)logMsg.toString());
                        updatedPlugins.add(dbPlugin);
                        if (currentFile.delete()) {
                            this.log.info((Object)("Deleted the obsolete agent plugin file to be updated: " + currentFile));
                            this.agentPluginsOnFilesystem.remove(currentFile);
                        } else {
                            this.log.warn((Object)("Failed to delete the obsolete (to-be-updated) agent plugin file: " + currentFile));
                        }
                        currentFile = null;
                        continue;
                    }
                    if (obsoletePlugin == null) {
                        currentFile.setLastModified(mtime);
                        cachedPluginOnFilesystem.setMtime(mtime);
                        cachedPluginOnFilesystem.setVersion(version);
                        cachedPluginOnFilesystem.setMd5(md5);
                        continue;
                    }
                    String message = "It appears the agent plugin [" + dbPlugin + "] in the database may be obsolete. If so, it will be updated soon by the version on the filesystem [" + currentFile + "].";
                    if (currentFile.getAbsolutePath().equals(expectedFile.getAbsolutePath())) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)message);
                        continue;
                    }
                    this.log.info((Object)message);
                    continue;
                }
                this.log.info((Object)("Found agent plugin in the DB that we do not yet have: " + name));
                Plugin plugin = new Plugin(name, path, md5);
                plugin.setMtime(mtime);
                plugin.setVersion(version);
                updatedPlugins.add(plugin);
                this.agentPluginsOnFilesystem.remove(expectedFile);
            }
            JDBCUtil.safeClose((Statement)ps, (ResultSet)rs);
            if (!updatedPlugins.isEmpty()) {
                ps = conn.prepareStatement("SELECT CONTENT FROM RHQ_PLUGIN WHERE DEPLOYMENT = 'AGENT' AND NAME = ? AND ENABLED = ?");
                for (Plugin plugin : updatedPlugins) {
                    File file = new File(this.agentPluginDeployer.getPluginDir(), plugin.getPath());
                    ps.setString(1, plugin.getName());
                    this.setEnabledFlag(conn, ps, 2, true);
                    rs = ps.executeQuery();
                    rs.next();
                    InputStream content = rs.getBinaryStream(1);
                    StreamUtil.copy((InputStream)content, (OutputStream)new FileOutputStream(file));
                    rs.close();
                    file.setLastModified(plugin.getMtime());
                    updatedFiles.add(file);
                }
            }
            Object var20_19 = null;
        }
        catch (Throwable throwable) {
            Object var20_20 = null;
            JDBCUtil.safeClose((Connection)conn, (Statement)ps, rs);
            throw throwable;
        }
        JDBCUtil.safeClose((Connection)conn, (Statement)ps, (ResultSet)rs);
        return updatedFiles;
    }

    private void setEnabledFlag(Connection conn, PreparedStatement ps, int index, boolean enabled) throws Exception {
        if (null == this.dbType) {
            this.dbType = DatabaseTypeFactory.getDatabaseType((Connection)conn);
        }
        if (this.dbType instanceof PostgresqlDatabaseType || this.dbType instanceof H2DatabaseType) {
            ps.setBoolean(index, enabled);
        } else if (this.dbType instanceof OracleDatabaseType || this.dbType instanceof SQLServerDatabaseType) {
            ps.setInt(index, enabled ? 1 : 0);
        } else {
            throw new RuntimeException("Unknown database type : " + this.dbType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void fixMissingAgentPluginContent() throws Exception {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<String, String> pluginsMissingContentInDb = new HashMap<String, String>();
        HashMap<String, String> pluginsMissingContentInDbMD5 = new HashMap<String, String>();
        try {
            DataSource ds = LookupUtil.getDataSource();
            conn = ds.getConnection();
            ps = conn.prepareStatement("SELECT NAME, PATH, MD5 FROM RHQ_PLUGIN WHERE CONTENT IS NULL AND ENABLED = ?");
            this.setEnabledFlag(conn, ps, 1, true);
            rs = ps.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                String path = rs.getString(2);
                String md5 = rs.getString(3);
                pluginsMissingContentInDb.put(name, path);
                pluginsMissingContentInDbMD5.put(name, md5);
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            JDBCUtil.safeClose((Connection)conn, (Statement)ps, rs);
            throw throwable;
        }
        JDBCUtil.safeClose((Connection)conn, (Statement)ps, (ResultSet)rs);
        if (!pluginsMissingContentInDb.isEmpty()) {
            ArrayList<String> pluginsToDelete = new ArrayList<String>();
            HashMap<String, File> existingPluginFiles = new HashMap<String, File>();
            for (File file : this.agentPluginDeployer.getPluginDir().listFiles()) {
                if (!file.getName().endsWith(".jar")) continue;
                try {
                    PluginDescriptor descriptor = AgentPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)file.toURI().toURL());
                    existingPluginFiles.put(descriptor.getName(), file);
                }
                catch (Exception e) {
                    this.log.warn((Object)("File [" + file + "] is not a valid plugin and will be ignored: " + e));
                }
            }
            for (Map.Entry entry : pluginsMissingContentInDb.entrySet()) {
                String name = (String)entry.getKey();
                String path = (String)entry.getValue();
                String expectedMD5 = (String)pluginsMissingContentInDbMD5.get(name);
                File pluginFile = (File)existingPluginFiles.get(name);
                if (pluginFile != null) {
                    String newMD5 = MessageDigestGenerator.getDigestString((File)pluginFile);
                    boolean different = !expectedMD5.equals(newMD5);
                    this.streamPluginFileContentToDatabase(name, pluginFile, different);
                    this.log.info((Object)("Missing content for plugin [" + name + "] will be uploaded from [" + pluginFile + "]. different=" + different));
                    continue;
                }
                pluginsToDelete.add(name);
                this.log.warn((Object)("The database knows of a plugin named [" + name + "] with path [" + path + "] but the content is missing. This server does not have this plugin in [" + this.agentPluginDeployer.getPluginDir() + "] so the database cannot be updated with the content." + " This plugin must be installed to manage existing inventory for its resource types."));
            }
            if (!pluginsToDelete.isEmpty()) {
                TransactionManager tm = LookupUtil.getTransactionManager();
                for (String pluginName : pluginsToDelete) {
                    Object var18_27;
                    try {
                        try {
                            tm.begin();
                            DataSource ds = LookupUtil.getDataSource();
                            conn = ds.getConnection();
                            ps = conn.prepareStatement("UPDATE RHQ_PLUGIN SET ENABLED = ? WHERE NAME = ?");
                            this.setEnabledFlag(conn, ps, 1, false);
                            ps.setString(2, pluginName);
                            int updateResults = ps.executeUpdate();
                            if (updateResults == 1) {
                                this.log.warn((Object)("Disabled unavailable plugin [" + pluginName + "] - This plugin must be provided to manage committed resources for its types." + " Uninventory obsolete resources to avoid getting warnings in the server and agent."));
                            } else {
                                this.log.error((Object)("Failed to disable unavailable plugin [" + pluginName + "]."));
                            }
                        }
                        catch (Exception e) {
                            tm.rollback();
                            tm = null;
                            throw e;
                        }
                        var18_27 = null;
                    }
                    catch (Throwable throwable) {
                        var18_27 = null;
                        JDBCUtil.safeClose((Connection)conn, (Statement)ps, null);
                        if (tm != null) {
                            tm.commit();
                        }
                        throw throwable;
                    }
                    JDBCUtil.safeClose((Connection)conn, (Statement)ps, null);
                    if (tm == null) continue;
                    tm.commit();
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    private void streamPluginFileContentToDatabase(String name, File file, boolean different) throws Exception {
        block11: {
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            TransactionManager tm = null;
            String sql = "UPDATE RHQ_PLUGIN SET CONTENT = ?, MD5 = ?, MTIME = ?, PATH = ? WHERE DEPLOYMENT = 'AGENT' AND NAME = ?";
            String md5 = !different ? MessageDigestGenerator.getDigestString((File)file) : "TO BE UPDATED";
            long mtime = !different ? file.lastModified() : 0L;
            InputStream fis = !different ? new FileInputStream(file) : new ByteArrayInputStream(new byte[0]);
            int contentSize = (int)(!different ? file.length() : 0L);
            tm = LookupUtil.getTransactionManager();
            tm.begin();
            DataSource ds = LookupUtil.getDataSource();
            conn = ds.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setBinaryStream(1, (InputStream)new BufferedInputStream(fis), contentSize);
            ps.setString(2, md5);
            ps.setLong(3, mtime);
            ps.setString(4, file.getName());
            ps.setString(5, name);
            int updateResults = ps.executeUpdate();
            if (updateResults != 1) {
                throw new Exception("Failed to update content for plugin [" + name + "] from [" + file + "]");
            }
            this.log.info((Object)("Stored content for plugin [" + name + "] in the db. file=" + file));
            Object var17_16 = null;
            JDBCUtil.safeClose((Connection)conn, (Statement)ps, rs);
            try {
                fis.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (tm != null) {
                tm.commit();
            }
            break block11;
            {
                catch (Exception e) {
                    tm.rollback();
                    tm = null;
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var17_17 = null;
                JDBCUtil.safeClose(conn, ps, rs);
                try {
                    fis.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (tm != null) {
                    tm.commit();
                }
                throw throwable;
            }
        }
    }
}

