/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerPluginClassLoader
extends URLClassLoader {
    private File embeddedJarsDirectory = null;

    public ServerPluginClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public void destroy() {
        this.purge(this.embeddedJarsDirectory, true);
    }

    public static ServerPluginClassLoader create(String pluginJarName, URL pluginUrl, boolean unpackNestedJars, ClassLoader parent, File tmpDirectory) throws Exception {
        return ServerPluginClassLoader.create(pluginJarName, new URL[]{pluginUrl}, unpackNestedJars, parent, tmpDirectory);
    }

    public static ServerPluginClassLoader create(String pluginJarName, URL[] pluginUrls, boolean unpackNestedJars, ClassLoader parent, File tmpDirectory) throws Exception {
        ArrayList<URL> classpathUrlList = new ArrayList<URL>();
        File unpackedDirectory = null;
        for (URL pluginUrl : pluginUrls) {
            classpathUrlList.add(pluginUrl);
            if (!unpackNestedJars) continue;
            try {
                unpackedDirectory = ServerPluginClassLoader.unpackEmbeddedJars(pluginJarName, pluginUrl, classpathUrlList, tmpDirectory);
            }
            catch (Exception e) {
                throw new Exception("Failed to unpack embedded JARs within: " + pluginUrl, e);
            }
        }
        URL[] classpath = classpathUrlList.toArray(new URL[classpathUrlList.size()]);
        ServerPluginClassLoader newLoader = new ServerPluginClassLoader(classpath, parent);
        newLoader.embeddedJarsDirectory = unpackedDirectory;
        return newLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File unpackEmbeddedJars(String pluginJarName, URL pluginUrl, List<URL> urls, File tmpDirectory) throws IOException {
        InputStream pluginStream = pluginUrl.openStream();
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(pluginStream));
        File extractionDirectory = null;
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                int i;
                String entryName = entry.getName();
                if (!entryName.startsWith("lib") || entryName.length() <= 4) continue;
                if (extractionDirectory == null) {
                    extractionDirectory = ServerPluginClassLoader.createTempDirectory(tmpDirectory, pluginJarName);
                }
                if ((i = entryName.lastIndexOf(47)) < 0) {
                    i = entryName.lastIndexOf(92);
                }
                String s = entryName.substring(i + 1);
                File file = null;
                try {
                    Object var17_18;
                    BufferedOutputStream outputStream;
                    if (s.endsWith(".jar")) {
                        file = File.createTempFile(s, null, extractionDirectory);
                        urls.add(file.toURI().toURL());
                    } else {
                        file = new File(extractionDirectory, s);
                        URL tmpUrl = extractionDirectory.toURI().toURL();
                        if (!urls.contains(tmpUrl)) {
                            urls.add(tmpUrl);
                        }
                    }
                    try {
                        outputStream = new BufferedOutputStream(new FileOutputStream(file));
                    }
                    catch (FileNotFoundException ex) {
                        if (!file.exists()) throw ex;
                        if (file.length() <= 0L) throw ex;
                        continue;
                    }
                    try {
                        file.deleteOnExit();
                        BufferedInputStream inputStream = new BufferedInputStream(zis);
                        int count = 0;
                        byte[] b = new byte[8192];
                        while ((count = inputStream.read(b)) > -1) {
                            outputStream.write(b, 0, count);
                        }
                        var17_18 = null;
                    }
                    catch (Throwable throwable) {
                        var17_18 = null;
                        outputStream.flush();
                        outputStream.close();
                        throw throwable;
                    }
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException ioe) {
                    if (file == null) throw ioe;
                    file.delete();
                    throw ioe;
                }
            }
            Object var19_20 = null;
        }
        catch (Throwable throwable) {
            Object var19_21 = null;
            try {
                zis.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {
            return extractionDirectory;
        }
        zis.close();
        return extractionDirectory;
    }

    private static File createTempDirectory(File tmpDirectory, String pluginName) throws IOException {
        File tmpDir = File.createTempFile(pluginName, ".classloader", tmpDirectory);
        boolean deleteOk = tmpDir.delete();
        boolean mkdirsOk = tmpDir.mkdirs();
        if (!deleteOk || !mkdirsOk) {
            throw new IOException("Failed to create temp classloader directory named [" + tmpDir + "]");
        }
        tmpDir.deleteOnExit();
        return tmpDir;
    }

    private void purge(File dir, boolean deleteIt) {
        if (dir != null) {
            File[] doomedFiles;
            if (dir.isDirectory() && (doomedFiles = dir.listFiles()) != null) {
                for (File doomedFile : doomedFiles) {
                    this.purge(doomedFile, true);
                }
            }
            if (deleteIt) {
                dir.delete();
            }
        }
    }
}

