/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.test;

import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.rhq.core.clientapi.server.core.AgentNotSupportedException;
import org.rhq.core.clientapi.server.core.AgentRegistrationException;
import org.rhq.core.clientapi.server.core.AgentRegistrationRequest;
import org.rhq.core.clientapi.server.core.AgentRegistrationResults;
import org.rhq.core.clientapi.server.core.CoreServerService;
import org.rhq.core.clientapi.server.discovery.DiscoveryServerService;
import org.rhq.core.clientapi.server.discovery.InvalidInventoryReportException;
import org.rhq.core.clientapi.server.discovery.InventoryReport;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.core.CoreServerServiceImpl;
import org.rhq.enterprise.server.discovery.DiscoveryServerServiceImpl;
import org.rhq.enterprise.server.test.CoreTestLocal;
import org.rhq.enterprise.server.test.DiscoveryTestLocal;

@Stateless
public class DiscoveryTestBean
implements DiscoveryTestLocal {
    private final Log log = LogFactory.getLog(DiscoveryTestBean.class);
    private static final String TEST_PLUGIN_NAME = "BogusPlugin";
    private static final String TEST_PLUGIN_PATH = "on-bogus-plugin.jar";
    private static final String TEST_PLATFORM_TYPE_NAME = "BogusOS";
    private static final String TEST_PLATFORM_NAME = "BogusPlatform";
    private static final String TEST_SERVER_TYPE_NAME = "BogusApp";
    private static final String TEST_SERVER1_NAME = "BogusServer1";
    private static final String TEST_SERVER2_NAME = "BogusServer2";
    private static final String TEST_SERVICE_TYPE_NAME = "BogusServiceType";
    private static final String TEST_SERVICE1_NAME = "BogusService1";
    private static final String TEST_SERVICE2_NAME = "BogusService2";
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    private DiscoveryServerService discoveryServerService = new DiscoveryServerServiceImpl();
    private CoreServerService coreServerService = new CoreServerServiceImpl();
    @EJB
    private CoreTestLocal coreTest;
    @EJB
    private SubjectManagerLocal subjectManager;

    public void registerTestPluginAndTypeInfo() {
        try {
            this.getTestPlugin();
        }
        catch (NoResultException e) {
            Plugin testPlugin = this.createTestPlugin();
            this.entityManager.persist((Object)testPlugin);
            this.log.info((Object)("Test plugin [" + testPlugin + "] persisted..."));
        }
        try {
            this.getTestPlatformType();
        }
        catch (NoResultException e) {
            ResourceType testResourceType = this.createTestPlatformType();
            this.entityManager.persist((Object)testResourceType);
            this.log.info((Object)("Test platform type [" + testResourceType + "] persisted..."));
        }
    }

    public void removeTestPluginAndTypeInfo() {
        try {
            Plugin testPlugin = this.getTestPlugin();
            this.entityManager.remove((Object)testPlugin);
            this.log.info((Object)("Test plugin [" + testPlugin + "] removed..."));
        }
        catch (NoResultException e) {
            // empty catch block
        }
        try {
            ResourceType testPlatformType = this.getTestPlatformType();
            this.entityManager.remove((Object)testPlatformType);
            this.log.info((Object)("Test platform type [" + testPlatformType + "] recursively removed..."));
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
    }

    public void registerFakePlugin() {
    }

    public void sendTestFullInventoryReport() {
        this.log.info((Object)"Sending fake full inventory report to server...");
        Resource platform = this.createTestPlatform("127.0.0.2", 5, 10);
        try {
            InventoryReport report = new InventoryReport(this.coreTest.getTestAgent());
            report.addAddedRoot(platform);
            this.discoveryServerService.mergeInventoryReport(report);
        }
        catch (InvalidInventoryReportException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendNewPlatform(String platformAddress, int servers, int servicesPerServer) {
        AgentRegistrationRequest registrationRequest = new AgentRegistrationRequest("TestAgent", platformAddress, 2144, "socket://" + platformAddress + ":" + 2144, true, null, null);
        try {
            AgentRegistrationResults results = this.coreServerService.registerAgent(registrationRequest);
        }
        catch (AgentRegistrationException e1) {
            throw new RuntimeException(e1);
        }
        catch (AgentNotSupportedException e2) {
            throw new RuntimeException(e2);
        }
        Resource platform = this.createTestPlatform(platformAddress, servers, servicesPerServer);
        try {
            InventoryReport report = new InventoryReport(new Agent("TestAgent", platformAddress, 2144, "endpoint", "token"));
            report.addAddedRoot(platform);
            this.discoveryServerService.mergeInventoryReport(report);
        }
        catch (InvalidInventoryReportException e) {
            throw new RuntimeException(e);
        }
    }

    public String clearAutoinventoryQueue() {
        return null;
    }

    public void sendTestRuntimeInventoryReport() {
        this.log.info((Object)"Sending fake runtime inventory report to server...");
        Resource platform = this.createTestPlatform(TEST_PLATFORM_NAME, 2, 10);
        this.addTestServicesToPlatform(platform);
        try {
            InventoryReport report = new InventoryReport(this.coreTest.getTestAgent());
            report.addAddedRoot(platform);
            this.discoveryServerService.mergeInventoryReport(report);
        }
        catch (InvalidInventoryReportException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeTestPlatform() {
        try {
            Resource platform = this.getTestPlatform();
            this.entityManager.remove((Object)platform);
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
    }

    public void createTestMixedGroup(String groupName) {
        List resources = PersistenceUtility.findByCriteria((EntityManager)this.entityManager, Resource.class, (Criterion[])new Criterion[]{Restrictions.like((String)"name", (String)"BogusServer 0", (MatchMode)MatchMode.ANYWHERE), Restrictions.eq((String)"inventoryStatus", (Object)InventoryStatus.COMMITTED)});
        System.out.println("FOUND " + resources.size() + " resources");
        ResourceGroup group = new ResourceGroup(groupName);
        for (Resource resource : resources) {
            group.addExplicitResource(resource);
        }
        this.entityManager.persist((Object)group);
        Subject s = new Subject(groupName + "User", true, false);
        this.entityManager.persist((Object)s);
        groupName = "Role";
        Role r = new Role("Role");
        r.addSubject(s);
        r.addResourceGroup(group);
        this.entityManager.persist((Object)r);
    }

    private Resource getTestPlatform() {
        return (Resource)this.entityManager.createQuery("SELECT res FROM Resource res WHERE res.name = :name").setParameter("name", (Object)TEST_PLATFORM_NAME).getSingleResult();
    }

    private Plugin getTestPlugin() {
        return (Plugin)this.entityManager.createNamedQuery("Plugin.findByName").setParameter("name", (Object)TEST_PLUGIN_NAME).getSingleResult();
    }

    private ResourceType getTestPlatformType() {
        return (ResourceType)this.entityManager.createNamedQuery("ResourceType.findByName").setParameter("name", (Object)TEST_PLATFORM_TYPE_NAME).getSingleResult();
    }

    private ResourceType getTestServerType() {
        return (ResourceType)this.entityManager.createNamedQuery("ResourceType.findByName").setParameter("name", (Object)TEST_SERVER_TYPE_NAME).getSingleResult();
    }

    private ResourceType getTestServiceType() {
        return (ResourceType)this.entityManager.createNamedQuery("ResourceType.findByName").setParameter("name", (Object)TEST_SERVICE_TYPE_NAME).getSingleResult();
    }

    private Resource createTestPlatform(String address, int servers, int servicesPerServer) {
        Resource platform = new Resource(address, address + " platform", this.getTestPlatformType());
        platform.setAgent(this.coreTest.getTestAgent());
        platform.setDescription("test platform created by " + this.getClass().getName());
        platform.setLocation("San Pedro Sula, Honduras");
        platform.setModifiedBy(this.subjectManager.getOverlord().getName());
        String serverName = "BogusServer ";
        for (int i = 0; i < servers; ++i) {
            platform.addChildResource(this.createTestServer(platform, serverName + i, servicesPerServer));
        }
        return platform;
    }

    private Resource createTestServer(Resource platform, String name, int servicesPerServer) {
        String installPath = "c:\\Program Files\\" + name;
        Resource server = new Resource(installPath, name, this.getTestServerType());
        server.setParentResource(platform);
        server.setDescription("test server created by " + this.getClass().getName());
        server.setModifiedBy(this.subjectManager.getOverlord().getName());
        for (int i = 0; i < servicesPerServer; ++i) {
            String childName = name + " child service " + i;
            server.addChildResource(this.createTestService(server, childName));
        }
        return server;
    }

    private Resource createTestService(Resource parent, String name) {
        Resource service = new Resource(name, name, this.getTestServiceType());
        service.setDescription("test service created by " + this.getClass().getName());
        service.setModifiedBy(this.subjectManager.getOverlord().getName());
        return service;
    }

    private void addTestServicesToPlatform(Resource platform) {
        Resource testServer1 = (Resource)platform.getChildResources().iterator().next();
        testServer1.addChildResource(this.createTestService(testServer1, TEST_SERVICE1_NAME));
        testServer1.addChildResource(this.createTestService(testServer1, TEST_SERVICE2_NAME));
    }

    private Plugin createTestPlugin() {
        return new Plugin(TEST_PLUGIN_NAME, TEST_PLUGIN_PATH, "abc123ddd76a2361be08b2b4c7f2b19b");
    }

    private ResourceType createTestPlatformType() {
        ResourceType platformType = new ResourceType(TEST_PLATFORM_TYPE_NAME, "", ResourceCategory.PLATFORM, ResourceType.ANY_PLATFORM_TYPE);
        platformType.setPlugin(TEST_PLUGIN_NAME);
        platformType.setDescription("test platform type");
        platformType.addChildResourceType(this.createTestServerType(platformType));
        return platformType;
    }

    private ResourceType createTestServerType(ResourceType parentType) {
        ResourceType serverType = new ResourceType(TEST_SERVER_TYPE_NAME, "", ResourceCategory.SERVER, parentType);
        serverType.setPlugin(TEST_PLUGIN_NAME);
        serverType.setDescription("test server type");
        serverType.addChildResourceType(this.createTestServiceType(serverType));
        return serverType;
    }

    private ResourceType createTestServiceType(ResourceType parentType) {
        ResourceType serviceType = new ResourceType(TEST_SERVICE_TYPE_NAME, "", ResourceCategory.SERVICE, parentType);
        serviceType.setPlugin(TEST_PLUGIN_NAME);
        serviceType.setDescription("test service type");
        return serviceType;
    }
}

