/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.client.RemoteClientProxy;
import org.rhq.enterprise.communications.util.SecurityUtil;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerRemote;
import org.rhq.enterprise.server.alert.AlertManagerRemote;
import org.rhq.enterprise.server.auth.SubjectManagerRemote;
import org.rhq.enterprise.server.authz.RoleManagerRemote;
import org.rhq.enterprise.server.bundle.BundleManagerRemote;
import org.rhq.enterprise.server.configuration.ConfigurationManagerRemote;
import org.rhq.enterprise.server.content.ContentManagerRemote;
import org.rhq.enterprise.server.content.RepoManagerRemote;
import org.rhq.enterprise.server.discovery.DiscoveryBossRemote;
import org.rhq.enterprise.server.event.EventManagerRemote;
import org.rhq.enterprise.server.install.remote.RemoteInstallManagerRemote;
import org.rhq.enterprise.server.measurement.AvailabilityManagerRemote;
import org.rhq.enterprise.server.measurement.CallTimeDataManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementBaselineManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerRemote;
import org.rhq.enterprise.server.operation.OperationManagerRemote;
import org.rhq.enterprise.server.report.DataAccessManagerRemote;
import org.rhq.enterprise.server.resource.ResourceFactoryManagerRemote;
import org.rhq.enterprise.server.resource.ResourceManagerRemote;
import org.rhq.enterprise.server.resource.ResourceTypeManagerRemote;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerRemote;
import org.rhq.enterprise.server.search.SavedSearchManagerRemote;
import org.rhq.enterprise.server.support.SupportManagerRemote;
import org.rhq.enterprise.server.system.ServerVersion;
import org.rhq.enterprise.server.system.SystemManagerRemote;
import org.rhq.enterprise.server.tagging.TagManagerRemote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteClient {
    public static final String NONSECURE_TRANSPORT = "servlet";
    public static final String SECURE_TRANSPORT = "sslservlet";
    private String transport;
    private final String host;
    private final int port;
    private boolean loggedIn;
    private boolean connected;
    private Map<String, Object> managers;
    private Subject subject;
    private Client remotingClient;
    private String subsystem = null;

    public RemoteClient(String host, int port) {
        this(null, host, port);
    }

    public RemoteClient(String transport, String host, int port) {
        this(transport, host, port, null);
    }

    public RemoteClient(String transport, String host, int port, String subsystem) {
        this.transport = transport != null ? transport : this.guessTransport(port);
        this.host = host;
        this.port = port;
        this.subsystem = subsystem;
    }

    public Subject login(String user, String password) throws Exception {
        this.logout();
        this.doConnect();
        this.subject = this.getSubjectManagerRemote().login(user, password);
        this.loggedIn = true;
        ServerVersion version = this.getSystemManagerRemote().getServerVersion(this.subject);
        System.out.println("Remote server version is: " + version);
        return this.subject;
    }

    public void logout() {
        try {
            if (this.loggedIn && this.subject != null) {
                this.getSubjectManagerRemote().logout(this.subject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.doDisconnect();
        this.subject = null;
        this.loggedIn = false;
    }

    public void connect() throws Exception {
        if (this.loggedIn) {
            String name = null == this.subject ? "" : this.subject.getName();
            throw new IllegalStateException("User " + name + " must log out before connection can be established.");
        }
        this.doDisconnect();
        this.doConnect();
        this.connected = true;
    }

    public void disconnect() {
        if (this.loggedIn) {
            String name = null == this.subject ? "" : this.subject.getName();
            throw new IllegalStateException("User " + name + " is logged in. Call logout() instead of disconnect().");
        }
        this.doDisconnect();
        this.connected = false;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getTransport() {
        return this.transport;
    }

    protected String guessTransport(int port) {
        return String.valueOf(port).endsWith("443") ? SECURE_TRANSPORT : NONSECURE_TRANSPORT;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public AlertManagerRemote getAlertManagerRemote() {
        return (AlertManagerRemote)RemoteClientProxy.getProcessor(this, Manager.AlertManager);
    }

    public AlertDefinitionManagerRemote getAlertDefinitionManagerRemote() {
        return (AlertDefinitionManagerRemote)RemoteClientProxy.getProcessor(this, Manager.AlertDefinitionManager);
    }

    public AvailabilityManagerRemote getAvailabilityManagerRemote() {
        return (AvailabilityManagerRemote)RemoteClientProxy.getProcessor(this, Manager.AvailabilityManager);
    }

    public BundleManagerRemote getBundleManagerRemote() {
        return (BundleManagerRemote)RemoteClientProxy.getProcessor(this, Manager.BundleManager);
    }

    public CallTimeDataManagerRemote getCallTimeDataManagerRemote() {
        return (CallTimeDataManagerRemote)RemoteClientProxy.getProcessor(this, Manager.CallTimeDataManager);
    }

    public RepoManagerRemote getRepoManagerRemote() {
        return (RepoManagerRemote)RemoteClientProxy.getProcessor(this, Manager.RepoManager);
    }

    public ConfigurationManagerRemote getConfigurationManagerRemote() {
        return (ConfigurationManagerRemote)RemoteClientProxy.getProcessor(this, Manager.ConfigurationManager);
    }

    public ContentManagerRemote getContentManagerRemote() {
        return (ContentManagerRemote)RemoteClientProxy.getProcessor(this, Manager.ContentManager);
    }

    public DataAccessManagerRemote getDataAccessManagerRemote() {
        return (DataAccessManagerRemote)RemoteClientProxy.getProcessor(this, Manager.DataAccessManager);
    }

    public DiscoveryBossRemote getDiscoveryBossRemote() {
        return (DiscoveryBossRemote)RemoteClientProxy.getProcessor(this, Manager.DiscoveryBoss);
    }

    public EventManagerRemote getEventManagerRemote() {
        return (EventManagerRemote)RemoteClientProxy.getProcessor(this, Manager.EventManager);
    }

    public MeasurementBaselineManagerRemote getMeasurementBaselineManagerRemote() {
        return (MeasurementBaselineManagerRemote)RemoteClientProxy.getProcessor(this, Manager.MeasurementBaselineManager);
    }

    public MeasurementDataManagerRemote getMeasurementDataManagerRemote() {
        return (MeasurementDataManagerRemote)RemoteClientProxy.getProcessor(this, Manager.MeasurementDataManager);
    }

    public MeasurementDefinitionManagerRemote getMeasurementDefinitionManagerRemote() {
        return (MeasurementDefinitionManagerRemote)RemoteClientProxy.getProcessor(this, Manager.MeasurementDefinitionManager);
    }

    public MeasurementScheduleManagerRemote getMeasurementScheduleManagerRemote() {
        return (MeasurementScheduleManagerRemote)RemoteClientProxy.getProcessor(this, Manager.MeasurementScheduleManager);
    }

    public OperationManagerRemote getOperationManagerRemote() {
        return (OperationManagerRemote)RemoteClientProxy.getProcessor(this, Manager.OperationManager);
    }

    public ResourceManagerRemote getResourceManagerRemote() {
        return (ResourceManagerRemote)RemoteClientProxy.getProcessor(this, Manager.ResourceManager);
    }

    public ResourceFactoryManagerRemote getResourceFactoryManagerRemote() {
        return (ResourceFactoryManagerRemote)RemoteClientProxy.getProcessor(this, Manager.ResourceFactoryManager);
    }

    public ResourceGroupManagerRemote getResourceGroupManagerRemote() {
        return (ResourceGroupManagerRemote)RemoteClientProxy.getProcessor(this, Manager.ResourceGroupManager);
    }

    public ResourceTypeManagerRemote getResourceTypeManagerRemote() {
        return (ResourceTypeManagerRemote)RemoteClientProxy.getProcessor(this, Manager.ResourceTypeManager);
    }

    public RoleManagerRemote getRoleManagerRemote() {
        return (RoleManagerRemote)RemoteClientProxy.getProcessor(this, Manager.RoleManager);
    }

    public SavedSearchManagerRemote getSavedSearchManagerRemote() {
        return (SavedSearchManagerRemote)RemoteClientProxy.getProcessor(this, Manager.SavedSearchManager);
    }

    public SubjectManagerRemote getSubjectManagerRemote() {
        return (SubjectManagerRemote)RemoteClientProxy.getProcessor(this, Manager.SubjectManager);
    }

    public SupportManagerRemote getSupportManagerRemote() {
        return (SupportManagerRemote)RemoteClientProxy.getProcessor(this, Manager.SupportManager);
    }

    public SystemManagerRemote getSystemManagerRemote() {
        return (SystemManagerRemote)RemoteClientProxy.getProcessor(this, Manager.SystemManager);
    }

    public RemoteInstallManagerRemote getRemoteInstallManagerRemote() {
        return (RemoteInstallManagerRemote)RemoteClientProxy.getProcessor(this, Manager.RemoteInstallManager);
    }

    public TagManagerRemote getTagManagerRemote() {
        return (TagManagerRemote)RemoteClientProxy.getProcessor(this, Manager.TagManager);
    }

    public Map<String, Object> getManagers() {
        if (this.managers == null) {
            this.managers = new HashMap<String, Object>();
            for (Manager manager : Manager.values()) {
                try {
                    Method m = this.getClass().getMethod("get" + manager.remoteName(), new Class[0]);
                    this.managers.put(manager.name(), m.invoke((Object)this, new Object[0]));
                }
                catch (Throwable e) {
                    System.out.println("Failed to load manager " + (Object)((Object)manager) + " due to missing class: " + e);
                }
            }
        }
        return this.managers;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "transport=" + this.transport + ", host=" + this.host + ", port=" + this.port + ", subsystem=" + this.subsystem + ", connected=" + this.connected + ", loggedIn=" + this.loggedIn + ", subject=" + this.subject + ']';
    }

    Client getRemotingClient() {
        return this.remotingClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDisconnect() {
        try {
            if (this.remotingClient != null && this.remotingClient.isConnected()) {
                this.remotingClient.disconnect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.remotingClient = null;
        }
    }

    private void doConnect() throws Exception {
        String locatorURI = this.transport + "://" + this.host + ":" + this.port + "/jboss-remoting-servlet-invoker/ServerInvokerServlet";
        InvokerLocator locator = new InvokerLocator(locatorURI);
        String subsystem = "REMOTEAPI";
        if (this.subsystem != null && this.subsystem.trim().equalsIgnoreCase("WSREMOTEAPI")) {
            subsystem = "WSREMOTEAPI";
        }
        Map<String, String> remotingConfig = this.buildRemotingConfig(locatorURI);
        this.remotingClient = new Client(locator, subsystem, remotingConfig);
        this.remotingClient.connect();
    }

    private Map<String, String> buildRemotingConfig(String locatorURI) {
        HashMap<String, String> config = new HashMap<String, String>();
        if (SecurityUtil.isTransportSecure((String)locatorURI)) {
            this.setConfigProp(config, "org.jboss.remoting.keyStore", "data/keystore.dat");
            this.setConfigProp(config, "org.jboss.remoting.keyStoreAlgorithm", "SunX509");
            this.setConfigProp(config, "org.jboss.remoting.keyStoreType", "JKS");
            this.setConfigProp(config, "org.jboss.remoting.keyStorePassword", "password");
            this.setConfigProp(config, "org.jboss.remoting.keyPassword", "password");
            this.setConfigProp(config, "org.jboss.remoting.trustStore", null);
            this.setConfigProp(config, "org.jboss.remoting.trustStoreAlgorithm", null);
            this.setConfigProp(config, "org.jboss.remoting.trustStoreType", null);
            this.setConfigProp(config, "org.jboss.remoting.trustStorePassword", null);
            this.setConfigProp(config, "org.jboss.remoting.sslProtocol", null);
            this.setConfigProp(config, "org.jboss.remoting.keyAlias", "self");
            this.setConfigProp(config, "org.jboss.remoting.serverAuthMode", "false");
            config.put("org.jboss.remoting.socket.useClientMode", "true");
            SSLSocketBuilder dummy_sslbuilder = new SSLSocketBuilder();
            try {
                dummy_sslbuilder.setKeyStoreURL((String)config.get("org.jboss.remoting.keyStore"));
            }
            catch (Exception e) {
                SecurityUtil.createKeyStore((String)((String)config.get("org.jboss.remoting.keyStore")), (String)((String)config.get("org.jboss.remoting.keyAlias")), (String)"CN=RHQ, OU=RedHat, O=redhat.com, C=US", (String)((String)config.get("org.jboss.remoting.keyStorePassword")), (String)((String)config.get("org.jboss.remoting.keyPassword")), (String)"DSA", (int)36500);
                dummy_sslbuilder.setKeyStoreURL((String)config.get("org.jboss.remoting.keyStore"));
            }
            config.put("org.jboss.security.ignoreHttpsHost", "true");
        }
        return config;
    }

    private void setConfigProp(Map<String, String> configMap, String propName, String defaultValue) {
        String propValue = System.getProperty(propName, defaultValue);
        if (propValue != null) {
            configMap.put(propName, propValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Manager {
        AlertManager(AlertManagerRemote.class),
        AlertDefinitionManager(AlertDefinitionManagerRemote.class),
        AvailabilityManager(AvailabilityManagerRemote.class),
        BundleManager(BundleManagerRemote.class),
        CallTimeDataManager(CallTimeDataManagerRemote.class),
        RepoManager(RepoManagerRemote.class),
        ConfigurationManager(ConfigurationManagerRemote.class),
        ContentManager(ContentManagerRemote.class),
        DataAccessManager(DataAccessManagerRemote.class),
        DiscoveryBoss(DiscoveryBossRemote.class),
        EventManager(EventManagerRemote.class),
        MeasurementBaselineManager(MeasurementBaselineManagerRemote.class),
        MeasurementDataManager(MeasurementDataManagerRemote.class),
        MeasurementDefinitionManager(MeasurementDefinitionManagerRemote.class),
        MeasurementScheduleManager(MeasurementScheduleManagerRemote.class),
        OperationManager(OperationManagerRemote.class),
        ResourceManager(ResourceManagerRemote.class),
        ResourceFactoryManager(ResourceFactoryManagerRemote.class),
        ResourceGroupManager(ResourceGroupManagerRemote.class),
        ResourceTypeManager(ResourceTypeManagerRemote.class),
        RoleManager(RoleManagerRemote.class),
        SavedSearchManager(SavedSearchManagerRemote.class),
        SubjectManager(SubjectManagerRemote.class),
        SupportManager(SupportManagerRemote.class),
        SystemManager(SystemManagerRemote.class),
        RemoteInstallManager(RemoteInstallManagerRemote.class),
        TagManager(TagManagerRemote.class);

        private Class<?> remote;
        private String remoteName;
        private String beanName;

        private Manager(Class<?> remote) {
            this.remote = remote;
            this.beanName = this.name() + "Bean";
            this.remoteName = this.name() + "Remote";
        }

        Class<?> remote() {
            return this.remote;
        }

        public String beanName() {
            return this.beanName;
        }

        public String remoteName() {
            return this.remoteName;
        }
    }
}

