/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.discovery;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.upgrade.ResourceUpgradeRequest;
import org.rhq.core.clientapi.agent.upgrade.ResourceUpgradeResponse;
import org.rhq.core.clientapi.server.discovery.DiscoveryServerService;
import org.rhq.core.clientapi.server.discovery.InvalidInventoryReportException;
import org.rhq.core.clientapi.server.discovery.InventoryReport;
import org.rhq.core.clientapi.server.discovery.StaleTypeException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.discovery.MergeResourceResponse;
import org.rhq.core.domain.discovery.ResourceSyncInfo;
import org.rhq.core.domain.measurement.ResourceMeasurementScheduleRequest;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceError;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.alert.AlertDefinitionCreationException;
import org.rhq.enterprise.server.alert.AlertTemplateManagerLocal;
import org.rhq.enterprise.server.cloud.StatusManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.discovery.DiscoveryBossLocal;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.concurrent.AvailabilityReportSerializer;

public class DiscoveryServerServiceImpl
implements DiscoveryServerService {
    private Log log = LogFactory.getLog(DiscoveryServerServiceImpl.class);

    public ResourceSyncInfo mergeInventoryReport(InventoryReport report) throws InvalidInventoryReportException, StaleTypeException {
        ResourceSyncInfo syncInfo;
        long start = System.currentTimeMillis();
        DiscoveryBossLocal discoveryBoss = LookupUtil.getDiscoveryBoss();
        try {
            syncInfo = discoveryBoss.mergeInventoryReport(report);
        }
        catch (InvalidInventoryReportException e) {
            Agent agent = report.getAgent();
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)("Received invalid inventory report from agent [" + agent + "]"), (Throwable)e);
            } else {
                this.log.error((Object)("Received invalid inventory report from agent [" + agent + "]: " + e.getMessage()));
            }
            throw e;
        }
        catch (RuntimeException e) {
            this.log.error((Object)("Fatal error occurred during merging of inventory report from agent [" + report.getAgent() + "]."), (Throwable)e);
            throw e;
        }
        long elapsed = System.currentTimeMillis() - start;
        if (elapsed > 30000L) {
            this.log.info((Object)("Performance: inventory merge (" + elapsed + ")ms"));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Performance: inventory merge (" + elapsed + ")ms"));
        }
        return syncInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mergeAvailabilityReport(AvailabilityReport availabilityReport) {
        AvailabilityReportSerializer.getSingleton().lock(availabilityReport.getAgentName());
        try {
            String reportToString = availabilityReport.toString(false);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Processing " + reportToString));
            }
            long start = System.currentTimeMillis();
            AvailabilityManagerLocal availabilityManager = LookupUtil.getAvailabilityManager();
            boolean ok = availabilityManager.mergeAvailabilityReport(availabilityReport);
            long elapsed = System.currentTimeMillis() - start;
            if (!ok || !availabilityReport.isChangesOnlyReport() || elapsed > 20000L) {
                this.log.info((Object)("Processed " + reportToString + " - need full=[" + !ok + "] in (" + elapsed + ")ms"));
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Processed " + reportToString + " - need full=[" + !ok + "] in (" + elapsed + ")ms"));
            }
            boolean bl = ok;
            return bl;
        }
        catch (Exception e) {
            this.log.info((Object)("Error processing availability report from [" + availabilityReport.getAgentName() + "]: " + ThrowableUtil.getAllMessages((Throwable)e)));
            boolean bl = true;
            return bl;
        }
        finally {
            AvailabilityReportSerializer.getSingleton().unlock(availabilityReport.getAgentName());
        }
    }

    public Set<Resource> getResources(Set<Integer> resourceIds, boolean includeDescendants) {
        long start = System.currentTimeMillis();
        ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
        HashSet<Resource> resources = new HashSet<Resource>();
        for (Integer resourceId : resourceIds) {
            Resource resource = resourceManager.getResourceTree(resourceId, includeDescendants);
            resource = DiscoveryServerServiceImpl.convertToPojoResource(resource, includeDescendants);
            resources.add(resource);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Performance: get Resources [" + resourceIds + "], recursive=" + includeDescendants + ", timing (" + (System.currentTimeMillis() - start) + ")ms"));
        }
        return resources;
    }

    public Map<Integer, InventoryStatus> getInventoryStatus(int rootResourceId, boolean descendents) {
        long start = System.currentTimeMillis();
        ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
        Map<Integer, InventoryStatus> statuses = resourceManager.getResourceStatuses(rootResourceId, descendents);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Performance: get inventory statuses for [" + statuses.size() + "] timing (" + (System.currentTimeMillis() - start) + ")ms"));
        }
        return statuses;
    }

    public void setResourceError(ResourceError resourceError) {
        ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
        resourceManager.addResourceError(resourceError);
    }

    public void clearResourceConfigError(int resourceId) {
        ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
        resourceManager.clearResourceConfigError(resourceId);
    }

    public MergeResourceResponse addResource(Resource resource, int creatorSubjectId) {
        DiscoveryBossLocal discoveryBoss = LookupUtil.getDiscoveryBoss();
        return discoveryBoss.addResource(resource, creatorSubjectId);
    }

    public boolean updateResourceVersion(int resourceId, String version) {
        DiscoveryBossLocal discoveryBoss = LookupUtil.getDiscoveryBoss();
        return discoveryBoss.updateResourceVersion(resourceId, version);
    }

    public Set<ResourceUpgradeResponse> upgradeResources(Set<ResourceUpgradeRequest> upgradeRequests) {
        DiscoveryBossLocal discoveryBoss = LookupUtil.getDiscoveryBoss();
        return discoveryBoss.upgradeResources(upgradeRequests);
    }

    private static Resource convertToPojoResource(Resource resource, boolean includeDescendants) {
        Resource pojoResource = new Resource(resource.getId());
        pojoResource.setUuid(resource.getUuid());
        pojoResource.setResourceKey(resource.getResourceKey());
        pojoResource.setResourceType(resource.getResourceType());
        pojoResource.setMtime(resource.getMtime());
        pojoResource.setInventoryStatus(resource.getInventoryStatus());
        Configuration pcCopy = resource.getPluginConfiguration();
        if (pcCopy != null) {
            pcCopy = pcCopy.deepCopy();
        }
        pojoResource.setPluginConfiguration(pcCopy);
        pojoResource.setName(resource.getName());
        pojoResource.setDescription(resource.getDescription());
        pojoResource.setLocation(resource.getLocation());
        if (resource.getParentResource() != null) {
            pojoResource.setParentResource(DiscoveryServerServiceImpl.convertToPojoResource(resource.getParentResource(), false));
        }
        if (includeDescendants) {
            for (Resource childResource : resource.getChildResources()) {
                pojoResource.addChildResource(DiscoveryServerServiceImpl.convertToPojoResource(childResource, true));
            }
        }
        return pojoResource;
    }

    public Set<ResourceMeasurementScheduleRequest> postProcessNewlyCommittedResources(Set<Integer> resourceIds) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Post-processing " + resourceIds.size() + "newly committed resources"));
            this.log.debug((Object)("Ids were: " + resourceIds));
        }
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        AlertTemplateManagerLocal alertTemplateManager = LookupUtil.getAlertTemplateManager();
        MeasurementScheduleManagerLocal scheduleManager = LookupUtil.getMeasurementScheduleManager();
        AgentManagerLocal agentManager = LookupUtil.getAgentManager();
        StatusManagerLocal statusManager = LookupUtil.getStatusManager();
        long start = System.currentTimeMillis();
        Set<ResourceMeasurementScheduleRequest> results = scheduleManager.findSchedulesForResourceAndItsDescendants(ArrayUtils.unwrapCollection(resourceIds), false);
        long time = System.currentTimeMillis() - start;
        if (time >= 10000L) {
            this.log.info((Object)("Performance: commit resource, create schedules timing: resourceCount/millis=" + resourceIds.size() + '/' + time));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Performance: commit resource, create schedules timing: resourceCount/millis=" + resourceIds.size() + '/' + time));
        }
        start = System.currentTimeMillis();
        for (Integer resourceId : resourceIds) {
            try {
                alertTemplateManager.updateAlertDefinitionsForResource(overlord, resourceId);
            }
            catch (AlertDefinitionCreationException adce) {
                this.log.error((Object)adce);
            }
            catch (Throwable t) {
                this.log.debug((Object)("Could not apply alert templates for resourceId = " + resourceId), t);
            }
        }
        try {
            if (resourceIds.size() > 0) {
                int anyResourceIdFromNewlyCommittedSet = resourceIds.iterator().next();
                int agentId = agentManager.getAgentIdByResourceId(anyResourceIdFromNewlyCommittedSet);
                statusManager.updateByAgent(agentId);
            }
        }
        catch (Throwable t) {
            this.log.debug((Object)"Could not reload caches for newly committed resources", t);
        }
        time = System.currentTimeMillis() - start;
        if (time >= 10000L) {
            this.log.info((Object)("Performance: commit resource, apply alert templates timing: resourceCount/millis=" + resourceIds.size() + '/' + time));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Performance: commit resource, apply alert templates timing: resourceCount/millis=" + resourceIds.size() + '/' + time));
        }
        return results;
    }
}

