/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler.jobs;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.inventory.InventoryManagerLocal;
import org.rhq.enterprise.server.scheduler.jobs.AbstractStatefulJob;
import org.rhq.enterprise.server.util.LookupUtil;

public class PurgeResourceTypesJob
extends AbstractStatefulJob {
    private static final Log log = LogFactory.getLog(PurgeResourceTypesJob.class);

    @Override
    public void executeJobCode(JobExecutionContext context) throws JobExecutionException {
        InventoryManagerLocal inventoryMgr = LookupUtil.getInventoryManager();
        DeletionStats stats = new DeletionStats();
        long startTotalTime = System.currentTimeMillis();
        List<ResourceType> deletedTypes = inventoryMgr.getDeletedTypes();
        for (ResourceType deletedType : deletedTypes) {
            if (inventoryMgr.isReadyForPermanentRemoval(deletedType)) {
                log.debug((Object)("Permanently removing " + deletedType));
                long startTime = System.currentTimeMillis();
                inventoryMgr.purgeDeletedResourceType(deletedType);
                long endTime = System.currentTimeMillis();
                ++stats.numDeleted;
                log.debug((Object)("Deleted " + deletedType + " in " + (endTime - startTime) + " ms"));
                continue;
            }
            log.debug((Object)(deletedType + " has been deleted but is not yet ready for permanent removal."));
        }
        long stopTotalTime = System.currentTimeMillis();
        stats.deletionTime = stopTotalTime - startTotalTime;
        log.debug((Object)stats);
    }

    private static class DeletionStats {
        int numDeleted;
        long deletionTime;

        private DeletionStats() {
        }

        public String toString() {
            return PurgeResourceTypesJob.class.getSimpleName() + ": deleted " + this.numDeleted + " in " + this.deletionTime + " ms";
        }
    }
}

