/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.search.assist;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.search.SearchSubsystem;
import org.rhq.enterprise.server.search.assist.TabAwareSearchAssistant;

public class GroupSearchAssistant
extends TabAwareSearchAssistant {
    private static final List<String> parameterizedContexts = Collections.emptyList();
    private static final List<String> simpleContexts = Collections.unmodifiableList(Arrays.asList("availability", "category", "type", "plugin", "name"));

    public GroupSearchAssistant(Subject subject, String tab) {
        super(subject, tab);
    }

    @Override
    public SearchSubsystem getSearchSubsystem() {
        return SearchSubsystem.GROUP;
    }

    @Override
    public String getPrimarySimpleContext() {
        return "name";
    }

    @Override
    public List<String> getSimpleContexts() {
        return simpleContexts;
    }

    @Override
    public List<String> getParameterizedContexts() {
        return parameterizedContexts;
    }

    @Override
    public List<String> getParameters(String context, String filter) {
        return Collections.emptyList();
    }

    @Override
    public List<String> getValues(String context, String param, String filter) {
        filter = this.stripQuotes(filter);
        if (context.equals("availability")) {
            return this.filter(AvailabilityType.class, filter);
        }
        if (context.equals("category")) {
            return this.filter(ResourceCategory.class, filter);
        }
        if (context.equals("type")) {
            return this.execute("SELECT DISTINCT type.name   FROM ResourceType type, ResourceGroup rg  WHERE rg.resourceType = type    AND rg.visible = true AND type.deleted = false" + this.conditionallyAddJPQLString("type.name", filter) + this.conditionallyAddJPQLString("rg.groupCategory", this.tab) + this.conditionallyAddAuthzFragment(this.getAuthzFragment()) + " ORDER BY type.name ");
        }
        if (context.equals("plugin")) {
            return this.execute("SELECT DISTINCT type.plugin   FROM ResourceType type, ResourceGroup rg  WHERE rg.resourceType = type    AND rg.visible = true AND type.deleted = false" + this.conditionallyAddJPQLString("type.plugin", filter) + this.conditionallyAddJPQLString("rg.groupCategory", this.tab) + this.conditionallyAddAuthzFragment(this.getAuthzFragment()) + " ORDER BY type.plugin ");
        }
        if (context.equals("name")) {
            return this.execute("SELECT DISTINCT rg.name   FROM ResourceGroup rg  WHERE rg.visible = true " + this.conditionallyAddJPQLString("rg.name", filter) + this.conditionallyAddJPQLString("rg.groupCategory", this.tab) + this.conditionallyAddAuthzFragment(this.getAuthzFragment()) + " ORDER BY rg.name ");
        }
        return Collections.emptyList();
    }

    private String getAuthzFragment() {
        return "rg.id IN (SELECT igroup.id    FROM ResourceGroup igroup    JOIN igroup.roles irole    JOIN irole.subjects isubject   WHERE isubject.id = " + this.getSubjectId() + ")";
    }
}

