/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.annotations.IndexColumn;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.AlertCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.criteria.ResourceGroupCriteria;
import org.rhq.core.domain.criteria.ResourceOperationHistoryCriteria;
import org.rhq.core.domain.criteria.SubjectCriteria;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.search.SearchSubsystem;
import org.rhq.core.domain.tagging.Tag;
import org.rhq.core.domain.util.OrderingField;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.search.SearchExpressionException;
import org.rhq.enterprise.server.search.execution.SearchTranslationManager;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.QueryUtility;

public final class CriteriaQueryGenerator {
    private static final Log LOG = LogFactory.getLog(CriteriaQueryGenerator.class);
    private Criteria criteria;
    private String searchExpressionWhereClause;
    private Subject subject;
    private String authorizationPermsFragment;
    private String authorizationCustomConditionFragment;
    private int authorizationSubjectId;
    private String alias;
    private String className;
    private String projection;
    private String groupByClause;
    private String havingClause;
    private static String NL = System.getProperty("line.separator");
    private static List<String> EXPRESSION_START_KEYWORDS = new ArrayList<String>(2);
    private List<Field> persistentBagFields = new ArrayList<Field>();
    private List<Field> joinFetchFields = new ArrayList<Field>();

    public CriteriaQueryGenerator(Criteria criteria) {
        this(LookupUtil.getSubjectManager().getOverlord(), criteria);
    }

    public CriteriaQueryGenerator(Subject subject, Criteria criteria) {
        this.subject = subject;
        this.criteria = criteria;
        this.className = criteria.getPersistentClass().getSimpleName();
        this.alias = this.criteria.getAlias();
        this.initializeJPQLFragmentFromSearchExpression();
    }

    public void setAuthorizationCustomConditionFragment(String fragment) {
        this.authorizationCustomConditionFragment = fragment;
    }

    public void setAuthorizationResourceFragment(AuthorizationTokenType type, int subjectId) {
        String defaultFragment = null;
        if (type == AuthorizationTokenType.RESOURCE) {
            defaultFragment = "resource";
        } else if (type == AuthorizationTokenType.GROUP) {
            defaultFragment = "group";
        }
        this.setAuthorizationResourceFragment(type, defaultFragment, subjectId);
    }

    private String fixFilterOverride(String expression, String fieldName) {
        boolean wantCaseInsensitiveMatch;
        boolean fuzzyMatch = expression.toLowerCase().contains(" like ") && !expression.toLowerCase().contains("select");
        boolean bl = wantCaseInsensitiveMatch = !this.criteria.isCaseSensitive() && fuzzyMatch;
        while (expression.indexOf(63) != -1) {
            String replacement = ":" + fieldName;
            expression = expression.replaceFirst("\\?", replacement);
        }
        if (!this.expressionStartsWithKeyword(expression)) {
            if (wantCaseInsensitiveMatch) {
                int indexOfFirstSpace = expression.indexOf(" ");
                String filterToken = expression.substring(0, indexOfFirstSpace);
                expression = "LOWER( " + this.alias + "." + filterToken + " ) " + expression.substring(indexOfFirstSpace);
            } else {
                expression = this.alias + "." + expression;
            }
        }
        if (fuzzyMatch) {
            expression = expression + QueryUtility.getEscapeClause();
        }
        return expression;
    }

    private boolean expressionStartsWithKeyword(String expression) {
        expression = expression.trim();
        int i = expression.trim().indexOf(" ");
        String startToken = expression.substring(0, i);
        return EXPRESSION_START_KEYWORDS.contains(startToken.toUpperCase());
    }

    public void setAuthorizationResourceFragment(AuthorizationTokenType type, String fragment, int subjectId) {
        this.authorizationSubjectId = subjectId;
        if (type == AuthorizationTokenType.RESOURCE) {
            this.setAuthorizationCustomConditionFragment(this.getEnhancedResourceAuthorizationWhereFragment(fragment, subjectId));
        } else if (type == AuthorizationTokenType.GROUP) {
            this.setAuthorizationCustomConditionFragment(this.getEnhancedGroupAuthorizationWhereFragment(fragment, subjectId));
        } else {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " does not yet support generating queries for '" + (Object)((Object)type) + "' token types");
        }
        List requiredPerms = this.criteria.getRequiredPermissions();
        if (null != requiredPerms && !requiredPerms.isEmpty()) {
            this.authorizationPermsFragment = "AND ( SELECT COUNT(DISTINCT p)" + NL + "      FROM Subject innerSubject" + NL + "      JOIN innerSubject.roles r" + NL + "      JOIN r.permissions p" + NL + "      WHERE innerSubject.id = " + this.authorizationSubjectId + NL + "      AND p IN ( :requiredPerms ) ) = :requiredPermsSize" + NL;
        }
    }

    private String getEnhancedResourceAuthorizationWhereFragment(String fragment, int subjectId) {
        String customAuthzFragment = "( %aliasWithFragment%.id IN ( SELECT %aliasWithFragment%.id " + NL + "                    FROM %alias% innerAlias " + NL + "                    JOIN %innerAlias%.implicitGroups g JOIN g.roles r JOIN r.subjects s " + NL + "                   WHERE s.id = %subjectId% ) )" + NL;
        String aliasReplacement = this.criteria.getAlias() + (fragment != null ? "." + fragment : "");
        String innerAliasReplacement = "innerAlias" + (fragment != null ? "." + fragment : "");
        customAuthzFragment = customAuthzFragment.replace("%alias%", this.criteria.getAlias());
        customAuthzFragment = customAuthzFragment.replace("%aliasWithFragment%", aliasReplacement);
        customAuthzFragment = customAuthzFragment.replace("%innerAlias%", innerAliasReplacement);
        customAuthzFragment = customAuthzFragment.replace("%subjectId%", String.valueOf(subjectId));
        return customAuthzFragment;
    }

    private String getEnhancedGroupAuthorizationWhereFragment(String fragment, int subjectId) {
        String customAuthzFragment = "( %aliasWithFragment%.id IN ( SELECT %aliasWithFragment%.id " + NL + "                    FROM %alias% innerAlias " + NL + "                    JOIN %innerAlias%.roles r JOIN r.subjects s " + NL + "                   WHERE s.id = %subjectId% )" + NL + "  OR" + NL + "  %aliasWithFragment%.id IN ( SELECT %aliasWithFragment%.id " + NL + "                    FROM %alias% innerAlias " + NL + "                    JOIN %innerAlias%.clusterResourceGroup crg JOIN crg.roles r JOIN r.subjects s " + NL + "                   WHERE crg.recursive = true AND s.id = %subjectId% )" + NL + "  OR" + NL + "  %aliasWithFragment%.id IN ( SELECT %aliasWithFragment%.id" + NL + "                    FROM %alias% innerAlias " + NL + "                    JOIN %innerAlias%.subject s" + NL + "                   WHERE s.id = %subjectId% ) ) " + NL;
        String aliasReplacement = this.criteria.getAlias() + (fragment != null ? "." + fragment : "");
        String innerAliasReplacement = "innerAlias" + (fragment != null ? "." + fragment : "");
        customAuthzFragment = customAuthzFragment.replace("%alias%", this.criteria.getAlias());
        customAuthzFragment = customAuthzFragment.replace("%aliasWithFragment%", aliasReplacement);
        customAuthzFragment = customAuthzFragment.replace("%innerAlias%", innerAliasReplacement);
        customAuthzFragment = customAuthzFragment.replace("%subjectId%", String.valueOf(subjectId));
        return customAuthzFragment;
    }

    public String getParameterReplacedQuery(boolean countQuery) {
        String query = this.getQueryString(countQuery);
        for (Map.Entry<String, Object> critField : this.getFilterFields(this.criteria).entrySet()) {
            Object value = critField.getValue();
            if (value instanceof Tag) {
                Tag tag = (Tag)value;
                query = query.replace(":tagNamespace", tag.getNamespace());
                query = query.replace(":tagSemantic", tag.getSemantic());
                query = query.replace(":tagName", tag.getName());
                continue;
            }
            value = this.getParameterReplacedValue(value);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Bind: (" + critField.getKey() + ", " + value + ")"));
            }
            query = query.replace(":" + critField.getKey(), String.valueOf(value));
        }
        if (null != this.authorizationPermsFragment) {
            List requiredPerms = this.criteria.getRequiredPermissions();
            String perms = requiredPerms.toString();
            query = query.replace(":requiredPerms", perms.subSequence(1, perms.length() - 1));
            query = query.replace(":requiredPermsSize", String.valueOf(requiredPerms.size()));
        }
        return query;
    }

    private String getParameterReplacedValue(Object value) {
        String returnValue = null;
        if (value instanceof String) {
            returnValue = "'" + this.prepareStringBindValue((String)value) + "'";
        } else if (value instanceof Enum) {
            EnumType type = this.getPersistenceEnumType(value.getClass());
            returnValue = type == EnumType.STRING ? "'" + String.valueOf(value) + "'" : String.valueOf(value);
        } else if (value instanceof List) {
            List valueList = (List)value;
            StringBuilder results = new StringBuilder();
            boolean first = true;
            for (Object nextValue : valueList) {
                if (first) {
                    first = false;
                } else {
                    results.append(",");
                }
                results.append(this.getParameterReplacedValue(nextValue));
            }
            returnValue = results.toString();
        } else {
            returnValue = String.valueOf(value);
        }
        return returnValue;
    }

    private EnumType getPersistenceEnumType(Class<?> enumFieldType) {
        for (Field nextField : this.getClass().getFields()) {
            Enumerated enumeratedAnnotation;
            nextField.setAccessible(true);
            if (!nextField.getType().equals(enumFieldType) || (enumeratedAnnotation = nextField.getAnnotation(Enumerated.class)) == null) continue;
            return enumeratedAnnotation.value();
        }
        return EnumType.STRING;
    }

    public String getQueryString(boolean countQuery) {
        StringBuilder results = new StringBuilder();
        results.append("SELECT ");
        if (countQuery) {
            if (this.groupByClause == null) {
                results.append("COUNT(").append(this.alias).append(")").append(NL);
            } else {
                results.append("COUNT(DISTINCT ").append(this.groupByClause).append(")").append(NL);
            }
        } else if (this.projection == null) {
            results.append(this.alias).append(NL);
        } else {
            results.append(this.projection).append(NL);
        }
        results.append("FROM ").append(this.className).append(' ').append(this.alias).append(NL);
        if (!countQuery) {
            for (String fetchField : this.getFetchFields(this.criteria)) {
                if (this.isPersistentBag(fetchField)) {
                    this.addPersistentBag(fetchField);
                    continue;
                }
                if (this.projection == null) {
                    results.append("LEFT JOIN FETCH ").append(this.alias).append('.').append(fetchField).append(NL);
                    continue;
                }
                this.addJoinFetch(fetchField);
            }
        }
        PageControl pc = CriteriaQueryGenerator.getPageControl(this.criteria);
        ArrayList<String> orderingFieldRequiredJoins = new ArrayList<String>();
        ArrayList<String> orderingFieldTokens = new ArrayList<String>();
        for (OrderingField orderingField : pc.getOrderingFields()) {
            String sortFragment;
            PageOrdering ordering = orderingField.getOrdering();
            String fieldName = orderingField.getField();
            String override = this.criteria.getJPQLSortOverride(fieldName);
            String suffix = override == null ? fieldName : override;
            boolean doNotPrefixAlias = this.isNumber(suffix) || this.criteria.hasCustomizedSorting();
            String string = sortFragment = doNotPrefixAlias ? suffix : this.alias + "." + suffix;
            if (this.criteria.hasCustomizedSorting()) {
                orderingFieldTokens.add(sortFragment + " " + ordering);
                continue;
            }
            int lastDelimiterIndex = sortFragment.lastIndexOf(46);
            if (lastDelimiterIndex == -1) {
                orderingFieldTokens.add(sortFragment + " " + ordering);
                continue;
            }
            int firstDelimiterIndex = sortFragment.indexOf(46);
            if (firstDelimiterIndex == lastDelimiterIndex) {
                orderingFieldTokens.add(sortFragment + " " + ordering);
                continue;
            }
            String expressionRoot = sortFragment.substring(0, lastDelimiterIndex);
            String expressionLeaf = sortFragment.substring(lastDelimiterIndex + 1);
            int expressionRootIndex = orderingFieldRequiredJoins.indexOf(expressionRoot);
            String joinAlias = null;
            if (expressionRootIndex == -1) {
                joinAlias = "orderingField" + orderingFieldRequiredJoins.size();
                orderingFieldRequiredJoins.add(expressionRoot);
                results.append("LEFT JOIN ").append(expressionRoot).append(" ").append(joinAlias).append(NL);
            } else {
                joinAlias = "orderingField" + expressionRootIndex;
            }
            orderingFieldTokens.add(joinAlias + "." + expressionLeaf + " " + ordering);
        }
        Map<String, Object> filterFields = this.getFilterFields(this.criteria);
        if (filterFields.size() > 0 || this.authorizationPermsFragment != null || this.authorizationCustomConditionFragment != null || this.searchExpressionWhereClause != null) {
            results.append("WHERE ");
        }
        String conjunctiveFragment = this.criteria.isFiltersOptional() ? "OR " : "AND ";
        boolean wantCaseInsensitiveMatch = !this.criteria.isCaseSensitive();
        StringBuilder conjunctiveResults = new StringBuilder();
        boolean firstCrit = true;
        for (Map.Entry<String, Object> filterField : filterFields.entrySet()) {
            if (firstCrit) {
                firstCrit = false;
            } else {
                conjunctiveResults.append(NL).append(conjunctiveFragment);
            }
            String fieldName = filterField.getKey();
            String override = this.criteria.getJPQLFilterOverride(fieldName);
            String fragment = null;
            if (override != null) {
                fragment = this.fixFilterOverride(override, fieldName);
            } else {
                String operator = "=";
                if (filterField.getValue() instanceof String) {
                    operator = "like";
                    fragment = wantCaseInsensitiveMatch ? "LOWER( " + this.alias + "." + fieldName + " ) " + operator + " :" + fieldName : this.alias + "." + fieldName + " " + operator + " :" + fieldName;
                    fragment = fragment + QueryUtility.getEscapeClause();
                } else {
                    fragment = this.alias + "." + fieldName + " " + operator + " :" + fieldName;
                }
            }
            conjunctiveResults.append(fragment).append(' ');
        }
        if (conjunctiveResults.length() > 0) {
            results.append("( ").append((CharSequence)conjunctiveResults).append(")");
        }
        if (this.authorizationPermsFragment != null) {
            if (firstCrit) {
                firstCrit = false;
            } else {
                results.append(NL).append(" AND ");
            }
            results.append(this.authorizationPermsFragment + " ");
        }
        if (this.authorizationCustomConditionFragment != null) {
            if (firstCrit) {
                firstCrit = false;
            } else {
                results.append(NL).append(" AND ");
            }
            results.append(this.authorizationCustomConditionFragment);
        }
        if (this.searchExpressionWhereClause != null) {
            if (firstCrit) {
                firstCrit = false;
            } else {
                results.append(NL).append(" AND ");
            }
            results.append(this.searchExpressionWhereClause);
        }
        if (!countQuery) {
            if (this.groupByClause != null) {
                results.append(NL).append("GROUP BY ").append(this.groupByClause);
            }
            if (this.havingClause != null) {
                results.append(NL).append("HAVING ").append(this.havingClause);
            }
            boolean first = true;
            for (String next : orderingFieldTokens) {
                if (first) {
                    results.append(NL).append("ORDER BY ");
                    first = false;
                } else {
                    results.append(", ");
                }
                results.append(next);
            }
        }
        results.append(NL);
        LOG.debug((Object)results);
        return results.toString();
    }

    private boolean isNumber(String input) {
        if (input == null) {
            return false;
        }
        for (char next : input.toCharArray()) {
            if (Character.isDigit(next)) continue;
            return false;
        }
        return true;
    }

    public List<String> getFetchFields(Criteria criteria) {
        ArrayList<String> results = new ArrayList<String>();
        for (Field fetchField : CriteriaQueryGenerator.getFields(criteria, Criteria.Type.FETCH)) {
            boolean shouldFetch;
            Object fetchFieldValue = null;
            try {
                fetchField.setAccessible(true);
                fetchFieldValue = fetchField.get(criteria);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
            if (fetchFieldValue == null || !(shouldFetch = ((Boolean)fetchFieldValue).booleanValue())) continue;
            results.add(CriteriaQueryGenerator.getCleansedFieldName(fetchField, 5));
        }
        return results;
    }

    private static List<Field> getFields(Criteria criteria, Criteria.Type fieldType) {
        String prefix = fieldType.name().toLowerCase();
        ArrayList<Field> results = new ArrayList<Field>();
        Class<?> currentLevelClass = criteria.getClass();
        while (!currentLevelClass.equals(Criteria.class)) {
            for (Field field : currentLevelClass.getDeclaredFields()) {
                field.setAccessible(true);
                if (!field.getName().startsWith(prefix)) continue;
                results.add(field);
            }
            currentLevelClass = currentLevelClass.getSuperclass();
        }
        return results;
    }

    public static String getCleansedFieldName(Field field, int leadingCharsToStrip) {
        String fieldNameFragment = field.getName().substring(leadingCharsToStrip);
        String fieldName = Character.toLowerCase(fieldNameFragment.charAt(0)) + fieldNameFragment.substring(1);
        return fieldName;
    }

    public Map<String, Object> getFilterFields(Criteria criteria) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (Field filterField : CriteriaQueryGenerator.getFields(criteria, Criteria.Type.FILTER)) {
            Object filterFieldValue = null;
            try {
                filterFieldValue = filterField.get(criteria);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
            if (filterFieldValue == null) continue;
            results.put(CriteriaQueryGenerator.getCleansedFieldName(filterField, 6), filterFieldValue);
        }
        return results;
    }

    private void initializeJPQLFragmentFromSearchExpression() {
        String searchExpression = this.criteria.getSearchExpression();
        if (searchExpression == null) {
            return;
        }
        try {
            Class entityClass = this.criteria.getPersistentClass();
            SearchTranslationManager searchManager = new SearchTranslationManager(this.criteria.getAlias(), this.subject, SearchSubsystem.get((Class)entityClass));
            searchManager.setExpression(searchExpression);
            String translatedJPQL = searchManager.getJPQLWhereFragment();
            LOG.debug((Object)("Translated JPQL Fragment was: " + translatedJPQL));
            if (translatedJPQL != null) {
                this.searchExpressionWhereClause = translatedJPQL;
            }
        }
        catch (SearchExpressionException see) {
            throw see;
        }
        catch (RuntimeException re) {
            LOG.error((Object)("Could not get JPQL translation for '" + searchExpression + "': " + ThrowableUtil.getAllMessages((Throwable)re, (boolean)true)));
            throw re;
        }
        catch (Exception e) {
            LOG.error((Object)("Could not get JPQL translation for '" + searchExpression + "': " + ThrowableUtil.getAllMessages((Throwable)e, (boolean)true)));
            throw new RuntimeException(e);
        }
    }

    private boolean isPersistentBag(String fieldName) {
        try {
            Class persistentClass = this.criteria.getPersistentClass();
            Field field = persistentClass.getDeclaredField(fieldName);
            return this.isAList(field) && !field.isAnnotationPresent(IndexColumn.class);
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    private boolean isAList(Field field) {
        Class<?> fieldType = field.getType();
        if (List.class.isAssignableFrom(fieldType)) {
            return true;
        }
        for (Class<?> declaredInterface : fieldType.getInterfaces()) {
            if (!List.class.isAssignableFrom(declaredInterface)) continue;
            return true;
        }
        return false;
    }

    private void addPersistentBag(String fieldName) {
        try {
            Field field = this.criteria.getPersistentClass().getDeclaredField(fieldName);
            this.persistentBagFields.add(field);
        }
        catch (NoSuchFieldException e) {
            LOG.warn((Object)"Failed to add persistent bag collection.", (Throwable)e);
        }
    }

    private void addJoinFetch(String fieldName) {
        try {
            Field field = this.criteria.getPersistentClass().getDeclaredField(fieldName);
            this.joinFetchFields.add(field);
        }
        catch (NoSuchFieldException e) {
            LOG.warn((Object)"Failed to add join fetch field.", (Throwable)e);
        }
    }

    public List<Field> getPersistentBagFields() {
        return this.persistentBagFields;
    }

    public List<Field> getJoinFetchFields() {
        return this.joinFetchFields;
    }

    public void alterProjection(String projection) {
        this.projection = projection;
    }

    public boolean isProjectionAltered() {
        return this.projection != null;
    }

    public void setGroupByClause(String groupByClause) {
        if (groupByClause != null && this.projection == null) {
            throw new IllegalArgumentException("Must alter projection before calling setGroupByClause");
        }
        this.groupByClause = groupByClause;
    }

    public void setHavingClause(String havingClause) {
        if (havingClause != null && this.groupByClause == null) {
            throw new IllegalArgumentException("Must add some groupBy clause before calling setHavingClause");
        }
        this.havingClause = havingClause;
    }

    public Query getQuery(EntityManager em) {
        String queryString = this.getQueryString(false);
        Query query = em.createQuery(queryString);
        this.setBindValues(query, false);
        PersistenceUtility.setDataPage((Query)query, (PageControl)CriteriaQueryGenerator.getPageControl(this.criteria));
        return query;
    }

    public Query getCountQuery(EntityManager em) {
        String countQueryString = this.getQueryString(true);
        Query query = em.createQuery(countQueryString);
        this.setBindValues(query, false);
        return query;
    }

    private void setBindValues(Query query, boolean countQuery) {
        for (Map.Entry<String, Object> critField : this.getFilterFields(this.criteria).entrySet()) {
            Object value = critField.getValue();
            if (value instanceof Tag) {
                Tag tag = (Tag)value;
                query.setParameter("tagNamespace", (Object)tag.getNamespace());
                query.setParameter("tagSemantic", (Object)tag.getSemantic());
                query.setParameter("tagName", (Object)tag.getName());
                continue;
            }
            if (value instanceof String) {
                value = this.prepareStringBindValue((String)value);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Bind: (" + critField.getKey() + ", " + value + ")"));
            }
            query.setParameter(critField.getKey(), value);
        }
        if (null != this.authorizationPermsFragment) {
            List requiredPerms = this.criteria.getRequiredPermissions();
            query.setParameter("requiredPerms", (Object)requiredPerms);
            query.setParameter("requiredPermsSize", (Object)requiredPerms.size());
        }
    }

    private String prepareStringBindValue(String value) {
        if (!this.criteria.isStrict()) {
            value = "%" + QueryUtility.escapeSearchParameter(value) + "%";
        }
        if (!this.criteria.isCaseSensitive()) {
            value = value.toLowerCase();
        }
        return value;
    }

    public static void main(String[] args) {
        CriteriaQueryGenerator.testResourceGroupCriteria();
    }

    public static void testSubjectCriteria() {
        SubjectCriteria subjectCriteria = new SubjectCriteria();
        subjectCriteria.addFilterFirstName("joe");
        subjectCriteria.addFilterFactive(Boolean.valueOf(true));
        subjectCriteria.fetchRoles(true);
        subjectCriteria.addSortName(PageOrdering.ASC);
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        CriteriaQueryGenerator subjectGenerator = new CriteriaQueryGenerator(overlord, (Criteria)subjectCriteria);
        System.out.println(subjectGenerator.getQueryString(false));
        System.out.println(subjectGenerator.getQueryString(true));
    }

    public static void testAlertCriteria() {
        AlertCriteria alertCriteria = new AlertCriteria();
        alertCriteria.addFilterName("joe");
        alertCriteria.addFilterDescription("query generation is cool");
        alertCriteria.addFilterStartTime(Long.valueOf(42L));
        alertCriteria.addFilterEndTime(Long.valueOf(100L));
        alertCriteria.addFilterResourceIds(new Integer[]{1, 2, 3});
        alertCriteria.fetchAlertDefinition(true);
        alertCriteria.addSortPriority(PageOrdering.DESC);
        alertCriteria.addSortName(PageOrdering.ASC);
        alertCriteria.setPaging(0, 100);
        alertCriteria.setFiltersOptional(true);
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(overlord, (Criteria)alertCriteria);
        System.out.println(generator.getQueryString(false));
        System.out.println(generator.getQueryString(true));
        generator.setAuthorizationResourceFragment(AuthorizationTokenType.RESOURCE, "definition.resource", 1);
        System.out.println(generator.getQueryString(false));
        System.out.println(generator.getQueryString(true));
    }

    public static void testInheritanceCriteria() {
        ResourceOperationHistoryCriteria historyCriteria = new ResourceOperationHistoryCriteria();
        historyCriteria.addFilterResourceIds(new Integer[]{1});
        historyCriteria.addFilterStatus(OperationRequestStatus.FAILURE);
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(overlord, (Criteria)historyCriteria);
        System.out.println(generator.getQueryString(false));
        System.out.println(generator.getQueryString(true));
    }

    public static void testResourceGroupCriteria() {
        ResourceGroupCriteria groupCriteria = new ResourceGroupCriteria();
        groupCriteria.addSortName(PageOrdering.DESC);
        groupCriteria.addSortResourceTypeName(PageOrdering.ASC);
        groupCriteria.addSortPluginName(PageOrdering.DESC);
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(new Subject(), (Criteria)groupCriteria);
        System.out.println(generator.getQueryString(false));
        System.out.println(generator.getQueryString(true));
        PageControl customPC = new PageControl();
        customPC.addDefaultOrderingField("0", PageOrdering.DESC);
        customPC.addDefaultOrderingField("name", PageOrdering.DESC);
        customPC.addDefaultOrderingField("resourceType.name", PageOrdering.ASC);
        groupCriteria.setPageControl(customPC);
        System.out.println(generator.getQueryString(false));
        System.out.println(generator.getQueryString(true));
    }

    public static void testResourceCriteria() {
        ResourceCriteria resourceCriteria = new ResourceCriteria();
        resourceCriteria.addFilterResourceCategories(new ResourceCategory[]{ResourceCategory.SERVER});
        resourceCriteria.addFilterName("marques");
        resourceCriteria.fetchAgent(true);
        resourceCriteria.addSortResourceTypeName(PageOrdering.ASC);
        resourceCriteria.setCaseSensitive(true);
        resourceCriteria.setFiltersOptional(true);
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(overlord, (Criteria)resourceCriteria);
        System.out.println(generator.getQueryString(false));
        System.out.println(generator.getQueryString(true));
    }

    public static PageControl getPageControl(Criteria criteria) {
        PageControl pc = null;
        if (criteria.getPageControlOverrides() != null) {
            pc = criteria.getPageControlOverrides();
        } else {
            pc = criteria.getPageNumber() == null || criteria.getPageSize() == null ? PageControl.getUnlimitedInstance() : new PageControl(criteria.getPageNumber().intValue(), criteria.getPageSize().intValue());
            for (String fieldName : criteria.getOrderingFieldNames()) {
                for (Field sortField : CriteriaQueryGenerator.getFields(criteria, Criteria.Type.SORT)) {
                    if (!sortField.getName().equals(fieldName)) continue;
                    Object sortFieldValue = null;
                    try {
                        sortFieldValue = sortField.get(criteria);
                    }
                    catch (IllegalAccessException iae) {
                        throw new RuntimeException(iae);
                    }
                    if (sortFieldValue == null) continue;
                    PageOrdering pageOrdering = (PageOrdering)sortFieldValue;
                    pc.addDefaultOrderingField(CriteriaQueryGenerator.getCleansedFieldName(sortField, 4), pageOrdering);
                }
            }
        }
        return pc;
    }

    static {
        EXPRESSION_START_KEYWORDS.add("NOT");
        EXPRESSION_START_KEYWORDS.add("EXISTS");
    }

    public static enum AuthorizationTokenType {
        RESOURCE,
        GROUP;

    }
}

