/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Comparator;
import java.util.List;
import org.testng.IMethodInstance;
import org.testng.ITestNGMethod;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlTest;

public class MethodInstance
implements IMethodInstance {
    private ITestNGMethod m_method;
    private Object[] m_instances;
    public static final Comparator<IMethodInstance> SORT_BY_INDEX = new Comparator<IMethodInstance>(){

        @Override
        public int compare(IMethodInstance o1, IMethodInstance o2) {
            XmlTest test1 = o1.getMethod().getTestClass().getXmlTest();
            XmlTest test2 = o2.getMethod().getTestClass().getXmlTest();
            if (!test1.getName().equals(test2.getName())) {
                return 0;
            }
            int result = 0;
            XmlClass class1 = o1.getMethod().getTestClass().getXmlClass();
            XmlClass class2 = o2.getMethod().getTestClass().getXmlClass();
            if (!class1.getName().equals(class2.getName())) {
                int index1 = class1.getIndex();
                int index2 = class2.getIndex();
                result = index1 - index2;
            } else {
                XmlInclude include1 = this.findXmlInclude(class1.getIncludedMethods(), o1.getMethod().getMethodName());
                XmlInclude include2 = this.findXmlInclude(class2.getIncludedMethods(), o2.getMethod().getMethodName());
                if (include1 != null && include2 != null) {
                    result = include1.getIndex() - include2.getIndex();
                }
            }
            return result;
        }

        private XmlInclude findXmlInclude(List<XmlInclude> includedMethods, String methodName) {
            for (XmlInclude xi : includedMethods) {
                if (!xi.getName().equals(methodName)) continue;
                return xi;
            }
            return null;
        }
    };

    public MethodInstance(ITestNGMethod method, Object[] instances) {
        this.m_method = method;
        this.m_instances = instances;
    }

    public ITestNGMethod getMethod() {
        return this.m_method;
    }

    public Object[] getInstances() {
        return this.m_instances;
    }

    public String toString() {
        return "[MethodInstance m:" + this.m_method + " i:" + this.m_instances[0];
    }
}

