/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.internal.ClassHelper;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlInclude;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlClass
implements Serializable,
Cloneable {
    private List<XmlInclude> m_includedMethods = Lists.newArrayList();
    private List<String> m_excludedMethods = Lists.newArrayList();
    private String m_name = null;
    private Class m_class = null;
    private Boolean m_declaredClass = null;
    private int m_index;

    public XmlClass(String name) {
        this.init(name, null, Boolean.TRUE, 0);
    }

    public XmlClass(Class className) {
        this.init(className.getName(), null, Boolean.TRUE, 0);
    }

    public XmlClass(String name, Boolean declaredClass, int index) {
        this.init(name, null, declaredClass, index);
    }

    public XmlClass(Class className, Boolean declaredClass) {
        this.init(className.getName(), className, declaredClass, 0);
    }

    private void init(String name, Class className, Boolean declaredClass, int index) {
        this.m_name = name;
        this.m_class = className;
        this.m_declaredClass = declaredClass;
        this.m_index = index;
    }

    public Class getSupportClass() {
        if (null == this.m_class) {
            this.m_class = ClassHelper.forName(this.m_name);
            if (null == this.m_class) {
                throw new TestNGException("Cannot find class in classpath: " + this.m_name);
            }
        }
        return this.m_class;
    }

    public void setClass(Class className) {
        this.m_class = className;
    }

    public List<String> getExcludedMethods() {
        return this.m_excludedMethods;
    }

    public void setExcludedMethods(List<String> excludedMethods) {
        this.m_excludedMethods = excludedMethods;
    }

    public List<XmlInclude> getIncludedMethods() {
        return this.m_includedMethods;
    }

    public void setIncludedMethods(List<XmlInclude> includedMethods) {
        this.m_includedMethods = includedMethods;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public Boolean getDeclaredClass() {
        return this.m_declaredClass;
    }

    public void setDeclaredClass(Boolean declaredClass) {
        this.m_declaredClass = declaredClass;
    }

    public String toString() {
        return "[Class: " + this.m_name + "]";
    }

    public String toXml(String indent) {
        XMLStringBuffer xsb = new XMLStringBuffer(indent);
        Properties pro = new Properties();
        pro.setProperty("name", this.getName());
        if (!this.m_includedMethods.isEmpty() || !this.m_excludedMethods.isEmpty()) {
            xsb.push("class", pro);
            xsb.push("methods");
            for (XmlInclude xmlInclude : this.getIncludedMethods()) {
                xsb.getStringBuffer().append(xmlInclude.toXml(indent + "    "));
            }
            for (String string : this.getExcludedMethods()) {
                Properties p = new Properties();
                p.setProperty("name", string);
                xsb.addEmptyElement("exclude", p);
            }
            xsb.pop("methods");
            xsb.pop("class");
        } else {
            xsb.addEmptyElement("class", pro);
        }
        return xsb.toXML();
    }

    public static String listToString(List<Integer> invocationNumbers) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        for (Integer n : invocationNumbers) {
            if (i++ > 0) {
                result.append(" ");
            }
            result.append(n);
        }
        return result.toString();
    }

    public Object clone() {
        XmlClass result = new XmlClass(this.getName(), this.getDeclaredClass(), this.getIndex());
        result.setExcludedMethods(this.getExcludedMethods());
        result.setIncludedMethods(this.getIncludedMethods());
        return result;
    }

    public int getIndex() {
        return this.m_index;
    }
}

