/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.WebParam;
import javax.script.Bindings;
import javax.script.ScriptContext;
import jline.Completor;
import jline.ConsoleReader;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.client.RemoteClientProxy;
import org.rhq.enterprise.client.utility.ReflectionUtility;

public class InteractiveJavascriptCompletor
implements Completor {
    private Map<String, Object> services;
    private ScriptContext context;
    private String lastComplete;
    private int recomplete;
    private ConsoleReader consoleReader;
    private static final Set<String> IGNORED_METHODS = new HashSet<String>();

    public InteractiveJavascriptCompletor(ConsoleReader reader) {
        this.consoleReader = reader;
    }

    public void setServices(Map<String, Object> services) {
        this.services = services;
    }

    public int complete(String s, int i, List list) {
        try {
            this.recomplete = this.lastComplete != null && this.lastComplete.equals(s) ? ++this.recomplete : 1;
            this.lastComplete = s;
            String base = s;
            int rootLength = 0;
            if (s.indexOf(61) > 0) {
                base = s.substring(s.indexOf("=") + 1).trim();
                rootLength = s.length() - base.length();
            }
            String[] call = base.split("\\.");
            if (base.endsWith(".")) {
                String[] argPadded = new String[call.length + 1];
                System.arraycopy(call, 0, argPadded, 0, call.length);
                argPadded[call.length] = "";
                call = argPadded;
            }
            if (call.length == 1) {
                Map<String, Object> matches = this.getContextMatches(call[0]);
                if (matches.size() == 1 && matches.containsKey(call[0]) && !s.endsWith(".")) {
                    list.add(".");
                    return rootLength + call[0].length() + 1;
                }
                list.addAll(matches.keySet());
            } else {
                Object rootObject = this.context.getAttribute(call[0]);
                if (rootObject != null) {
                    String theRest = base.substring(call[0].length() + 1, base.length());
                    int matchIndex = this.contextComplete(rootObject, theRest, i, list);
                    Collections.sort(list);
                    return rootLength + call[0].length() + 1 + matchIndex;
                }
            }
            Collections.sort(list);
            return list.size() == 0 ? -1 : rootLength;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int contextComplete(Object baseObject, String s, int i, List list) {
        String temp = s.split("\\(", 2)[0];
        if (temp.contains(".")) {
            Map<String, List<Object>> matches;
            String[] call = temp.split("\\.", 2);
            String next = call[0];
            if (next.contains("(")) {
                next = next.substring(0, next.indexOf("("));
            }
            if (!(matches = this.getContextMatches(baseObject, next)).isEmpty()) {
                Class<?> rootObject = matches.get(next).get(0);
                if (rootObject instanceof PropertyDescriptor && !(baseObject instanceof Class)) {
                    try {
                        rootObject = InteractiveJavascriptCompletor.invoke(baseObject, ((PropertyDescriptor)((Object)rootObject)).getReadMethod());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (rootObject instanceof Method) {
                    rootObject = ((Method)((Object)rootObject)).getReturnType();
                }
                return call[0].length() + 1 + this.contextComplete(rootObject, call[1], i, list);
            }
            return -1;
        }
        String[] call = s.split("\\(", 2);
        Map<String, List<Object>> matches = this.getContextMatches(baseObject, call[0]);
        if (call.length == 2 && matches.containsKey(call[0])) {
            int x = 0;
            for (String key : matches.keySet()) {
                List<Object> matchList = matches.get(key);
                if (this.recomplete == 2) {
                    ArrayList<Method> methods = new ArrayList<Method>();
                    for (Object match : matchList) {
                        if (!(match instanceof Method)) continue;
                        methods.add((Method)match);
                    }
                    this.displaySignatures(baseObject, methods.toArray(new Method[methods.size()]));
                    return -1;
                }
                for (Object match : matchList) {
                    int result;
                    if (!key.equals(call[0]) || !(match instanceof Method) || (result = this.completeParameters(baseObject, call[1], i, list, (Method)match)) <= 0) continue;
                    x = result;
                }
            }
            return call[0].length() + 1 + x;
        }
        if (matches.size() == 1 && matches.containsKey(call[0])) {
            if (matches.get(call[0]).get(0) instanceof Method) {
                list.add("(" + (((Method)matches.get(call[0]).get(0)).getParameterTypes().length == 0 ? ")" : ""));
            }
            return call[0].length() + 1;
        }
        if (this.recomplete == 2) {
            ArrayList<Method> methods = new ArrayList<Method>();
            for (List<Object> matchList : matches.values()) {
                for (Object val : matchList) {
                    if (!(val instanceof Method)) continue;
                    methods.add((Method)val);
                }
            }
            this.displaySignatures(baseObject, methods.toArray(new Method[methods.size()]));
        } else if (matches.size() == 1 && matches.values().iterator().next().get(0) instanceof Method) {
            list.add(matches.keySet().iterator().next() + "(" + (((Method)matches.values().iterator().next().get(0)).getParameterTypes().length == 0 ? ")" : ""));
        } else {
            list.addAll(matches.keySet());
        }
        return 0;
    }

    private void displaySignatures(Object object, Method ... methods) {
        try {
            String start = this.consoleReader.getCursorBuffer().getBuffer().toString();
            while (this.consoleReader.getCursorBuffer().cursor > 0 && this.consoleReader.backspace()) {
            }
            this.consoleReader.printNewline();
            this.consoleReader.printNewline();
            String[][] signatures = new String[methods.length][];
            int i = 0;
            for (Method m : methods) {
                signatures[i++] = InteractiveJavascriptCompletor.getSignature(object, m).split(" ", 2);
            }
            int maxReturnLength = 0;
            for (String[] sig : signatures) {
                if (sig[0].length() <= maxReturnLength) continue;
                maxReturnLength = sig[0].length();
            }
            for (String[] sig : signatures) {
                for (i = 0; i < maxReturnLength - sig[0].length(); ++i) {
                    this.consoleReader.printString(" ");
                }
                this.consoleReader.printString(sig[0]);
                this.consoleReader.printString(" ");
                this.consoleReader.printString(sig[1]);
                this.consoleReader.printNewline();
            }
            this.consoleReader.drawLine();
            this.consoleReader.putString(start);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int completeParameters(Object baseObject, String params, int i, List list, Method method) {
        String[] paramList = params.split(",");
        Class<?>[] c = method.getParameterTypes();
        String lastParam = paramList[paramList.length - 1];
        int paramIndex = paramList.length - 1;
        if (params.trim().endsWith(",")) {
            lastParam = "";
            ++paramIndex;
        }
        int baseLength = 0;
        for (int x = 0; x < paramIndex; ++x) {
            Object paramFound = this.context.getAttribute(paramList[x]);
            if (paramFound != null && !c[x].isAssignableFrom(paramFound.getClass())) {
                return -1;
            }
            baseLength += paramList[x].length() + 1;
        }
        if (paramIndex >= c.length) {
            if (params.endsWith(")")) {
                return -1;
            }
            list.add(params + ")");
            return (params + ")").length();
        }
        if (baseObject instanceof Map && method.getName().equals("get") && method.getParameterTypes().length == 1) {
            Class<?> keyType = method.getParameterTypes()[0];
            for (Object key : ((Map)baseObject).keySet()) {
                String lookupChoice = "'" + String.valueOf(key) + "'";
                if (!lookupChoice.startsWith(lastParam)) continue;
                list.add(lookupChoice);
            }
            if (list.size() == 1) {
                list.set(0, list.get(0) + ")");
            }
        } else {
            Class<?> parameterType = c[paramIndex];
            Map<String, Object> matches = this.getContextMatches(lastParam, parameterType);
            if (matches.size() == 1 && matches.containsKey(lastParam)) {
                list.add(paramIndex == c.length - 1 ? ")" : ",");
                return baseLength + lastParam.length();
            }
            list.addAll(matches.keySet());
        }
        return baseLength;
    }

    private Map<String, Object> getContextMatches(String start) {
        HashMap<String, Object> found = new HashMap<String, Object>();
        if (this.context != null) {
            for (Integer scope : this.context.getScopes()) {
                Bindings bindings = this.context.getBindings(scope);
                for (String var : bindings.keySet()) {
                    if (!var.startsWith(start)) continue;
                    found.put(var, bindings.get(var));
                }
            }
        }
        if (this.services != null) {
            for (String var : this.services.keySet()) {
                if (!var.startsWith(start)) continue;
                found.put(var, this.services.get(var));
            }
        }
        return found;
    }

    private Map<String, Object> getContextMatches(String start, Class typeFilter) {
        HashMap<String, Object> found = new HashMap<String, Object>();
        if (this.context != null) {
            for (int scope : this.context.getScopes()) {
                Bindings bindings = this.context.getBindings(scope);
                for (String var : bindings.keySet()) {
                    if (!var.startsWith(start) || (bindings.get(var) == null || !typeFilter.isAssignableFrom(bindings.get(var).getClass())) && this.recomplete != 3) continue;
                    found.put(var, bindings.get(var));
                }
            }
            if (typeFilter.isEnum()) {
                for (Object ec : typeFilter.getEnumConstants()) {
                    Enum e = (Enum)ec;
                    String code = typeFilter.getSimpleName() + "." + e.name();
                    if (!code.startsWith(start)) continue;
                    found.put(typeFilter.getSimpleName() + "." + e.name(), e);
                }
            }
        }
        return found;
    }

    private Map<String, List<Object>> getContextMatches(Object baseObject, String start) {
        HashMap<String, List<Object>> found = new HashMap<String, List<Object>>();
        Class<?> baseObjectClass = null;
        baseObjectClass = baseObject instanceof Class ? (Class<?>)baseObject : baseObject.getClass();
        try {
            MethodDescriptor[] methods;
            PropertyDescriptor[] descriptors;
            if (baseObjectClass.equals(Void.TYPE)) {
                return found;
            }
            BeanInfo info = null;
            info = baseObjectClass.isInterface() || baseObjectClass.equals(Object.class) ? Introspector.getBeanInfo(baseObjectClass) : Introspector.getBeanInfo(baseObjectClass, Object.class);
            HashSet<Method> methodsCovered = new HashSet<Method>();
            for (PropertyDescriptor desc : descriptors = info.getPropertyDescriptors()) {
                if (!desc.getName().startsWith(start) || IGNORED_METHODS.contains(desc.getName())) continue;
                ArrayList<PropertyDescriptor> list = (ArrayList<PropertyDescriptor>)found.get(desc.getName());
                if (list == null) {
                    list = new ArrayList<PropertyDescriptor>();
                    found.put(desc.getName(), list);
                }
                list.add(desc);
                methodsCovered.add(desc.getReadMethod());
                methodsCovered.add(desc.getWriteMethod());
            }
            for (MethodDescriptor desc : methods = info.getMethodDescriptors()) {
                boolean startsWithSubject;
                if (!desc.getName().startsWith(start) || methodsCovered.contains(desc.getMethod()) || desc.getName().startsWith("_d") || IGNORED_METHODS.contains(desc.getName())) continue;
                Method m = desc.getMethod();
                boolean isProxy = InteractiveJavascriptCompletor.isProxyMethod(baseObject, m);
                Class<?>[] parameters = m.getParameterTypes();
                boolean bl = startsWithSubject = parameters.length > 0 && parameters[0].equals(Subject.class);
                if ((!isProxy || !startsWithSubject) && startsWithSubject) continue;
                ArrayList<Method> list = (ArrayList<Method>)found.get(desc.getName());
                if (list == null) {
                    list = new ArrayList<Method>();
                    found.put(desc.getName(), list);
                }
                list.add(m);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return found;
    }

    private static String getSignature(Object object, Method m) {
        if (InteractiveJavascriptCompletor.isProxyMethod(object, m)) {
            Class<?>[] params = m.getParameterTypes();
            Class[] newParams = new Class[params.length + 1];
            System.arraycopy(params, 0, newParams, 1, params.length);
            newParams[0] = Subject.class;
            try {
                m = ((RemoteClientProxy)Proxy.getInvocationHandler(object)).getRemoteInterface().getDeclaredMethod(m.getName(), newParams);
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
        }
        StringBuilder buf = new StringBuilder();
        Type[] params = m.getGenericParameterTypes();
        Annotation[][] annotations = m.getParameterAnnotations();
        int i = 0;
        buf.append(ReflectionUtility.getSimpleTypeString(m.getGenericReturnType()));
        buf.append(" ");
        buf.append(m.getName());
        buf.append("(");
        boolean first = true;
        for (Type type : params) {
            if (i == 0 && type.equals(Subject.class)) {
                ++i;
                continue;
            }
            if (!first) {
                buf.append(", ");
            } else {
                first = false;
            }
            String name = null;
            if (annotations != null && annotations.length >= i) {
                Annotation[] as;
                for (Annotation a : as = annotations[i]) {
                    if (!(a instanceof WebParam)) continue;
                    name = ReflectionUtility.getSimpleTypeString(type) + " " + ((WebParam)a).name();
                }
            }
            if (name == null) {
                name = ReflectionUtility.getSimpleTypeString(type);
            }
            buf.append(name);
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    private static boolean isProxyMethod(Object object, Method m) {
        boolean result = false;
        if (object instanceof Proxy && Proxy.getInvocationHandler(object) instanceof RemoteClientProxy) {
            try {
                m = ((RemoteClientProxy)Proxy.getInvocationHandler(object)).getRemoteInterface().getDeclaredMethod(m.getName(), m.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                result = true;
            }
        }
        return result;
    }

    public ScriptContext getContext() {
        return this.context;
    }

    public void setContext(ScriptContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object invoke(Object o, Method m) throws IllegalAccessException, InvocationTargetException {
        boolean access = m.isAccessible();
        m.setAccessible(true);
        try {
            Object object = m.invoke(o, new Object[0]);
            return object;
        }
        finally {
            m.setAccessible(access);
        }
    }

    static {
        IGNORED_METHODS.add("newProxyInstance");
        IGNORED_METHODS.add("hashCode");
        IGNORED_METHODS.add("equals");
        IGNORED_METHODS.add("getInvocationHandler");
        IGNORED_METHODS.add("setHandler");
        IGNORED_METHODS.add("isProxyClass");
        IGNORED_METHODS.add("newProxyInstance");
        IGNORED_METHODS.add("getProxyClass");
        IGNORED_METHODS.add("main");
        IGNORED_METHODS.add("handler");
        IGNORED_METHODS.add("init");
        IGNORED_METHODS.add("initChildren");
        IGNORED_METHODS.add("initMeasurements");
        IGNORED_METHODS.add("initOperations");
    }
}

