/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bindings;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bindings.StandardBindings;
import org.rhq.bindings.engine.JsEngineInitializer;
import org.rhq.bindings.engine.ScriptEngineInitializer;
import org.rhq.bindings.util.PackageFinder;

public class ScriptEngineFactory {
    private static final Log LOG = LogFactory.getLog(ScriptEngineFactory.class);
    private static final ScriptEngineInitializer[] KNOWN_ENGINES = new ScriptEngineInitializer[]{new JsEngineInitializer()};

    private ScriptEngineFactory() {
    }

    public static ScriptEngine getScriptEngine(String language, PackageFinder packageFinder, StandardBindings bindings) throws ScriptException, IOException {
        ScriptEngineInitializer initializer = ScriptEngineFactory.getInitializer(language);
        if (initializer == null) {
            return null;
        }
        ScriptEngine engine = initializer.instantiate(packageFinder.findPackages("org.rhq.core.domain"));
        ScriptEngineFactory.injectStandardBindings(engine, bindings, true);
        return engine;
    }

    public static void injectStandardBindings(ScriptEngine engine, StandardBindings bindings, boolean deleteExistingBindings) {
        bindings.preInject(engine);
        Bindings engineBindings = deleteExistingBindings ? engine.createBindings() : engine.getBindings(100);
        for (Map.Entry entry : bindings.entrySet()) {
            engineBindings.put((String)entry.getKey(), entry.getValue());
        }
        engine.setBindings(engineBindings, 100);
        bindings.postInject(engine);
    }

    public static void bindIndirectionMethods(ScriptEngine scriptEngine, String bindingName, Object object) {
        ScriptEngineInitializer initializer = ScriptEngineFactory.getInitializer(scriptEngine.getFactory().getLanguageName());
        try {
            MethodDescriptor[] methodDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass(), Object.class);
            for (MethodDescriptor methodDescriptor : methodDescriptors = beanInfo.getMethodDescriptors()) {
                Method method = methodDescriptor.getMethod();
                try {
                    String methodDef = initializer.generateIndirectionMethod(bindingName, method);
                    scriptEngine.eval(methodDef);
                }
                catch (ScriptException e) {
                    LOG.warn((Object)("Unable to bind global function " + method.getName()), (Throwable)e);
                }
            }
        }
        catch (IntrospectionException e) {
            LOG.warn((Object)("Could not bind " + object.getClass().getName() + " into script engine."));
        }
    }

    public static ScriptEngineInitializer getInitializer(String language) {
        for (ScriptEngineInitializer i : KNOWN_ENGINES) {
            if (!i.implementsLanguage(language)) continue;
            return i;
        }
        return null;
    }
}

