/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bindings.engine;

import java.lang.reflect.Method;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.rhq.bindings.engine.ScriptEngineInitializer;

public class JsEngineInitializer
implements ScriptEngineInitializer {
    private ScriptEngineManager engineManager = new ScriptEngineManager();

    @Override
    public boolean implementsLanguage(String language) {
        return language != null && ("JavaScript".equals(language) || "ECMAScript".equals(language));
    }

    @Override
    public ScriptEngine instantiate(Set<String> packages) throws ScriptException {
        ScriptEngine eng = this.engineManager.getEngineByName("JavaScript");
        for (String pkg : packages) {
            eng.eval("importPackage(" + pkg + ")");
        }
        return eng;
    }

    @Override
    public String generateIndirectionMethod(String boundObjectName, Method method) {
        String methodName = method.getName();
        int argCount = method.getParameterTypes().length;
        StringBuilder functionBuilder = new StringBuilder();
        functionBuilder.append(methodName).append("(");
        for (int i = 0; i < argCount; ++i) {
            if (i != 0) {
                functionBuilder.append(", ");
            }
            functionBuilder.append("arg_" + i);
        }
        functionBuilder.append(")");
        String functionFragment = functionBuilder.toString();
        boolean returnsVoid = method.getReturnType().equals(Void.TYPE);
        String functionDefinition = "function " + functionFragment + " { " + (returnsVoid ? "" : "return ") + boundObjectName + "." + functionFragment + "; }";
        return functionDefinition;
    }
}

