/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine.model;

import java.util.regex.Pattern;
import org.rhq.core.domain.alert.AlertConditionOperator;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.enterprise.server.alert.engine.model.AbstractEnumCacheElement;

public class EventCacheElement
extends AbstractEnumCacheElement<EventSeverity> {
    private final Pattern eventDetailsPattern;

    private String fixPattern(String regex) {
        boolean sw = regex.startsWith(".*");
        boolean ew = regex.endsWith(".*");
        return (!sw ? ".*" : "") + regex + (!ew ? ".*" : "");
    }

    public EventCacheElement(AlertConditionOperator operator, EventSeverity value, int conditionTriggerId) {
        super(operator, value, conditionTriggerId);
        this.eventDetailsPattern = null;
    }

    public EventCacheElement(AlertConditionOperator operator, String eventDetails, EventSeverity value, int conditionTriggerId) {
        super(operator, (Object)eventDetails, value, conditionTriggerId);
        eventDetails = this.fixPattern(eventDetails);
        this.eventDetailsPattern = Pattern.compile(eventDetails, 42);
    }

    @Override
    public boolean matches(EventSeverity providedValue, Object ... extraParams) {
        boolean matches = super.matches(providedValue, extraParams);
        if (matches && this.eventDetailsPattern != null) {
            Object firstParam = extraParams[0];
            if (!(firstParam instanceof String)) {
                this.log.error((Object)(this.getClass().getSimpleName() + " expected a String, but received a " + extraParams.getClass().getSimpleName()));
            } else {
                matches = matches && this.eventDetailsPattern.matcher((String)firstParam).matches();
            }
        }
        return matches;
    }

    @Override
    public AlertConditionOperator.Type getOperatorSupportsType(AlertConditionOperator operator) {
        if (operator == AlertConditionOperator.CHANGES_TO || operator == AlertConditionOperator.CHANGES_FROM) {
            return AlertConditionOperator.Type.NONE;
        }
        return super.getOperatorSupportsType(operator);
    }
}

