/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.auth;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.server.AllowRhqServerInternalsAccessPermission;
import org.rhq.enterprise.server.auth.AuthSession;
import org.rhq.enterprise.server.auth.SessionException;
import org.rhq.enterprise.server.auth.SessionNotFoundException;
import org.rhq.enterprise.server.auth.SessionTimeoutException;
import org.rhq.enterprise.server.util.LookupUtil;

public final class SessionManager {
    private static final AllowRhqServerInternalsAccessPermission ACCESS_PERMISSION = new AllowRhqServerInternalsAccessPermission();
    private static final Random _random = new Random();
    private static final Map<Integer, AuthSession> _cache = new HashMap<Integer, AuthSession>();
    private static final SessionManager _manager = new SessionManager();
    private static final long DEFAULT_TIMEOUT = 5400000L;
    private static final long OVERLORD_TIMEOUT = 120000L;
    private static final int OVERLORD_SUBJECT_ID = 1;
    private static Subject overlordSubject = null;

    private SessionManager() {
    }

    public static SessionManager getInstance() {
        return _manager;
    }

    public synchronized int getSessionCount() {
        return _cache.size();
    }

    public Subject put(Subject subject) {
        SessionManager.checkPermission();
        return this.put(subject, 5400000L);
    }

    public synchronized Subject put(Subject subject, long timeout) {
        Subject sessionSubject;
        Integer key;
        SessionManager.checkPermission();
        while (_cache.containsKey(key = new Integer(_random.nextInt()))) {
        }
        if (subject.equals((Object)overlordSubject)) {
            sessionSubject = overlordSubject;
            sessionSubject.setSessionId(key);
        } else {
            sessionSubject = this.getSessionSubject(subject, key);
        }
        _cache.put(key, new AuthSession(sessionSubject, timeout));
        return sessionSubject;
    }

    public synchronized Subject getSubject(int sessionId) throws SessionNotFoundException, SessionTimeoutException {
        SessionManager.checkPermission();
        Integer id = new Integer(sessionId);
        AuthSession session = _cache.get(id);
        if (session == null) {
            throw new SessionNotFoundException();
        }
        if (session.isExpired()) {
            this.invalidate(sessionId);
            throw new SessionTimeoutException();
        }
        return session.getSubject(true);
    }

    public synchronized void invalidate(int sessionId) {
        Subject doomedSubject;
        SessionManager.checkPermission();
        Integer sessionIdObj = new Integer(sessionId);
        AuthSession session = _cache.get(sessionIdObj);
        if (session != null && (doomedSubject = session.getSubject(false)).getId() == 1) {
            return;
        }
        _cache.remove(sessionIdObj);
        this.purgeTimedOutSessions();
    }

    public synchronized void purgeTimedOutSessions() {
        SessionManager.checkPermission();
        Iterator<Map.Entry<Integer, AuthSession>> iterator = _cache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, AuthSession> map_entry = iterator.next();
            AuthSession session = map_entry.getValue();
            if (!session.isExpired()) continue;
            iterator.remove();
        }
    }

    public synchronized void invalidate(String username) {
        SessionManager.checkPermission();
        Iterator<Map.Entry<Integer, AuthSession>> iterator = _cache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, AuthSession> map_entry = iterator.next();
            AuthSession session = map_entry.getValue();
            if (!username.equals(session.getSubject(false).getName())) continue;
            iterator.remove();
        }
    }

    public synchronized long getLastAccess(int sessionId) {
        SessionManager.checkPermission();
        AuthSession session = _cache.get(sessionId);
        if (session == null) {
            return -1L;
        }
        return session.getLastAccess();
    }

    public synchronized Subject getOverlord() {
        SessionManager.checkPermission();
        if (overlordSubject == null) {
            overlordSubject = LookupUtil.getSubjectManager().getSubjectById(1);
            if (overlordSubject == null) {
                String err = "Cannot find the system's superuser - the database might be corrupted";
                throw new IllegalStateException(err);
            }
            this.put(overlordSubject, 120000L);
        }
        int session_id = overlordSubject.getSessionId();
        try {
            this.getSubject(session_id);
        }
        catch (SessionException e) {
            session_id = this.put(overlordSubject, 120000L).getSessionId();
            overlordSubject.setSessionId(Integer.valueOf(session_id));
        }
        Subject copy = this.getSessionSubject(overlordSubject, session_id);
        return copy;
    }

    private Subject getSessionSubject(Subject subject, Integer sessionId) {
        Subject copy = new Subject(subject.getName(), subject.getFactive(), subject.getFsystem());
        copy.setId(subject.getId());
        copy.setSessionId(sessionId);
        copy.setDepartment(subject.getDepartment());
        copy.setEmailAddress(subject.getEmailAddress());
        copy.setFirstName(subject.getFirstName());
        copy.setLastName(subject.getLastName());
        copy.setLdapRoles(subject.getLdapRoles());
        copy.setOwnedGroups(subject.getOwnedGroups());
        copy.setPhoneNumber(subject.getPhoneNumber());
        copy.setRoles(subject.getRoles());
        copy.setUserConfiguration(subject.getUserConfiguration());
        return copy;
    }

    private static void checkPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ACCESS_PERMISSION);
        }
    }
}

