/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.install.remote;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.install.remote.AgentInstallInfo;
import org.rhq.core.domain.install.remote.AgentInstallStep;
import org.rhq.core.domain.install.remote.CustomAgentInstallData;
import org.rhq.core.domain.install.remote.RemoteAccessInfo;
import org.rhq.core.domain.install.remote.SSHSecurityException;
import org.rhq.enterprise.server.install.remote.SSHFileSend;
import org.rhq.enterprise.server.util.LookupUtil;

public class SSHInstallUtility {
    public static final String AGENT_STATUS_NOT_INSTALLED = "Agent Not Installed";
    private static final String RHQ_AGENT_LATEST_VERSION_PROP = "rhq-agent.latest.version";
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int CONNECTION_TIMEOUT = 30000;
    private static final long TIMEOUT = 30000L;
    private static final long POLL_TIMEOUT = 1000L;
    private Log log = LogFactory.getLog(SSHInstallUtility.class);
    private final RemoteAccessInfo accessInfo;
    private final Credentials defaultCredentials;
    private final SSHConfiguration sshConfiguration;
    private Session session;

    public SSHInstallUtility(RemoteAccessInfo accessInfo, Credentials defaultCredentials, SSHConfiguration sshConfig) {
        this.accessInfo = accessInfo;
        this.defaultCredentials = defaultCredentials;
        if (sshConfig == null) {
            sshConfig = new SSHConfiguration();
        }
        this.sshConfiguration = sshConfig;
        this.connect();
    }

    public SSHInstallUtility(RemoteAccessInfo accessInfo) {
        this(accessInfo, null, null);
    }

    public RemoteAccessInfo getRemoteAccessInfo() {
        return this.accessInfo;
    }

    public void connect() {
        try {
            JSch jsch = new JSch();
            if (this.sshConfiguration.getKnownHostsFile() != null) {
                jsch.setKnownHosts(this.sshConfiguration.getKnownHostsFile());
            }
            Credentials credentials = this.getCredentialsToUse();
            this.session = jsch.getSession(credentials.getUsername(), this.accessInfo.getHost(), this.accessInfo.getPort());
            if (credentials.getPassword() != null) {
                this.session.setPassword(credentials.getPassword());
            }
            if (this.sshConfiguration.getStrictHostKeyChecking() != null) {
                Properties config = new Properties();
                config.put("StrictHostKeyChecking", this.sshConfiguration.getStrictHostKeyChecking().name());
                this.session.setConfig(config);
            }
            this.session.setUserInfo((UserInfo)new SSHUserInfo());
            this.session.connect(30000);
        }
        catch (JSchException e) {
            throw new RuntimeException("Failed SSH connection", e);
        }
    }

    public void disconnect() {
        this.session.disconnect();
    }

    public boolean isConnected() {
        return this.session.isConnected();
    }

    public boolean agentInstallCheck(String agentInstallPath) {
        String agentWrapperScript = this.buildAgentWrapperScriptPath(agentInstallPath);
        String value = this.executeCommand("if  [ -f '" + agentWrapperScript + "' ]; then echo \"exists\"; fi", "Agent Install Check");
        return value != null && value.trim().length() != 0;
    }

    public AgentInstallInfo installAgent(CustomAgentInstallData customData, String installId) {
        AgentInstallStep step;
        String agentVersion;
        String agentPath;
        String agentFile;
        try {
            File agentBinaryFile = LookupUtil.getAgentManager().getAgentUpdateBinaryFile();
            agentFile = agentBinaryFile.getName();
            agentPath = agentBinaryFile.getCanonicalPath();
            Properties props = LookupUtil.getAgentManager().getAgentUpdateVersionFileContent();
            agentVersion = props.getProperty(RHQ_AGENT_LATEST_VERSION_PROP);
        }
        catch (Exception e) {
            agentVersion = this.getClass().getPackage().getImplementationVersion();
            agentFile = "rhq-enterprise-agent-" + agentVersion + ".jar";
            agentPath = "/tmp/rhq-agent/" + agentFile;
            this.log.warn((Object)("Failed agent binary file lookup - using [" + agentPath + "]"), (Throwable)e);
        }
        if (!new File(agentPath).exists()) {
            throw new RuntimeException("Unable to find agent binary file for installation at [" + agentPath + "]");
        }
        if (customData.getAgentConfigurationXmlFile() != null && !new File(customData.getAgentConfigurationXmlFile()).exists()) {
            throw new RuntimeException("Unable to find custom agent config file at [" + customData.getAgentConfigurationXmlFile() + "]");
        }
        if (customData.getRhqAgentEnvFile() != null && !new File(customData.getRhqAgentEnvFile()).exists()) {
            throw new RuntimeException("Unable to find custom agent environment script file at [" + customData.getRhqAgentEnvFile() + "]");
        }
        String parentPath = customData.getParentPath();
        Credentials credentials = this.getCredentialsToUse();
        String serverAddress = LookupUtil.getServerManager().getServer().getAddress();
        AgentInstallInfo info = new AgentInstallInfo(parentPath, credentials.getUsername(), agentVersion, serverAddress, this.accessInfo.getHost());
        this.executeCommand("uname -a", "Machine uname", info);
        this.executeCommand("java -version", "Java Version Check", info);
        this.executeCommand("mkdir -p '" + parentPath + "'", "Create Agent Install Directory", info);
        this.executeCommand("rm -rf '" + parentPath + "/rhq-agent'", "Remove any previously installed agent", info);
        this.executeCommand("rm -f '" + parentPath + "/rhq-agent-update.log'", "Remove any old agent update logs", info);
        this.executeCommand("rm -f " + parentPath.replace(" ", "\\ ") + "/rhq-enterprise-agent*.jar", "Remove any old agent update binary jars", info);
        this.log.info((Object)("Copying agent binary update distribution file to [" + this.accessInfo.getHost() + "]..."));
        long start = System.currentTimeMillis();
        boolean fileSent = SSHFileSend.sendFile(this.session, agentPath, parentPath);
        AgentInstallStep scpStep = new AgentInstallStep("ssh copy '" + agentPath + "' -> '" + parentPath + "'", "Remote copy the agent binary update distribution", 0, fileSent ? "Success" : "Failed", this.getTimeDiff(start));
        info.addStep(scpStep);
        if (!fileSent) {
            return info;
        }
        this.log.info((Object)"Agent binary update distribution file copied");
        this.executeCommand("cd '" + parentPath + "' ; " + "java -jar '" + parentPath + "/" + agentFile + "' '--install=" + parentPath + "'", "Install Agent", info);
        String agentConfigXmlFilename = parentPath + "/rhq-agent/conf/agent-configuration.xml";
        if (customData.getAgentConfigurationXmlFile() != null) {
            this.log.info((Object)"Copying custom agent configuration file...");
            start = System.currentTimeMillis();
            fileSent = SSHFileSend.sendFile(this.session, customData.getAgentConfigurationXmlFile(), agentConfigXmlFilename);
            AgentInstallStep step2 = new AgentInstallStep("ssh copy '" + customData.getAgentConfigurationXmlFile() + "' -> '" + agentConfigXmlFilename + "'", "Remote copy the agent configuration file", 0, fileSent ? "Success" : "Failed", this.getTimeDiff(start));
            info.addStep(step2);
            if (!fileSent) {
                return info;
            }
            this.log.info((Object)"Custom agent configuration file copied.");
            info.setCustomAgentConfigurationFile("agent-configuration.xml");
        }
        String agentPortAwkCommand = "awk '-F\"' '/key.*=.*rhq.communications.connector.bind-port/ {print $4}' '" + agentConfigXmlFilename + "'";
        String portStr = this.executeCommand(agentPortAwkCommand, "Determine the agent's bind port", info);
        try {
            int port = Integer.parseInt(portStr.trim());
            info.setAgentPort(port);
        }
        catch (NumberFormatException nfe) {
            info.setAgentPort(0);
        }
        if (customData.getRhqAgentEnvFile() != null) {
            this.log.info((Object)"Copying custom agent environment script...");
            String destFilename = parentPath + "/rhq-agent/bin/rhq-agent-env.sh";
            start = System.currentTimeMillis();
            fileSent = SSHFileSend.sendFile(this.session, customData.getRhqAgentEnvFile(), destFilename);
            step = new AgentInstallStep("ssh copy '" + customData.getRhqAgentEnvFile() + "' -> '" + destFilename + "'", "Remote copy the agent environment script file", 0, fileSent ? "Success" : "Failed", this.getTimeDiff(start));
            info.addStep(step);
            if (!fileSent) {
                return info;
            }
            this.log.info((Object)"Custom agent environment script copied.");
        }
        start = System.currentTimeMillis();
        Boolean squatterCheck = this.checkAgentConnection(info, 1);
        if (squatterCheck != null) {
            if (squatterCheck.booleanValue()) {
                step = new AgentInstallStep("ping " + info.getAgentAddress() + ":" + info.getAgentPort(), "See if anything has already taken the agent port", 1, "Port already in use", this.getTimeDiff(start));
                info.addStep(step);
                return info;
            }
            step = new AgentInstallStep("ping " + info.getAgentAddress() + ":" + info.getAgentPort(), "See if anything has already taken the agent port", 0, "Port free", this.getTimeDiff(start));
            info.addStep(step);
        }
        this.log.info((Object)("Will start new agent @ [" + this.accessInfo.getHost() + "] pointing to server @ [" + serverAddress + "]"));
        String agentScript = parentPath + "/rhq-agent/bin/rhq-agent.sh";
        String startStringArgs = info.getConfigurationStartString();
        if (installId != null) {
            startStringArgs = startStringArgs + " -Drhq.install.id=" + installId;
        }
        String envCmd1 = "RHQ_AGENT_IN_BACKGROUND='" + parentPath + "/rhq-agent/bin/rhq-agent.pid'";
        String envCmd2 = "export RHQ_AGENT_IN_BACKGROUND";
        String startCommand = envCmd1 + " ; " + envCmd2 + " ; nohup '" + agentScript + "' " + startStringArgs + " &";
        this.executeCommand(startCommand, "Start New Agent", info);
        Boolean pingResults = this.checkAgentConnection(info, 5);
        if (pingResults == null) {
            this.log.warn((Object)("Just installed an agent at [" + info.getAgentAddress() + "] but could not determine its port. No validation check will be made."));
        } else if (!pingResults.booleanValue()) {
            this.log.warn((Object)("Just installed an agent at [" + info.getAgentAddress() + "] but could not ping its port. Something might be bad with the install or it is behind a firewall."));
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean checkAgentConnection(AgentInstallInfo info, int retries) {
        if (info.getAgentPort() > 0) {
            info.setConfirmedAgentConnection(Boolean.valueOf(false));
            for (int attempt = 0; attempt < retries && !info.isConfirmedAgentConnection().booleanValue(); ++attempt) {
                Socket ping = new Socket();
                try {
                    ping.connect(new InetSocketAddress(info.getAgentAddress(), info.getAgentPort()), 5000);
                    info.setConfirmedAgentConnection(Boolean.valueOf(ping.isConnected()));
                    continue;
                }
                catch (Exception e) {
                    info.setConfirmedAgentConnection(Boolean.valueOf(false));
                    continue;
                }
                finally {
                    try {
                        ping.close();
                    }
                    catch (Exception ignore) {}
                }
            }
        } else {
            info.setConfirmedAgentConnection(null);
        }
        return info.isConfirmedAgentConnection();
    }

    public String uninstallAgent(String doomedPath) {
        String theRealDoomedPath = this.findAgentInstallPath(doomedPath);
        if (theRealDoomedPath != null) {
            this.stopAgent(theRealDoomedPath);
            this.executeCommand("rm -f '" + theRealDoomedPath + "/../rhq-agent-update.log'", "Remove old agent update logs");
            this.executeCommand("rm -f " + theRealDoomedPath.replace(" ", "\\ ") + "/../rhq-enterprise-agent*.jar", "Remove old agent update binary jars");
            String results = this.executeCommand("rm -rf '" + theRealDoomedPath + "'", "Uninstall Agent");
            return results;
        }
        this.log.warn((Object)("Asked to uninstall an agent from [" + this.accessInfo.getHost() + ":" + doomedPath + "] but there does not appear to be an agent there. Skipping the attempt to remove any files."));
        return "There does not appear to be an agent installed here: " + this.accessInfo.getHost() + ":" + doomedPath;
    }

    public String startAgent(String agentInstallPath) {
        String agentWrapperScript = this.buildAgentWrapperScriptPath(agentInstallPath);
        return this.executeCommand("'" + agentWrapperScript + "' start", "Agent Start");
    }

    public String stopAgent(String agentInstallPath) {
        String agentWrapperScript = this.buildAgentWrapperScriptPath(agentInstallPath);
        return this.executeCommand("'" + agentWrapperScript + "' stop", "Agent Stop");
    }

    public String agentStatus(String agentInstallPath) {
        String agentWrapperScript = this.buildAgentWrapperScriptPath(agentInstallPath);
        if (!this.agentInstallCheck(agentInstallPath)) {
            return AGENT_STATUS_NOT_INSTALLED;
        }
        return this.executeCommand("'" + agentWrapperScript + "' status", "Agent Status");
    }

    public String findAgentInstallPath(String parentPath) {
        String[] results;
        String findOutput;
        if (parentPath == null || parentPath.trim().length() == 0) {
            String[] possiblePaths;
            for (String possiblePath : possiblePaths = new String[]{"/opt", "/usr/local", "/usr/share", "/rhq", "/home/" + this.getCredentialsToUse().getUsername()}) {
                String path = this.findAgentInstallPath(possiblePath);
                if (path == null) continue;
                return path;
            }
            return null;
        }
        if (parentPath.endsWith("/rhq-agent") || parentPath.endsWith("/rhq-agent/")) {
            parentPath = parentPath.substring(0, parentPath.lastIndexOf("/rhq-agent"));
        }
        try {
            findOutput = this.executeCommand("find '" + parentPath + "' -maxdepth 4 -name rhq-agent -print");
        }
        catch (ExecuteException e) {
            findOutput = e.stdout;
        }
        if (findOutput == null || findOutput.trim().length() == 0) {
            return null;
        }
        for (String result : results = findOutput.split("\n")) {
            if (result.contains("/.java/")) continue;
            return result;
        }
        return null;
    }

    public String[] pathDiscovery(String parentPath) {
        String full = this.executeCommand("ls -1 '" + parentPath + "'", "Path Discovery");
        return full.split("\n");
    }

    private Credentials getCredentialsToUse() {
        String pw;
        String user = this.accessInfo.getUser();
        if ((user == null || user.length() == 0) && this.defaultCredentials != null) {
            user = this.defaultCredentials.getUsername();
        }
        if (((pw = this.accessInfo.getPassword()) == null || pw.length() == 0) && this.defaultCredentials != null) {
            pw = this.defaultCredentials.getPassword();
        }
        Credentials creds = new Credentials(user, pw);
        return creds;
    }

    private String buildAgentWrapperScriptPath(String agentInstallPath) {
        String foundAgentInstall = this.findAgentInstallPath(agentInstallPath);
        if (foundAgentInstall != null) {
            agentInstallPath = foundAgentInstall;
        }
        String agentWrapperScript = agentInstallPath + "/bin/rhq-agent-wrapper.sh";
        return agentWrapperScript;
    }

    private String executeCommand(String command, String description) {
        return this.executeCommand(command, description, new AgentInstallInfo());
    }

    private String executeCommand(String command, String description, AgentInstallInfo info) {
        this.log.info((Object)("Running SSH command [" + description + "]"));
        long start = System.currentTimeMillis();
        String result = null;
        try {
            result = this.executeCommand(command);
            info.addStep(new AgentInstallStep(command, description, 0, result, this.getTimeDiff(start)));
        }
        catch (ExecuteException e) {
            info.addStep(new AgentInstallStep(command, description, e.errorCode, e.getMessage(), this.getTimeDiff(start)));
        }
        this.log.info((Object)("Result of SSH command [" + description + "]: " + result));
        return result;
    }

    private String executeCommand(String command) throws ExecuteException {
        ChannelExec channel = null;
        int exitStatus = -1;
        InputStream is = null;
        InputStream es = null;
        try {
            channel = (ChannelExec)this.session.openChannel("exec");
            channel.setCommand(command);
            is = channel.getInputStream();
            es = channel.getErrStream();
            channel.connect(30000);
            String out = this.read(is, (Channel)channel);
            String err = this.read(es, (Channel)channel);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("SSH command output: " + out));
            }
            if (err.length() > 0) {
                exitStatus = channel.getExitStatus();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("SSH command error [" + exitStatus + "]: " + err));
                }
                if (exitStatus != 0) {
                    throw new ExecuteException(exitStatus, err, out);
                }
                if (out.length() == 0) {
                    String string = err;
                    return string;
                }
            } else {
                exitStatus = 0;
            }
            String string = out;
            return string;
        }
        catch (ExecuteException ee) {
            throw ee;
        }
        catch (Exception e) {
            throw new ExecuteException(exitStatus, e.toString());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
            if (es != null) {
                try {
                    es.close();
                }
                catch (Exception e) {}
            }
            if (channel != null) {
                try {
                    channel.disconnect();
                }
                catch (Exception e) {
                    this.log.error((Object)"Failed to disconnect", (Throwable)e);
                }
            }
        }
    }

    private String read(InputStream is, Channel channel) throws IOException {
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        long endTime = System.currentTimeMillis() + 30000L;
        while (System.currentTimeMillis() < endTime) {
            int count;
            while (is.available() > 0 && (count = is.read(buffer, 0, 4096)) >= 0) {
                bos.write(buffer, 0, count);
            }
            if (channel.isClosed()) {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)("SSH reading exit status=" + channel.getExitStatus()));
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        return bos.toString();
    }

    private long getTimeDiff(long start) {
        return System.currentTimeMillis() - start;
    }

    private static class ExecuteException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        int errorCode;
        String stdout;

        public ExecuteException(int errorCode, String message) {
            super(message);
            this.errorCode = errorCode;
        }

        public ExecuteException(int errorCode, String message, String stdout) {
            super(message);
            this.errorCode = errorCode;
            this.stdout = stdout;
        }
    }

    private class SSHUserInfo
    implements UserInfo {
        private SSHUserInfo() {
        }

        public void showMessage(String msg) {
        }

        public boolean promptYesNo(String ques) {
            if (SSHInstallUtility.this.accessInfo.isHostAuthorized()) {
                return true;
            }
            throw new SSHSecurityException(ques);
        }

        public boolean promptPassword(String arg0) {
            return false;
        }

        public boolean promptPassphrase(String arg0) {
            return false;
        }

        public String getPassword() {
            return null;
        }

        public String getPassphrase() {
            return null;
        }
    }

    static class SSHConfiguration {
        private StrictHostKeyChecking strictHostKeyChecking = StrictHostKeyChecking.ask;
        private String knownHostsFile = null;

        public StrictHostKeyChecking getStrictHostKeyChecking() {
            return this.strictHostKeyChecking;
        }

        public void setStrictHostKeyChecking(StrictHostKeyChecking strictHostKeyChecking) {
            this.strictHostKeyChecking = strictHostKeyChecking;
        }

        public String getKnownHostsFile() {
            return this.knownHostsFile;
        }

        public void setKnownHostsFile(String knownHostsFile) {
            this.knownHostsFile = knownHostsFile;
        }

        public static enum StrictHostKeyChecking {
            yes,
            no,
            ask;

        }
    }

    static class Credentials {
        private String username;
        private String password;

        public Credentials() {
        }

        public Credentials(String username, String password) {
            this.setUsername(username);
            this.setPassword(password);
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String u) {
            this.username = u;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String p) {
            this.password = p;
        }
    }
}

