/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.plugin.pc.AbstractTypeServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.ScheduledJobInvocationContext;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginContext;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.ServerPluginManager;
import org.rhq.enterprise.server.plugin.pc.ServerPluginServiceMBean;
import org.rhq.enterprise.server.plugin.pc.ServerPluginType;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.xmlschema.AbstractScheduleType;
import org.rhq.enterprise.server.xmlschema.ScheduledJobDefinition;
import org.rhq.enterprise.server.xmlschema.ServerPluginDescriptorMetadataParser;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.ServerPluginDescriptorType;

abstract class AbstractJobWrapper
implements Job {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String DATAMAP_LEADER = "__";
    public static final String DATAMAP_PLUGIN_NAME = "__pluginName";
    public static final String DATAMAP_PLUGIN_TYPE = "__pluginType";
    public static final String DATAMAP_JOB_ID = "__jobId";
    public static final String DATAMAP_JOB_CLASS = "__jobClass";
    public static final String DATAMAP_JOB_METHOD_NAME = "__jobMethodName";
    public static final String DATAMAP_SCHEDULE_TYPE = "__scheduleType";
    public static final String DATAMAP_SCHEDULE_TRIGGER = "__scheduleTrigger";
    public static final String DATAMAP_IS_CONCURRENT = "__isConcurrent";
    public static final String DATAMAP_IS_CLUSTERED = "__isClustered";

    AbstractJobWrapper() {
    }

    protected abstract ScheduledJobInvocationContext createContext(ScheduledJobDefinition var1, ServerPluginContext var2, ServerPluginComponent var3, Map<String, String> var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.log.debug((Object)"scheduled server plugin job triggered");
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        String pluginName = dataMap.getString(DATAMAP_PLUGIN_NAME);
        String pluginTypeString = dataMap.getString(DATAMAP_PLUGIN_TYPE);
        String jobId = dataMap.getString(DATAMAP_JOB_ID);
        String jobClass = dataMap.getString(DATAMAP_JOB_CLASS);
        String jobMethodName = dataMap.getString(DATAMAP_JOB_METHOD_NAME);
        boolean isConcurrent = Boolean.parseBoolean(dataMap.getString(DATAMAP_IS_CONCURRENT));
        boolean isClustered = Boolean.parseBoolean(dataMap.getString(DATAMAP_IS_CLUSTERED));
        String scheduleTypeStr = dataMap.getString(DATAMAP_SCHEDULE_TYPE);
        String scheduleTrigger = dataMap.getString(DATAMAP_SCHEDULE_TRIGGER);
        if (pluginName == null) {
            this.throwJobExecutionException(pluginName, pluginTypeString, jobId, "Datamap missing plugin name", null);
        }
        if (pluginTypeString == null) {
            this.throwJobExecutionException(pluginName, pluginTypeString, jobId, "Datamap missing plugin type", null);
        }
        if (jobId == null) {
            this.throwJobExecutionException(pluginName, pluginTypeString, jobId, "Datamap missing job ID", null);
        }
        if (jobMethodName == null) {
            this.throwJobExecutionException(pluginName, pluginTypeString, jobId, "Datamap missing method name", null);
        }
        Properties callbackData = new Properties();
        for (String key : dataMap.getKeys()) {
            if (key.startsWith(DATAMAP_LEADER)) continue;
            callbackData.setProperty(key, dataMap.getString(key));
        }
        ServerPluginType pluginType = null;
        try {
            pluginType = new ServerPluginType(pluginTypeString);
        }
        catch (Throwable t) {
            this.throwJobExecutionException(pluginName, pluginTypeString, jobId, "Datamap had invalid plugin type string", t);
        }
        ServerPluginServiceMBean serverPluginService = LookupUtil.getServerPluginService();
        if (!serverPluginService.isMasterPluginContainerStarted()) {
            String msg = "The master plugin container is shutdown, will not execute job here, will resubmit";
            this.log.error((Object)this.logMsg(pluginName, pluginType, jobId, msg, null));
            JobExecutionException exception = new JobExecutionException();
            boolean isHA = LookupUtil.getTopologyManager().getNormalServerCount() > 1;
            exception.setRefireImmediately(isHA);
            return;
        }
        MasterServerPluginContainer mpc = serverPluginService.getMasterPluginContainer();
        AbstractTypeServerPluginContainer pc = mpc.getPluginContainerByPluginType(pluginType);
        Object pluginJobObject = null;
        ServerPluginManager pluginManager = pc.getPluginManager();
        ServerPluginEnvironment pluginEnv = pluginManager.getPluginEnvironment(pluginName);
        if (pluginEnv == null) {
            this.throwJobExecutionException(pluginName, pluginType, jobId, "missing environment for plugin [" + pluginName + "]", null);
        }
        ServerPluginComponent pluginComponent = pluginManager.getServerPluginComponent(pluginName);
        if (jobClass == null) {
            pluginJobObject = pluginComponent;
            if (pluginJobObject == null) {
                this.throwJobExecutionException(pluginName, pluginType, jobId, "no plugin component to process job", null);
            }
        } else {
            try {
                ServerPluginDescriptorType descriptor = pluginEnv.getPluginDescriptor();
                jobClass = ServerPluginDescriptorMetadataParser.getFullyQualifiedClassName((ServerPluginDescriptorType)descriptor, (String)jobClass);
                pluginJobObject = pluginManager.instantiatePluginClass(pluginEnv, jobClass);
            }
            catch (Throwable t) {
                this.throwJobExecutionException(pluginName, pluginType, jobId, "bad job class [" + jobClass + "]", t);
            }
        }
        Method jobMethod = null;
        Object[] params = null;
        try {
            jobMethod = pluginJobObject.getClass().getMethod(jobMethodName, ScheduledJobInvocationContext.class);
            params = new Object[1];
            AbstractScheduleType scheduleType = AbstractScheduleType.create((boolean)isConcurrent, (boolean)isClustered, (String)scheduleTypeStr, (String)scheduleTrigger);
            if (scheduleType == null) {
                this.log.warn((Object)this.logMsg(pluginName, pluginType, jobId, "ignoring bad schedule type found in data map [" + scheduleTypeStr + "]", null));
            }
            ScheduledJobDefinition jobDefinition = new ScheduledJobDefinition(jobId, true, jobClass, jobMethodName, scheduleType, callbackData);
            ServerPluginContext pluginContext = pluginManager.getServerPluginContext(pluginEnv);
            params[0] = this.createContext(jobDefinition, pluginContext, pluginComponent, (Map<String, String>)dataMap);
        }
        catch (NoSuchMethodException e) {
            try {
                jobMethod = pluginJobObject.getClass().getMethod(jobMethodName, new Class[0]);
                params = null;
            }
            catch (Throwable t) {
                this.throwJobExecutionException(pluginName, pluginType, jobId, "bad schedule job method [" + jobMethodName + "]", t);
            }
        }
        try {
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(pluginEnv.getPluginClassLoader());
                jobMethod.invoke(pluginJobObject, params);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
            this.log.info((Object)this.logMsg(pluginName, pluginType, jobId, "scheduled job executed", null));
        }
        catch (Throwable t) {
            this.throwJobExecutionException(pluginName, pluginType, jobId, "job threw exception, unscheduling it", t);
        }
    }

    protected void throwJobExecutionException(String pluginName, Object pluginType, String jobId, String errorMsg, Throwable t) throws JobExecutionException {
        this.log.error((Object)this.logMsg(pluginName, pluginType, jobId, errorMsg, t));
        JobExecutionException jobException = t != null ? new JobExecutionException(t, false) : new JobExecutionException(false);
        jobException.setUnscheduleFiringTrigger(true);
        throw jobException;
    }

    protected String logMsg(String pluginName, Object pluginType, String jobId, String msg, Throwable t) {
        String s = "Plugin [" + pluginName + "], type=[" + pluginType + "], jobId=[" + jobId + "]: " + msg;
        if (t != null) {
            s = s + ". Cause: " + ThrowableUtil.getAllMessages((Throwable)t);
        }
        return s;
    }
}

