/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.AgentCriteria;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class AgentRequestFullAvailabilityJob
implements Job {
    public static final String AGENTS = "Agents";
    public static final String KEY_TRIGGER_NAME = "TriggerName";
    public static final String KEY_TRIGGER_GROUP_NAME = "TriggerGroupName";
    private final Log log = LogFactory.getLog(AgentRequestFullAvailabilityJob.class);

    public static void externalizeJobValues(JobDataMap jobDataMap, String key, Collection<Agent> agents) {
        if (agents != null && agents.size() > 0) {
            StringBuilder valuesCommaSeparated = new StringBuilder();
            String comma = "";
            for (Agent agent : agents) {
                valuesCommaSeparated.append(comma).append(agent.getId());
                comma = ",";
            }
            jobDataMap.put(key, valuesCommaSeparated.toString());
        }
    }

    public static List<Agent> internalizeJobValues(String valuesCsvList) {
        if (valuesCsvList == null) {
            return Collections.EMPTY_LIST;
        }
        String[] resourceIdStrings = valuesCsvList.split(",");
        Integer[] resourceIds = new Integer[resourceIdStrings.length];
        AgentCriteria c = new AgentCriteria();
        int len = resourceIdStrings.length;
        for (int i = 0; i < len; ++i) {
            resourceIds[i] = Integer.parseInt(resourceIdStrings[i]);
        }
        c.addFilterIds(resourceIds);
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        PageList<Agent> result = LookupUtil.getAgentManager().findAgentsByCriteria(overlord, c);
        return result;
    }

    private void unscheduleJob(JobDataMap jobDataMap) {
        String triggerName = (String)jobDataMap.get((Object)KEY_TRIGGER_NAME);
        String triggerGroupName = (String)jobDataMap.get((Object)KEY_TRIGGER_GROUP_NAME);
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        try {
            scheduler.unscheduleJob(triggerName, triggerGroupName);
        }
        catch (SchedulerException e) {
            this.log.error((Object)("Failed to unschedule Quartz trigger [" + triggerName + "]."), (Throwable)e);
        }
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        this.unscheduleJob(jobDataMap);
        AgentManagerLocal agentManager = LookupUtil.getAgentManager();
        for (Agent agent : AgentRequestFullAvailabilityJob.internalizeJobValues((String)jobDataMap.get((Object)AGENTS))) {
            try {
                AgentClient agentClient = agentManager.getAgentClient(agent);
                agentClient.getDiscoveryAgentService().requestFullAvailabilityReport();
            }
            catch (Throwable t) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Failed to notify Agent [" + agent + "] of enabled resources. The agent is likely down. This is ok, the avails will be updated when the agent is restarted or prompt command 'avail --force is executed'."));
            }
        }
    }
}

