/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.group.definition.mbean;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.LocalBean;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.util.ObjectNameFactory;
import org.rhq.enterprise.server.resource.group.definition.mbean.GroupDefinitionRecalculationThreadMonitorMBean;
import org.rhq.enterprise.server.util.JMXUtil;
import org.rhq.enterprise.server.util.LookupUtil;

@Singleton
@Startup
@LocalBean
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
public class GroupDefinitionRecalculationThreadMonitor
implements GroupDefinitionRecalculationThreadMonitorMBean {
    private static final ObjectName OBJECT_NAME = ObjectNameFactory.create((String)"rhq:service=GroupDefinitionRecalculationThreadMonitor");
    private static AtomicLong lastAutoRecalculationThreadTime = new AtomicLong(0L);
    private static ConcurrentMap<String, GroupDefinitionRecalculationStat> statistics = new ConcurrentHashMap<String, GroupDefinitionRecalculationStat>();
    private static MBeanServer mbeanServer;
    private static ObjectName objectName;
    private static GroupDefinitionRecalculationThreadMonitorMBean proxy;

    public static GroupDefinitionRecalculationThreadMonitorMBean getMBean() {
        if (proxy == null) {
            proxy = objectName != null ? MBeanServerInvocationHandler.newProxyInstance(mbeanServer, objectName, GroupDefinitionRecalculationThreadMonitorMBean.class, false) : new GroupDefinitionRecalculationThreadMonitor();
        }
        return proxy;
    }

    public void clear() {
        statistics.clear();
    }

    public long getGroupDefinitionCount() {
        return LookupUtil.getGroupDefinitionManager().getGroupDefinitionCount(this.getOverlord());
    }

    public long getAutoRecalculatingGroupDefinitionCount() {
        return LookupUtil.getGroupDefinitionManager().getAutoRecalculationGroupDefinitionCount(this.getOverlord());
    }

    public long getDynaGroupCount() {
        return LookupUtil.getGroupDefinitionManager().getDynaGroupCount(this.getOverlord());
    }

    private Subject getOverlord() {
        return LookupUtil.getSubjectManager().getOverlord();
    }

    public long getAutoRecalculationThreadTime() {
        return lastAutoRecalculationThreadTime.get();
    }

    public void updateAutoRecalculationThreadTime(long timeInMillis) {
        lastAutoRecalculationThreadTime.set(timeInMillis);
    }

    public void updateStatistic(String groupDefinitionName, int newDynaGroupCount, boolean success, long executionTime) {
        statistics.putIfAbsent(groupDefinitionName, new GroupDefinitionRecalculationStat());
        GroupDefinitionRecalculationStat stat = (GroupDefinitionRecalculationStat)statistics.get(groupDefinitionName);
        stat.update(newDynaGroupCount, success, executionTime);
    }

    public Map<String, Map<String, Object>> getStatistics() {
        HashMap<String, Map<String, Object>> results = new HashMap<String, Map<String, Object>>();
        for (Map.Entry stat : statistics.entrySet()) {
            String groupDefinitionName = (String)stat.getKey();
            Map<String, Object> groupDefinitionStatistics = ((GroupDefinitionRecalculationStat)stat.getValue()).getStatistics();
            results.put(groupDefinitionName, groupDefinitionStatistics);
        }
        return results;
    }

    @PostConstruct
    private void init() {
        JMXUtil.registerMBean(this, OBJECT_NAME);
        mbeanServer = JMXUtil.getPlatformMBeanServer();
        objectName = OBJECT_NAME;
    }

    @PreDestroy
    private void destroy() {
        mbeanServer = null;
        objectName = null;
        JMXUtil.unregisterMBeanQuietly(OBJECT_NAME);
    }

    public class GroupDefinitionRecalculationStat {
        private long dynaGroupCount;
        private long recalculationCount;
        private long successfulCount;
        private long minExecutionTime;
        private long maxExecutionTime;
        private long totalEexecutionTime;

        public synchronized void update(int newDynaGroupCount, boolean success, long executionTime) {
            this.dynaGroupCount = newDynaGroupCount;
            if (success) {
                ++this.successfulCount;
            }
            ++this.recalculationCount;
            if (executionTime < this.minExecutionTime) {
                this.minExecutionTime = executionTime;
            } else if (executionTime > this.maxExecutionTime) {
                this.maxExecutionTime = executionTime;
            }
            this.totalEexecutionTime += executionTime;
        }

        public synchronized Map<String, Object> getStatistics() {
            HashMap<String, Object> stats = new HashMap<String, Object>();
            stats.put("dynaGroupCount", this.dynaGroupCount);
            stats.put("recalculationCount", this.recalculationCount);
            stats.put("successfulCount", this.successfulCount);
            stats.put("failureCount", this.recalculationCount - this.successfulCount);
            stats.put("minExecutionTime", this.minExecutionTime);
            stats.put("maxExecutionTime", this.maxExecutionTime);
            stats.put("avgEexecutionTime", (double)this.totalEexecutionTime / (double)this.recalculationCount);
            return stats;
        }
    }
}

