/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler.jobs;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.AlertConditionOperator;
import org.rhq.core.domain.criteria.AvailabilityCriteria;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheStats;
import org.rhq.enterprise.server.alert.engine.model.AvailabilityDurationComposite;
import org.rhq.enterprise.server.util.LookupUtil;

public class AlertAvailabilityDurationJob {
    private static final Log LOG = LogFactory.getLog(AlertAvailabilityDurationJob.class);
    public static final String DATAMAP_CONDITION_ID = "alertConditionId";
    public static final String DATAMAP_DURATION = "duration";
    public static final String DATAMAP_OPERATOR = "alertConditionOperator";
    public static final String DATAMAP_RESOURCE_ID = "resourceId";

    public static void execute(Map<String, String> infoMap) throws Exception {
        int conditionId = Integer.valueOf(infoMap.get(DATAMAP_CONDITION_ID));
        int resourceId = Integer.valueOf(infoMap.get(DATAMAP_RESOURCE_ID));
        long duration = Long.valueOf(infoMap.get(DATAMAP_DURATION));
        AlertConditionOperator operator = AlertConditionOperator.valueOf((String)infoMap.get(DATAMAP_OPERATOR));
        AvailabilityCriteria criteria = new AvailabilityCriteria();
        criteria.addFilterResourceId(Integer.valueOf(resourceId));
        long durationEnd = System.currentTimeMillis();
        Long durationStart = durationEnd - duration * 1000L;
        criteria.addFilterInterval(durationStart, Long.valueOf(durationEnd));
        criteria.addSortStartTime(PageOrdering.ASC);
        PageList<Availability> avails = LookupUtil.getAvailabilityManager().findAvailabilityByCriteria(LookupUtil.getSubjectManager().getOverlord(), criteria);
        if (avails.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("AlertAvailabilityDurationJob: No alert. Assuming resource has been uninventoried [" + resourceId + "]"));
            }
            return;
        }
        if (avails.size() > 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("AlertAvailabilityDurationJob: No alert. Resource avail for [" + resourceId + "] has fluctuated. " + avails));
            }
            return;
        }
        Availability avail = (Availability)avails.get(0);
        AvailabilityType availType = avail.getAvailabilityType();
        boolean checkConditions = false;
        switch (operator) {
            case AVAIL_DURATION_DOWN: {
                checkConditions = AvailabilityType.DOWN == availType;
                break;
            }
            case AVAIL_DURATION_NOT_UP: {
                checkConditions = AvailabilityType.UP != availType;
                break;
            }
            default: {
                LOG.error((Object)("AlertAvailabilityDurationJob: unexpected operator [" + operator.name() + "]"));
            }
        }
        if (checkConditions) {
            AvailabilityDurationComposite composite = new AvailabilityDurationComposite(conditionId, operator, resourceId, availType, duration);
            AlertConditionCacheStats stats = LookupUtil.getAlertConditionCacheManager().checkConditions(composite);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("AlertAvailabilityDurationJob: " + stats.toString()));
            }
        } else {
            LOG.warn((Object)("AlertAvailabilityDurationJob: unexpected availability for resource [" + resourceId + "]. " + avail));
        }
    }
}

