/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler.jobs;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.plugin.ServerPlugin;
import org.rhq.enterprise.server.plugin.ServerPluginsLocal;
import org.rhq.enterprise.server.resource.metadata.PluginManagerLocal;
import org.rhq.enterprise.server.scheduler.jobs.AbstractStatefulJob;
import org.rhq.enterprise.server.util.LookupUtil;

public class PurgePluginsJob
extends AbstractStatefulJob {
    private static final Log LOG = LogFactory.getLog(PurgePluginsJob.class);

    @Override
    public void executeJobCode(JobExecutionContext context) throws JobExecutionException {
        this.purgeAgentPlugins();
        this.purgeServerPlugins();
    }

    private void purgeAgentPlugins() {
        PluginManagerLocal pluginMgr = LookupUtil.getPluginManager();
        List<Plugin> plugins = pluginMgr.findAllDeletedPlugins();
        ArrayList<Plugin> pluginsToPurge = new ArrayList<Plugin>();
        for (Plugin plugin : plugins) {
            if (!pluginMgr.isReadyForPurge(plugin)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Preparing to purge plugin [" + plugin.getName() + "]"));
            }
            pluginsToPurge.add(plugin);
        }
        if (!pluginsToPurge.isEmpty()) {
            pluginMgr.purgePlugins(pluginsToPurge);
        }
    }

    private void purgeServerPlugins() {
        ServerPluginsLocal pluginMgr = LookupUtil.getServerPlugins();
        for (ServerPlugin p : pluginMgr.getDeletedPlugins()) {
            if (!pluginMgr.isReadyForPurge(p.getId())) continue;
            pluginMgr.purgeServerPlugin(p.getId());
        }
    }
}

