/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MessageDigestGenerator {
    public static final String MD5 = "MD5";
    public static final String SHA_256 = "SHA-256";
    private final MessageDigest messageDigest;

    public MessageDigestGenerator() {
        this(MD5);
    }

    public MessageDigestGenerator(String algorithm) {
        try {
            this.messageDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(algorithm + " is not a supported algorithm");
        }
    }

    public MessageDigest getMessageDigest() {
        return this.messageDigest;
    }

    public void add(InputStream is) throws IOException {
        int len;
        byte[] bytes = new byte[1024];
        while ((len = is.read(bytes, 0, bytes.length)) != -1) {
            this.messageDigest.update(bytes, 0, len);
        }
    }

    public void add(byte[] bytes) {
        if (bytes != null) {
            this.messageDigest.update(bytes);
        }
    }

    public void add(byte[] bytes, int offset, int length) {
        if (bytes != null) {
            this.messageDigest.update(bytes, offset, length);
        }
    }

    public byte[] getDigest() {
        return this.messageDigest.digest();
    }

    public String getDigestString() {
        return MessageDigestGenerator.calculateDigestStringFromBytes(this.getDigest());
    }

    public static byte[] getDigest(InputStream is) throws IOException {
        MessageDigestGenerator md5 = new MessageDigestGenerator(MD5);
        return md5.calcDigest(is);
    }

    public byte[] calcDigest(InputStream is) throws IOException {
        this.add(is);
        return this.getDigest();
    }

    public static String getDigestString(InputStream is) throws IOException {
        MessageDigestGenerator md5 = new MessageDigestGenerator(MD5);
        return md5.calcDigestString(is);
    }

    public String calcDigestString(InputStream is) throws IOException {
        this.add(is);
        return this.getDigestString();
    }

    public static byte[] getDigest(String source_str) {
        MessageDigestGenerator md5 = new MessageDigestGenerator(MD5);
        return md5.calcDigest(source_str);
    }

    public byte[] calcDigest(String source_str) {
        try {
            ByteArrayInputStream bs = new ByteArrayInputStream(source_str.getBytes());
            return this.calcDigest(bs);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException reading a byte array input stream, this should never happen", e);
        }
    }

    public static String getDigestString(String source_str) {
        MessageDigestGenerator md5 = new MessageDigestGenerator(MD5);
        return md5.calcDigestString(source_str);
    }

    public String calcDigestString(String source_str) {
        return MessageDigestGenerator.calculateDigestStringFromBytes(this.calcDigest(source_str));
    }

    public static byte[] getDigest(File file) throws IOException {
        MessageDigestGenerator md5 = new MessageDigestGenerator(MD5);
        return md5.calcDigest(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] calcDigest(File file) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            byte[] byArray = this.calcDigest(new BufferedInputStream(is, 32768));
            return byArray;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] calcDigest(URL url) throws IOException {
        InputStream is = null;
        try {
            is = url.openStream();
            byte[] byArray = this.calcDigest(new BufferedInputStream(is, 32768));
            return byArray;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public static String getDigestString(File file) throws IOException {
        MessageDigestGenerator md5 = new MessageDigestGenerator(MD5);
        return md5.calcDigestString(file);
    }

    public String calcDigestString(File file) throws IOException {
        return MessageDigestGenerator.calculateDigestStringFromBytes(this.calcDigest(file));
    }

    public String calcDigestString(byte[] bytes) throws IOException {
        try {
            ByteArrayInputStream bs = new ByteArrayInputStream(bytes);
            return this.calcDigestString(bs);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException reading a byte array input stream, this should never happen", e);
        }
    }

    public static String getDigestString(URL url) throws IOException {
        MessageDigestGenerator md5 = new MessageDigestGenerator(MD5);
        return md5.calcDigestString(url);
    }

    public String calcDigestString(URL url) throws IOException {
        return MessageDigestGenerator.calculateDigestStringFromBytes(this.calcDigest(url));
    }

    private static String calculateDigestStringFromBytes(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            int hi = bytes[i] >> 4 & 0xF;
            int lo = bytes[i] & 0xF;
            sb.append(Character.forDigit(hi, 16));
            sb.append(Character.forDigit(lo, 16));
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        String file = args[0];
        String digest = MessageDigestGenerator.getDigestString(new File(file));
        System.out.println("MD5=" + digest);
        digest = new MessageDigestGenerator(SHA_256).calcDigestString(new File(file));
        System.out.println("SHA-256=" + digest);
    }
}

