/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine.model;

import org.rhq.core.domain.alert.AlertConditionOperator;
import org.rhq.enterprise.server.alert.engine.model.AbstractCacheElement;
import org.rhq.enterprise.server.alert.engine.model.UnsupportedAlertConditionOperatorException;

public abstract class NumericDoubleCacheElement
extends AbstractCacheElement<Double> {
    public NumericDoubleCacheElement(AlertConditionOperator operator, Double value, int conditionTriggerId) {
        super(operator, value, conditionTriggerId);
    }

    @Override
    public boolean matches(Double providedValue, Object ... extraParams) {
        if (this.alertConditionValue == null || ((Double)this.alertConditionValue).isNaN() || ((Double)this.alertConditionValue).isInfinite()) {
            return false;
        }
        if (providedValue == null || providedValue.isNaN() || providedValue.isInfinite()) {
            return false;
        }
        if (this.alertConditionOperator == AlertConditionOperator.GREATER_THAN) {
            return providedValue.compareTo((Double)this.alertConditionValue) > 0;
        }
        if (this.alertConditionOperator == AlertConditionOperator.LESS_THAN) {
            return providedValue.compareTo((Double)this.alertConditionValue) < 0;
        }
        if (this.alertConditionOperator == AlertConditionOperator.EQUALS) {
            return providedValue.compareTo((Double)this.alertConditionValue) == 0;
        }
        if (this.alertConditionOperator == AlertConditionOperator.CHANGES) {
            boolean result = ((Double)this.alertConditionValue).compareTo(providedValue) != 0;
            this.alertConditionValue = providedValue;
            return result;
        }
        throw new UnsupportedAlertConditionOperatorException(this.getClass().getSimpleName() + " does not yet support " + this.alertConditionOperator);
    }

    @Override
    public AlertConditionOperator.Type getOperatorSupportsType(AlertConditionOperator operator) {
        if (operator == AlertConditionOperator.GREATER_THAN || operator == AlertConditionOperator.EQUALS || operator == AlertConditionOperator.LESS_THAN || operator == AlertConditionOperator.CHANGES) {
            return operator.getDefaultType();
        }
        return AlertConditionOperator.Type.NONE;
    }
}

