/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.LocalBean;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.as.controller.client.ModelControllerClient;
import org.rhq.common.jbossas.client.controller.MCCHelper;
import org.rhq.common.jbossas.client.controller.SecurityDomainJBossASClient;
import org.rhq.core.domain.common.composite.SystemSetting;
import org.rhq.core.util.obfuscation.Obfuscator;
import org.rhq.enterprise.server.RHQConstants;
import org.rhq.enterprise.server.core.CustomJaasDeploymentServiceMBean;
import org.rhq.enterprise.server.core.jaas.JDBCLoginModule;
import org.rhq.enterprise.server.core.jaas.JDBCPrincipalCheckLoginModule;
import org.rhq.enterprise.server.core.jaas.LdapLoginModule;
import org.rhq.enterprise.server.core.service.ManagementService;
import org.rhq.enterprise.server.util.JMXUtil;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.security.UntrustedSSLSocketFactory;

@Singleton
@Startup
@LocalBean
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
public class CustomJaasDeploymentService
implements CustomJaasDeploymentServiceMBean {
    private static final Log LOG = LogFactory.getLog((String)CustomJaasDeploymentService.class.getName());

    public void installJaasModules() {
        try {
            LOG.info((Object)"Updating RHQ Server's JAAS login modules");
            Properties systemConfig = LookupUtil.getSystemManager().getSystemConfiguration(LookupUtil.getSubjectManager().getOverlord());
            this.updateJaasModules(systemConfig);
        }
        catch (Exception e) {
            LOG.fatal((Object)"Error deploying JAAS login modules", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradeRhqUserSecurityDomainIfNeeded() {
        block6: {
            try {
                boolean isLdapAuthenticationEnabled;
                Properties systemConfig = LookupUtil.getSystemManager().getSystemConfiguration(LookupUtil.getSubjectManager().getOverlord());
                String value = systemConfig.getProperty(SystemSetting.LDAP_BASED_JAAS_PROVIDER.getInternalName());
                boolean bl = isLdapAuthenticationEnabled = value != null ? "LDAP".equals(value) : false;
                if (!isLdapAuthenticationEnabled) break block6;
                ModelControllerClient mcc = null;
                try {
                    mcc = ManagementService.createClient();
                    SecurityDomainJBossASClient client = new SecurityDomainJBossASClient(mcc);
                    boolean ldapModulesPresent = client.securityDomainHasLoginModule("RHQUserSecurityDomain", "org.rhq.enterprise.server.core.jaas.LdapLoginModule");
                    if (!ldapModulesPresent) {
                        LOG.info((Object)"Updating RHQ Server's JAAS login modules with LDAP support");
                        this.updateJaasModules(systemConfig);
                    }
                }
                finally {
                    MCCHelper.safeClose((ModelControllerClient)mcc);
                }
            }
            catch (Exception e) {
                LOG.fatal((Object)"Error deploying JAAS login modules", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    @PostConstruct
    private void init() {
        JMXUtil.registerMBean(this, OBJECT_NAME);
    }

    @PreDestroy
    private void destroy() {
        JMXUtil.unregisterMBeanQuietly(OBJECT_NAME);
    }

    private void updateJaasModules(Properties systemConfig) throws Exception {
        ModelControllerClient mcc = null;
        try {
            boolean isLdapAuthenticationEnabled;
            mcc = ManagementService.createClient();
            SecurityDomainJBossASClient client = new SecurityDomainJBossASClient(mcc);
            if (client.isSecurityDomain("RHQUserSecurityDomain")) {
                LOG.info((Object)"Security domain [RHQUserSecurityDomain] already exists, it will be replaced.");
            }
            ArrayList<SecurityDomainJBossASClient.LoginModuleRequest> loginModules = new ArrayList<SecurityDomainJBossASClient.LoginModuleRequest>(3);
            SecurityDomainJBossASClient.LoginModuleRequest jdbcLoginModule = new SecurityDomainJBossASClient.LoginModuleRequest(JDBCLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT, this.getJdbcOptions(systemConfig));
            loginModules.add(jdbcLoginModule);
            String value = systemConfig.getProperty(SystemSetting.LDAP_BASED_JAAS_PROVIDER.getInternalName());
            boolean bl = isLdapAuthenticationEnabled = value != null ? "LDAP".equals(value) : false;
            if (isLdapAuthenticationEnabled) {
                SecurityDomainJBossASClient.LoginModuleRequest jdbcPrincipalCheckLoginModule = new SecurityDomainJBossASClient.LoginModuleRequest(JDBCPrincipalCheckLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUISITE, this.getJdbcOptions(systemConfig));
                loginModules.add(jdbcPrincipalCheckLoginModule);
                Map<String, String> ldapModuleOptionProperties = this.getLdapOptions(systemConfig);
                try {
                    this.validateLdapOptions(ldapModuleOptionProperties);
                }
                catch (NamingException e) {
                    String descriptiveMessage = null;
                    descriptiveMessage = e instanceof AuthenticationException ? "The LDAP integration cannot function because the LDAP Bind credentials for RHQ integration are incorrect. Contact the Administrator:" + e : "Problems encountered when communicating with LDAP server. Contact the Administrator:" + e;
                    LOG.error((Object)descriptiveMessage, (Throwable)e);
                }
                SecurityDomainJBossASClient.LoginModuleRequest ldapLoginModule = new SecurityDomainJBossASClient.LoginModuleRequest(LdapLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUISITE, ldapModuleOptionProperties);
                loginModules.add(ldapLoginModule);
            }
            client.createNewSecurityDomain("RHQUserSecurityDomain", loginModules.toArray(new SecurityDomainJBossASClient.LoginModuleRequest[loginModules.size()]));
            client.flushSecurityDomainCache("RHQRESTSecurityDomain");
            LOG.info((Object)("Security domain [RHQUserSecurityDomain] re-created with login modules " + loginModules));
        }
        catch (Exception e) {
            throw new Exception("Error registering RHQ JAAS modules", e);
        }
        finally {
            MCCHelper.safeClose((ModelControllerClient)mcc);
        }
    }

    private Map<String, String> getJdbcOptions(Properties conf) {
        HashMap<String, String> configOptions = new HashMap<String, String>();
        configOptions.put("hashAlgorithm", "MD5");
        configOptions.put("hashEncoding", "base64");
        return configOptions;
    }

    private Map<String, String> getLdapOptions(Properties conf) throws Exception {
        HashMap<String, String> configOptions = new HashMap<String, String>();
        configOptions.put("java.naming.factory.initial", conf.getProperty(RHQConstants.LDAPFactory));
        configOptions.put("java.naming.provider.url", conf.getProperty(RHQConstants.LDAPUrl));
        String value = conf.getProperty(SystemSetting.USE_SSL_FOR_LDAP.getInternalName());
        boolean ldapSsl = "ssl".equalsIgnoreCase(value);
        configOptions.put("java.naming.security.protocol", ldapSsl ? "ssl" : null);
        configOptions.put("LoginProperty", conf.getProperty(RHQConstants.LDAPLoginProperty));
        configOptions.put("Filter", conf.getProperty(RHQConstants.LDAPFilter));
        configOptions.put("GroupFilter", conf.getProperty(RHQConstants.LDAPGroupFilter));
        configOptions.put("GroupMemberFilter", conf.getProperty(RHQConstants.LDAPGroupMember));
        configOptions.put("BaseDN", conf.getProperty(RHQConstants.LDAPBaseDN));
        configOptions.put("BindDN", conf.getProperty(RHQConstants.LDAPBindDN));
        configOptions.put("BindPW", Obfuscator.encode((String)conf.getProperty(RHQConstants.LDAPBindPW)));
        boolean followReferralsBoolean = Boolean.valueOf(conf.getProperty(SystemSetting.LDAP_FOLLOW_REFERRALS.getInternalName(), "false"));
        configOptions.put("java.naming.referral", followReferralsBoolean ? "follow" : "ignore");
        return configOptions;
    }

    private void validateLdapOptions(Map<String, String> options) throws NamingException {
        Properties env = new Properties();
        String factory = options.get("java.naming.factory.initial");
        if (factory == null) {
            throw new NamingException("No initial context factory");
        }
        String url = options.get("java.naming.provider.url");
        if (url == null) {
            throw new NamingException("Naming provider url not set");
        }
        String protocol = options.get("java.naming.security.protocol");
        if ("ssl".equals(protocol)) {
            String ldapSocketFactory = env.getProperty("java.naming.ldap.factory.socket");
            if (ldapSocketFactory == null) {
                env.put("java.naming.ldap.factory.socket", UntrustedSSLSocketFactory.class.getName());
            }
            env.put("java.naming.security.protocol", "ssl");
        }
        env.setProperty("java.naming.factory.initial", factory);
        env.setProperty("java.naming.provider.url", url);
        String bindDN = options.get("BindDN");
        String bindPW = options.get("BindPW");
        try {
            bindPW = Obfuscator.decode((String)bindPW);
        }
        catch (Exception e) {
            LOG.debug((Object)("Failed to decode bindPW, binding using undecoded value [" + bindPW + "]"), (Throwable)e);
        }
        if (bindDN != null && bindDN.length() != 0 && bindPW != null && bindPW.length() != 0) {
            env.setProperty("java.naming.security.principal", bindDN);
            env.setProperty("java.naming.security.credentials", bindPW);
            env.setProperty("java.naming.security.authentication", "simple");
        }
        LOG.debug((Object)"Validating LDAP properties. Initializing context...");
        new InitialLdapContext(env, null).close();
    }
}

