/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.discovery;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.discovery.DiscoveryBossLocal;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class AgentInventoryStatusUpdateJob
implements Job {
    public static final String PLATFORMS_COMMA_LIST = "PlatformsList";
    public static final String SERVERS_COMMA_LIST = "ServersList";
    public static final String KEY_TRIGGER_NAME = "TriggerName";
    public static final String KEY_TRIGGER_GROUP_NAME = "TriggerGroupName";
    private final Log log = LogFactory.getLog(AgentInventoryStatusUpdateJob.class);

    public static void externalizeJobValues(JobDataMap jobDataMap, String key, List<Resource> resources) {
        if (resources != null && resources.size() > 0) {
            StringBuilder valuesCommaSeparated = new StringBuilder();
            valuesCommaSeparated.append(resources.get(0).getId());
            for (int i = 1; i < resources.size(); ++i) {
                valuesCommaSeparated.append(",").append(resources.get(i).getId());
            }
            jobDataMap.put(key, valuesCommaSeparated.toString());
        }
    }

    public static void internalizeJobValues(EntityManager entityManager, String valuesCsvList, List<Resource> resources) {
        String[] resourceIdStrings;
        if (valuesCsvList == null) {
            return;
        }
        for (String resourceIdString : resourceIdStrings = valuesCsvList.split(",")) {
            int resourceId = Integer.parseInt(resourceIdString);
            resources.add((Resource)entityManager.find(Resource.class, (Object)resourceId));
        }
    }

    private void unscheduleJob(JobDataMap jobDataMap) {
        String triggerName = (String)jobDataMap.get((Object)KEY_TRIGGER_NAME);
        String triggerGroupName = (String)jobDataMap.get((Object)KEY_TRIGGER_GROUP_NAME);
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        try {
            scheduler.unscheduleJob(triggerName, triggerGroupName);
        }
        catch (SchedulerException e) {
            this.log.error((Object)("Failed to unschedule Quartz trigger [" + triggerName + "]."), (Throwable)e);
        }
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        this.unscheduleJob(jobDataMap);
        DiscoveryBossLocal discoveryBoss = LookupUtil.getDiscoveryBoss();
        discoveryBoss.updateAgentInventoryStatus((String)jobDataMap.get((Object)PLATFORMS_COMMA_LIST), (String)jobDataMap.get((Object)SERVERS_COMMA_LIST));
    }
}

