/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement.instrumentation;

import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.rhq.core.util.ObjectNameFactory;
import org.rhq.enterprise.server.measurement.instrumentation.MeasurementMonitorMBean;
import org.rhq.enterprise.server.storage.StorageClientManager;
import org.rhq.enterprise.server.util.JMXUtil;
import org.rhq.enterprise.server.util.LookupUtil;

@Singleton
@Startup
@LocalBean
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
public class MeasurementMonitor
implements MeasurementMonitorMBean {
    private static final ObjectName OBJECT_NAME = ObjectNameFactory.create((String)"rhq:service=MeasurementMonitor");
    @EJB
    private StorageClientManager storageClientManager;
    private AtomicLong measurementInsertTime = new AtomicLong();
    private AtomicLong measurementsInserted = new AtomicLong();
    private AtomicLong callTimeInsertTime = new AtomicLong();
    private AtomicLong calltimeValuesInserted = new AtomicLong();
    private AtomicLong availabilityInsertTime = new AtomicLong();
    private AtomicLong availabilitiesInserted = new AtomicLong();
    private AtomicLong changesOnlyAvailabilityReports = new AtomicLong();
    private AtomicLong fullAvailabilityReports = new AtomicLong();
    private AtomicLong purgeTime = new AtomicLong();
    private AtomicLong baselineCalculationTime = new AtomicLong();
    private AtomicLong purgedAlerts = new AtomicLong();
    private AtomicLong purgedAlertConditions = new AtomicLong();
    private AtomicLong purgedAlertNotifications = new AtomicLong();
    private AtomicLong purgedAvailabilities = new AtomicLong();
    private AtomicLong purgedCallTimeData = new AtomicLong();
    private AtomicLong purgedEvents = new AtomicLong();
    private AtomicLong purgedMeasurementTraits = new AtomicLong();
    private static MBeanServer mbeanServer;
    private static ObjectName objectName;
    private static MeasurementMonitorMBean proxy;

    public static MeasurementMonitorMBean getMBean() {
        if (proxy == null) {
            proxy = objectName != null ? MBeanServerInvocationHandler.newProxyInstance(mbeanServer, objectName, MeasurementMonitorMBean.class, false) : new MeasurementMonitor();
        }
        return proxy;
    }

    public long getMeasurementInsertTime() {
        return this.measurementInsertTime.get();
    }

    public void incrementMeasurementInsertTime(long delta) {
        this.measurementInsertTime.addAndGet(delta);
    }

    public long getMeasurementsInserted() {
        return this.measurementsInserted.get();
    }

    public void incrementMeasurementsInserted(long delta) {
        this.measurementsInserted.addAndGet(delta);
    }

    public long getCalltimeValuesInserted() {
        return this.calltimeValuesInserted.get();
    }

    public void incrementCalltimeValuesInserted(long delta) {
        this.calltimeValuesInserted.addAndGet(delta);
    }

    public long getCallTimeInsertTime() {
        return this.callTimeInsertTime.get();
    }

    public void incrementCallTimeInsertTime(long delta) {
        this.callTimeInsertTime.addAndGet(delta);
    }

    public long getAvailabilityInsertTime() {
        return this.availabilityInsertTime.get();
    }

    public void incrementAvailabilityInsertTime(long delta) {
        this.availabilityInsertTime.addAndGet(delta);
    }

    public long getAvailabilitiesInserted() {
        return this.availabilitiesInserted.get();
    }

    public void incrementAvailabilitiesInserted(long delta) {
        this.availabilitiesInserted.addAndGet(delta);
    }

    public long getChangesOnlyAvailabilityReports() {
        return this.changesOnlyAvailabilityReports.get();
    }

    public long getFullAvailabilityReports() {
        return this.fullAvailabilityReports.get();
    }

    public long getTotalAvailabilityReports() {
        return this.getChangesOnlyAvailabilityReports() + this.getFullAvailabilityReports();
    }

    public void incrementAvailabilityReports(boolean changesOnlyReport) {
        if (changesOnlyReport) {
            this.changesOnlyAvailabilityReports.incrementAndGet();
        } else {
            this.fullAvailabilityReports.incrementAndGet();
        }
    }

    public int getScheduledMeasurementsPerMinute() {
        return LookupUtil.getMeasurementScheduleManager().getScheduledMeasurementsPerMinute();
    }

    public long getMeasurementCompressionTime() {
        return this.storageClientManager.getMetricsServer().getTotalAggregationTime();
    }

    public long getPurgeTime() {
        return this.purgeTime.get();
    }

    public void incrementPurgeTime(long delta) {
        this.purgeTime.addAndGet(delta);
    }

    public long getBaselineCalculationTime() {
        return this.baselineCalculationTime.get();
    }

    public void incrementBaselineCalculationTime(long delta) {
        this.baselineCalculationTime.addAndGet(delta);
    }

    public long getPurgedAlerts() {
        return this.purgedAlerts.get();
    }

    public void setPurgedAlerts(long delta) {
        this.purgedAlerts.set(delta);
    }

    public long getPurgedAlertConditions() {
        return this.purgedAlertConditions.get();
    }

    public void setPurgedAlertConditions(long delta) {
        this.purgedAlertConditions.set(delta);
    }

    public long getPurgedAlertNotifications() {
        return this.purgedAlertNotifications.get();
    }

    public void setPurgedAlertNotifications(long delta) {
        this.purgedAlertNotifications.set(delta);
    }

    public long getPurgedAvailabilities() {
        return this.purgedAvailabilities.get();
    }

    public void setPurgedAvailabilities(long delta) {
        this.purgedAvailabilities.set(delta);
    }

    public long getPurgedCallTimeData() {
        return this.purgedCallTimeData.get();
    }

    public void setPurgedCallTimeData(long delta) {
        this.purgedCallTimeData.set(delta);
    }

    public long getPurgedEvents() {
        return this.purgedEvents.get();
    }

    public void setPurgedEvents(long delta) {
        this.purgedEvents.set(delta);
    }

    public long getPurgedMeasurementTraits() {
        return this.purgedMeasurementTraits.get();
    }

    public void setPurgedMeasurementTraits(long delta) {
        this.purgedMeasurementTraits.set(delta);
    }

    public int getAggregationBatchSize() {
        return this.storageClientManager.getMetricsServer().getAggregationBatchSize();
    }

    public void setAggregationBatchSize(int size) {
        this.storageClientManager.setAggregationBatchSize(size);
    }

    public int getAggregationParallelism() {
        return this.storageClientManager.getAggregationParallelism();
    }

    public void setAggregationParallelism(int parallelism) {
        this.storageClientManager.setAggregationParallelism(parallelism);
    }

    public int getAggregationWorkers() {
        return this.storageClientManager.getAggregationWorkers();
    }

    public void setAggregationWorkers(int numWorkers) {
        this.storageClientManager.setAggregationWorkers(numWorkers);
    }

    public int getRawDataAgeLimit() {
        return this.storageClientManager.getRawDataAgeLimit();
    }

    public void setRawDataAgeLimit(int ageLimit) {
        this.storageClientManager.setRawDataAgeLimit(ageLimit);
    }

    @PostConstruct
    private void init() {
        JMXUtil.registerMBean(this, OBJECT_NAME);
        mbeanServer = JMXUtil.getPlatformMBeanServer();
        objectName = OBJECT_NAME;
    }

    @PreDestroy
    private void destroy() {
        mbeanServer = null;
        objectName = null;
        JMXUtil.unregisterMBeanQuietly(OBJECT_NAME);
    }
}

