/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.content.metadata;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.metadata.ConfigurationMetadataParser;
import org.rhq.core.clientapi.descriptor.configuration.ConfigurationDescriptor;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.content.ContentSourceType;
import org.rhq.core.domain.content.DownloadMode;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.content.ContentPluginDescriptorType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.content.ContentSourceTypeDefinition;

public class ContentSourcePluginMetadataManager {
    private Log log = LogFactory.getLog(ContentSourcePluginMetadataManager.class);
    private Map<String, Map<String, ContentSourceType>> loadedPlugins = new HashMap<String, Map<String, ContentSourceType>>();

    public synchronized void unloadPlugin(String pluginName) {
        this.loadedPlugins.remove(pluginName);
    }

    public synchronized Collection<ContentSourceType> loadPlugin(ContentPluginDescriptorType pluginDescriptor) {
        try {
            Map<String, ContentSourceType> pluginTypes = this.loadedPlugins.get(pluginDescriptor.getName());
            if (pluginTypes != null) {
                pluginTypes.clear();
            } else {
                pluginTypes = new HashMap<String, ContentSourceType>();
                this.loadedPlugins.put(pluginDescriptor.getName(), pluginTypes);
            }
            for (ContentSourceTypeDefinition newType : pluginDescriptor.getContentSourceType()) {
                if (this.getContentSourceType(newType.getName()) == null) {
                    ContentSourceType contentSourceType = new ContentSourceType();
                    contentSourceType.setName(newType.getName());
                    contentSourceType.setDisplayName(newType.getDisplayName());
                    contentSourceType.setDescription(newType.getDescription());
                    contentSourceType.setPluginName(pluginDescriptor.getName());
                    contentSourceType.setDefaultLazyLoad(newType.isLazyLoad());
                    contentSourceType.setDefaultDownloadMode(DownloadMode.valueOf((String)newType.getDownloadMode().toUpperCase()));
                    contentSourceType.setDefaultSyncSchedule(newType.getSyncSchedule());
                    contentSourceType.setContentSourceApiClass(newType.getApiClass());
                    ConfigurationDefinition configDef = ConfigurationMetadataParser.parse((String)newType.getName(), (ConfigurationDescriptor)newType.getConfiguration());
                    contentSourceType.setContentSourceConfigurationDefinition(configDef);
                    pluginTypes.put(contentSourceType.getName(), contentSourceType);
                    continue;
                }
                throw new Exception("Cannot redefine an existing content source type:" + newType.getName());
            }
            return pluginTypes.values();
        }
        catch (Exception e) {
            this.log.error((Object)("Error transforming plugin descriptor [" + pluginDescriptor.getName() + "]"), (Throwable)e);
            return null;
        }
    }

    public synchronized ContentSourceType getContentSourceType(String typeName) {
        for (Map<String, ContentSourceType> pluginTypes : this.loadedPlugins.values()) {
            ContentSourceType type = pluginTypes.get(typeName);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public synchronized Set<ContentSourceType> getAllContentSourceTypes() {
        HashSet<ContentSourceType> allTypes = new HashSet<ContentSourceType>();
        for (Map<String, ContentSourceType> pluginTypes : this.loadedPlugins.values()) {
            allTypes.addAll(pluginTypes.values());
        }
        return allTypes;
    }

    public synchronized Set<String> getPluginNames() {
        return this.loadedPlugins.keySet();
    }

    public synchronized Collection<ContentSourceType> getContentSourceTypesByPlugin(String pluginName) {
        Map<String, ContentSourceType> pluginTypes = this.loadedPlugins.get(pluginName);
        if (pluginTypes == null) {
            return null;
        }
        return pluginTypes.values();
    }

    public synchronized String getPluginNameFromContentSourceType(ContentSourceType type) {
        Set<String> pluginNames = this.loadedPlugins.keySet();
        for (String pluginName : pluginNames) {
            if (!this.loadedPlugins.get(pluginName).containsValue(type)) continue;
            return pluginName;
        }
        return null;
    }
}

