/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.util.UUID;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.AgentCriteria;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class UpdatePluginsOnAgentsJob
implements Job {
    public static JobDetail getJobDetail() {
        String groupId = UpdatePluginsOnAgentsJob.class.getName();
        String name = UUID.randomUUID().toString();
        JobDetail jobDetail = new JobDetail(name, groupId, UpdatePluginsOnAgentsJob.class);
        jobDetail.setVolatility(false);
        jobDetail.setDurability(false);
        jobDetail.setRequestsRecovery(false);
        return jobDetail;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        AgentCriteria crit = new AgentCriteria();
        crit.setPageControl(PageControl.getUnlimitedInstance());
        AgentManagerLocal agentManager = LookupUtil.getAgentManager();
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        PageList<Agent> agents = agentManager.findAgentsByCriteria(overlord, crit);
        for (Agent agent : agents) {
            AgentClient client = agentManager.getAgentClient(agent);
            client.updatePlugins();
        }
    }
}

