/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest.domain;

import com.wordnik.swagger.annotations.ApiClass;
import com.wordnik.swagger.annotations.ApiProperty;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@ApiClass(value="An aggregate of metrics data for a given schedule")
@XmlRootElement
public class MetricAggregate {
    Integer scheduleId;
    Double min;
    Double avg;
    Double max;
    int numDataPoints;
    List<DataPoint> dataPoints = new ArrayList<DataPoint>();
    long minTimeStamp;
    long maxTimeStamp;
    boolean isGroup = false;

    public MetricAggregate() {
    }

    public MetricAggregate(Integer scheduleId, Double min, Double avg, Double max) {
        this();
        this.scheduleId = scheduleId;
        this.min = min;
        this.avg = avg;
        this.max = max;
    }

    @ApiProperty(value="List of indiviudual data points")
    @XmlElement
    public List<DataPoint> getDataPoints() {
        return this.dataPoints;
    }

    public void addDataPoint(DataPoint point) {
        this.dataPoints.add(point);
    }

    public void setDataPoints(List<DataPoint> dataPoints) {
        this.dataPoints = dataPoints;
    }

    @ApiProperty(value="Minimum value for the data")
    @XmlElement
    public Double getMin() {
        return this.min;
    }

    @ApiProperty(value="Average value for the data")
    @XmlElement
    public Double getAvg() {
        return this.avg;
    }

    @ApiProperty(value="Maximum value for the data")
    @XmlElement
    public Double getMax() {
        return this.max;
    }

    public void setMin(Double min) {
        this.min = min;
    }

    public void setAvg(Double avg) {
        this.avg = avg;
    }

    public void setMax(Double max) {
        this.max = max;
    }

    @ApiProperty(value="Number of data points i.e. size of the dataPoints list")
    public int getNumDataPoints() {
        return this.numDataPoints;
    }

    public void setNumDataPoints(int numDataPoints) {
        this.numDataPoints = numDataPoints;
    }

    @ApiProperty(value="Id of the metric")
    @XmlElement
    public Integer getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(Integer scheduleId) {
        this.scheduleId = scheduleId;
    }

    @ApiProperty(value="Timestamp of the earliest data point in the list")
    public long getMinTimeStamp() {
        return this.minTimeStamp;
    }

    public void setMinTimeStamp(long minTimeStamp) {
        this.minTimeStamp = minTimeStamp;
    }

    @ApiProperty(value="Timestamp fo the latest data point in the list")
    public long getMaxTimeStamp() {
        return this.maxTimeStamp;
    }

    public void setMaxTimeStamp(long maxTimeStamp) {
        this.maxTimeStamp = maxTimeStamp;
    }

    @ApiProperty(value="Determines if this is data for a group")
    public boolean isGroup() {
        return this.isGroup;
    }

    public void setGroup(boolean group) {
        this.isGroup = group;
    }

    public static class DataPoint {
        long timeStamp;
        Double value;
        Double high;
        Double low;

        public DataPoint() {
        }

        public DataPoint(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public DataPoint(long timeStamp, Double value, Double high, Double low) {
            this.timeStamp = timeStamp;
            this.value = value;
            this.high = high;
            this.low = low;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public Double getValue() {
            return this.value;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public void setValue(Double value) {
            this.value = value;
        }

        public Double getHigh() {
            return this.high;
        }

        public void setHigh(Double high) {
            this.high = high;
        }

        public Double getLow() {
            return this.low;
        }

        public void setLow(Double low) {
            this.low = low;
        }
    }
}

