/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.storage;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.DefaultRetryPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.LoggingRetryPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.Singleton;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.schema.SchemaManager;
import org.rhq.cassandra.util.ClusterBuilder;
import org.rhq.core.domain.cloud.StorageNode;
import org.rhq.core.domain.common.composite.SystemSetting;
import org.rhq.core.domain.common.composite.SystemSettings;
import org.rhq.core.util.ObjectNameFactory;
import org.rhq.core.util.PropertiesFileUpdate;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.cloud.StorageNodeManagerLocal;
import org.rhq.enterprise.server.core.CoreServer;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.storage.StorageClientManagerMBean;
import org.rhq.enterprise.server.storage.StorageClusterMonitor;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.JMXUtil;
import org.rhq.server.metrics.DateTimeService;
import org.rhq.server.metrics.MetricsConfiguration;
import org.rhq.server.metrics.MetricsDAO;
import org.rhq.server.metrics.MetricsServer;
import org.rhq.server.metrics.StorageSession;
import org.rhq.server.metrics.StorageStateListener;

@Singleton
@LocalBean
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class StorageClientManager
implements StorageClientManagerMBean {
    private static final ObjectName OBJECT_NAME = ObjectNameFactory.create((String)"rhq:service=StorageClientManager");
    private static final Log LOG = LogFactory.getLog(StorageClientManager.class);
    private static final String RHQ_KEYSPACE = "rhq";
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private StorageNodeManagerLocal storageNodeManager;
    @EJB
    private SystemManagerLocal systemManager;
    @EJB
    private CoreServer coreServer;
    @EJB
    private MeasurementScheduleManagerLocal measurementScheduleManager;
    @Resource
    private TimerService timerService;
    private Cluster cluster;
    private StorageSession session;
    private MetricsConfiguration metricsConfiguration;
    private MetricsDAO metricsDAO;
    private MetricsServer metricsServer;
    private boolean initialized;
    private StorageClusterMonitor storageClusterMonitor;
    private String cachedStorageUsername;
    private String cachedStoragePassword;

    public void scheduleStorageSessionMaintenance() {
        Collection timers = this.timerService.getTimers();
        for (Timer existingTimer : timers) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found timer - attempting to cancel: " + existingTimer.toString()));
            }
            try {
                existingTimer.cancel();
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed in attempting to cancel timer: " + existingTimer.toString()));
            }
        }
        this.timerService.createIntervalTimer(30000L, 90000L, new TimerConfig(null, false));
    }

    @Timeout
    public void storageSessionMaintenance(Timer timer) {
        if (!this.initialized) {
            this.init();
        } else {
            boolean refreshResult = this.refreshCredentialsAndSession();
            if (!refreshResult) {
                LOG.error((Object)"Storage session credentials not succesfully refreshed!");
            } else {
                LOG.debug((Object)"Storage session credentials refreshed.");
            }
        }
    }

    public synchronized boolean init() {
        if (this.initialized) {
            LOG.debug((Object)"Storage client subsystem is already initialized. Skipping initialization.");
            return this.initialized;
        }
        LOG.info((Object)"Initializing storage client subsystem");
        try {
            Session wrappedSession = this.createSession();
            this.session = new StorageSession(wrappedSession);
            this.storageClusterMonitor = new StorageClusterMonitor(this.session);
            this.storageClusterMonitor.updateRequestLimit();
            this.session.addStorageStateListener((StorageStateListener)this.storageClusterMonitor);
            this.metricsConfiguration = new MetricsConfiguration();
            this.metricsDAO = new MetricsDAO(this.session, this.metricsConfiguration);
            this.initMetricsServer();
            JMXUtil.registerMBean(this, OBJECT_NAME);
            this.initialized = true;
            this.initialized = true;
            LOG.info((Object)"Storage client subsystem is now initialized");
        }
        catch (NoHostAvailableException e) {
            this.initialized = false;
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
            LOG.warn((Object)"Storage client subsystem wasn't initialized because it wasn't possible to connect to the storage cluster. The RHQ server is set to MAINTENANCE mode. Please start the storage cluster as soon as possible.", (Throwable)e);
        }
        catch (Throwable t) {
            this.initialized = false;
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
            LOG.warn((Object)"Storage client subsystem wasn't initialized. The RHQ server will be set to MAINTENANCE mode. Please verify  that the storage cluster is operational.", t);
        }
        return this.initialized;
    }

    public synchronized boolean refreshCredentialsAndSession() {
        if (!this.initialized) {
            LOG.debug((Object)"Storage client subsystem not initialized. Skipping session refresh.");
            return false;
        }
        SystemSettings settings = this.systemManager.getObfuscatedSystemSettings(true);
        String username = (String)settings.get((Object)SystemSetting.STORAGE_USERNAME);
        String password = (String)settings.get((Object)SystemSetting.STORAGE_PASSWORD);
        if (username != null && !username.equals(this.cachedStorageUsername) || password != null && !password.equals(this.cachedStoragePassword)) {
            Session wrappedSession;
            try {
                wrappedSession = this.createSession();
            }
            catch (NoHostAvailableException e) {
                if (this.cluster != null) {
                    this.cluster.shutdown();
                }
                LOG.warn((Object)"Storage client subsystem wasn't initialized because it wasn't possible to connect to the storage cluster. The RHQ server is set to MAINTENANCE mode. Please start the storage cluster as soon as possible.", (Throwable)e);
                return false;
            }
            this.session.registerNewSession(wrappedSession);
            this.metricsDAO.initPreparedStatements();
            return true;
        }
        return true;
    }

    private void checkSchemaCompability(String username, String password, List<StorageNode> storageNodes) {
        String[] nodes = new String[storageNodes.size()];
        for (int index = 0; index < storageNodes.size(); ++index) {
            nodes[index] = storageNodes.get(index).getAddress();
        }
        int cqlPort = storageNodes.get(0).getCqlPort();
        SchemaManager schemaManager = new SchemaManager(username, password, nodes, cqlPort);
        try {
            schemaManager.checkCompatibility();
        }
        catch (NoHostAvailableException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            schemaManager.shutdown();
        }
    }

    public synchronized void shutdown() {
        LOG.info((Object)"Shutting down storage client subsystem");
        if (this.metricsServer != null) {
            this.metricsServer.shutdown();
            this.metricsServer = null;
        }
        this.metricsDAO = null;
        try {
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to shutdown the cluster connection manager for the storage cluster.", (Throwable)e);
        }
        this.cluster = null;
        this.session = null;
        JMXUtil.unregisterMBeanQuietly(OBJECT_NAME);
        this.initialized = false;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public MetricsDAO getMetricsDAO() {
        return this.metricsDAO;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public MetricsServer getMetricsServer() {
        return this.metricsServer;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public StorageSession getSession() {
        return this.session;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public MetricsConfiguration getMetricsConfiguration() {
        return this.metricsConfiguration;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public boolean isClusterAvailable() {
        return this.storageClusterMonitor != null && this.storageClusterMonitor.isClusterAvailable();
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public int getAggregationBatchSize() {
        return this.metricsServer.getAggregationBatchSize();
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void setAggregationBatchSize(int batchSize) {
        this.metricsServer.setAggregationBatchSize(batchSize);
        this.persistStorageProperty("rhq.metrics.aggregation.batch-size", Integer.toString(batchSize));
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public int getAggregationParallelism() {
        return this.metricsServer.getAggregationParallelism();
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void setAggregationParallelism(int parallelism) {
        this.metricsServer.setAggregationParallelism(parallelism);
        this.persistStorageProperty("rhq.metrics.aggregation.parallelism", Integer.toString(parallelism));
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public int getAggregationWorkers() {
        return this.metricsServer.getNumAggregationWorkers();
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void setAggregationWorkers(int numWorkers) {
        this.persistStorageProperty("rhq.metrics.aggregation.workers", Integer.toString(numWorkers));
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public int getRawDataAgeLimit() {
        return this.metricsServer.getRawDataAgeLimit();
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void setRawDataAgeLimit(int ageLimit) {
        this.metricsServer.setRawDataAgeLimit(ageLimit);
        this.persistStorageProperty("rhq.metrics.data.age-limit", Integer.toString(ageLimit));
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public double getRequestLimit() {
        return this.session.getRequestLimit();
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void setRequestLimit(double requestLimit) {
        this.session.setRequestLimit(requestLimit);
        this.persistStorageProperty("rhq.storage.request.limit", Double.toString(requestLimit));
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public double getMinRequestLimit() {
        return this.session.getMinRequestLimit();
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void setMinRequestLimit(double minRequestLimit) {
        this.session.setMinRequestLimit(minRequestLimit);
        this.persistStorageProperty("rhq.storage.request.limit.min", Double.toString(minRequestLimit));
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public double getRequestLimitTopologyDelta() {
        return this.session.getTopologyDelta();
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void setRequestLimitTopologyDelta(double delta) {
        this.session.setTopologyDelta(delta);
        this.persistStorageProperty("rhq.storage.request.limit.topology-delta", Double.toString(delta));
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public double getRequestTimeoutDelta() {
        return this.session.getTimeoutDelta();
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void setRequestTimeoutDelta(double requestTimeoutDelta) {
        this.session.setTimeoutDelta(requestTimeoutDelta);
        this.persistStorageProperty("rhq.storage.request.limit.timeout-delta", Double.toString(requestTimeoutDelta));
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long getRequestTimeoutDampening() {
        return this.session.getTimeoutDampening();
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void setRequestTimeoutDampening(long requestTimeoutDampening) {
        this.session.setTimeoutDampening(requestTimeoutDampening);
        this.persistStorageProperty("rhq.storage.request.timeout-dampening", Long.toString(requestTimeoutDampening));
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long getRequestTimeouts() {
        return this.session.getTimeouts();
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long getTotalRequests() {
        return this.session.getTimeouts();
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void persistStorageProperty(String key, String value) {
        if (Boolean.getBoolean("running.itests-2")) {
            return;
        }
        PropertiesFileUpdate updater = new PropertiesFileUpdate(this.getServerPropsFile().getAbsolutePath());
        try {
            updater.update(key, value);
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to persist property " + key + " due to unexpected I/O error"), ThrowableUtil.getRootCause((Throwable)e));
        }
    }

    private File getServerPropsFile() {
        File installDir = this.coreServer.getInstallDir();
        File binDir = new File(installDir, "bin");
        return new File(binDir, "rhq-server.properties");
    }

    private Session createSession() {
        SystemSettings settings = this.systemManager.getObfuscatedSystemSettings(true);
        this.cachedStorageUsername = (String)settings.get((Object)SystemSetting.STORAGE_USERNAME);
        this.cachedStoragePassword = (String)settings.get((Object)SystemSetting.STORAGE_PASSWORD);
        ArrayList<StorageNode> storageNodes = new ArrayList<StorageNode>();
        for (StorageNode storageNode : this.storageNodeManager.getStorageNodes()) {
            if (storageNode.getOperationMode() != StorageNode.OperationMode.NORMAL && storageNode.getOperationMode() != StorageNode.OperationMode.MAINTENANCE && storageNode.getResource() != null) continue;
            storageNodes.add(storageNode);
        }
        if (storageNodes.isEmpty()) {
            throw new IllegalStateException("There is no storage node metadata stored in the relational database. This may have happened as a result of running dbsetup or deleting rows from rhq_storage_node table. Please re-install the storage node to fix this issue.");
        }
        this.checkSchemaCompability(this.cachedStorageUsername, this.cachedStoragePassword, storageNodes);
        LOG.debug((Object)"Initializing session to connect to storage node cluster");
        ArrayList<String> hostNames = new ArrayList<String>();
        for (StorageNode storageNode : storageNodes) {
            hostNames.add(storageNode.getAddress());
        }
        int port = ((StorageNode)storageNodes.get(0)).getCqlPort();
        this.cluster = new ClusterBuilder().addContactPoints(hostNames.toArray(new String[hostNames.size()])).withCredentialsObfuscated(this.cachedStorageUsername, this.cachedStoragePassword).withPort(port).withLoadBalancingPolicy(this.getLoadBalancingPolicy()).withRetryPolicy((RetryPolicy)new LoggingRetryPolicy((RetryPolicy)DefaultRetryPolicy.INSTANCE)).withCompression(ProtocolOptions.Compression.NONE).build();
        PoolingOptions poolingOptions = this.cluster.getConfiguration().getPoolingOptions();
        poolingOptions.setCoreConnectionsPerHost(HostDistance.LOCAL, Integer.parseInt(System.getProperty("rhq.storage.client.local-connections", "24")));
        poolingOptions.setCoreConnectionsPerHost(HostDistance.REMOTE, Integer.parseInt(System.getProperty("rhq.storage.client.remote-connections", "16")));
        poolingOptions.setMaxConnectionsPerHost(HostDistance.LOCAL, Integer.parseInt(System.getProperty("rhq.storage.client.max-local-connections", "32")));
        poolingOptions.setMaxConnectionsPerHost(HostDistance.REMOTE, Integer.parseInt(System.getProperty("rhq.storage.client.max-remote-connections", "24")));
        return this.cluster.connect(RHQ_KEYSPACE);
    }

    private LoadBalancingPolicy getLoadBalancingPolicy() {
        String policy = System.getProperty("rhq.storage.client.load-balancing");
        if (policy == null || policy.equals("RoundRobin")) {
            return new RoundRobinPolicy();
        }
        if (policy.equals("DCAwareRoundRobin")) {
            String dataCenter = System.getProperty("rhq.storage.dc");
            if (dataCenter == null) {
                LOG.warn((Object)(policy + " was specified for " + "rhq.storage.client.load-balancing" + " but " + "rhq.storage.dc" + " is undefined." + "Reverting to RoundRobin load balancing policy."));
                return new RoundRobinPolicy();
            }
            return new DCAwareRoundRobinPolicy(dataCenter);
        }
        LOG.warn((Object)(policy + " is not a supported load balancing policy. Reverting to RoundRobin load balancing policy."));
        return new RoundRobinPolicy();
    }

    private void initMetricsServer() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Initializing " + MetricsServer.class.getName()));
        }
        this.metricsServer = new MetricsServer();
        this.metricsServer.setDAO(this.metricsDAO);
        this.metricsServer.setConfiguration(this.metricsConfiguration);
        DateTimeService dateTimeService = new DateTimeService();
        dateTimeService.setConfiguration(this.metricsConfiguration);
        this.metricsServer.setDateTimeService(dateTimeService);
        this.metricsServer.setCacheActivationTime(this.getCacheActivationTime());
        this.metricsServer.init();
    }

    private long getCacheActivationTime() {
        SystemSettings settings = this.systemManager.getObfuscatedSystemSettings(true);
        return Long.parseLong((String)settings.get((Object)SystemSetting.METRICS_CACHE_ACTIVATION_TIME));
    }
}

