/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync.validators;

import javax.persistence.EntityManager;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.server.sync.ValidationException;
import org.rhq.enterprise.server.sync.validators.EntityValidator;

public class MaxCountValidator<T>
implements EntityValidator<T> {
    private int max;
    private int cnt;

    public MaxCountValidator(int max) {
        this.max = max;
    }

    @Override
    public void initialize(Subject subject, EntityManager entityManager) {
        this.cnt = 0;
    }

    @Override
    public void validateExportedEntity(T entity) throws ValidationException {
        if (++this.cnt > this.max) {
            throw new ValidationException("Entity " + entity + " is unexpected in the export file. At most " + this.max + " entites of this type are expected.");
        }
    }
}

