/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.preferences;

import java.io.File;
import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.util.preferences.FilePreferences;

public class FilePreferencesFactory
implements PreferencesFactory {
    private static final Log log = LogFactory.getLog(FilePreferencesFactory.class);
    public static final String SYSTEM_PROPERTY_FILE = "rhq.preferences.file";
    private static File preferencesFile;
    Preferences rootPreferences;

    @Override
    public Preferences systemRoot() {
        return this.userRoot();
    }

    @Override
    public Preferences userRoot() {
        if (null == this.rootPreferences) {
            log.debug((Object)"Instantiating root preferences");
            this.rootPreferences = new FilePreferences(null, "");
        }
        return this.rootPreferences;
    }

    public static File getPreferencesFile() {
        if (null == preferencesFile) {
            String prefsFile = System.getProperty(SYSTEM_PROPERTY_FILE);
            if (null == prefsFile || prefsFile.isEmpty()) {
                prefsFile = System.getProperty("user.home") + File.separator + ".fileprefs";
            }
            preferencesFile = new File(prefsFile).getAbsoluteFile();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Preferences file is " + preferencesFile));
            }
        }
        return preferencesFile;
    }
}

