/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client.script;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.rhq.enterprise.client.script.CommandLineParseException;
import org.rhq.enterprise.client.script.NamedScriptArg;
import org.rhq.enterprise.client.script.ScriptArg;
import org.rhq.enterprise.client.script.ScriptCmdLine;

public class CmdLineParser {
    public ScriptCmdLine parse(String[] cmdLine) throws CommandLineParseException {
        String[] args = Arrays.copyOfRange(cmdLine, 1, cmdLine.length);
        String shortOpts = "-:f:";
        LongOpt[] longOpts = new LongOpt[]{new LongOpt("file", 1, null, 102), new LongOpt("args-style", 1, null, -2)};
        Getopt getopt = new Getopt("exec", args, shortOpts, longOpts, false);
        ArrayList<String> scriptArgs = new ArrayList<String>();
        String argStyle = "indexed";
        String scriptName = null;
        int code = getopt.getopt();
        while (code != -1) {
            switch (code) {
                case 58: 
                case 63: {
                    throw new IllegalArgumentException("Invalid options");
                }
                case 1: {
                    scriptArgs.add(getopt.getOptarg());
                    break;
                }
                case 102: {
                    scriptName = getopt.getOptarg();
                    break;
                }
                case -2: {
                    argStyle = getopt.getOptarg();
                    if (!this.isInvalidArgStyle(argStyle)) break;
                    throw new CommandLineParseException(argStyle + " - invalid value for style option");
                }
            }
            code = getopt.getopt();
        }
        return this.createScriptCmdLine(scriptName, argStyle, scriptArgs);
    }

    private boolean isInvalidArgStyle(String argStyle) {
        return !ScriptCmdLine.ArgType.INDEXED.value().equals(argStyle) && !ScriptCmdLine.ArgType.NAMED.value().equals(argStyle);
    }

    private ScriptCmdLine createScriptCmdLine(String scriptName, String argStyle, List<String> args) {
        ScriptCmdLine cmdLine = new ScriptCmdLine();
        cmdLine.setScriptFileName(scriptName);
        if (ScriptCmdLine.ArgType.INDEXED.value().equals(argStyle)) {
            cmdLine.setArgType(ScriptCmdLine.ArgType.INDEXED);
            for (String arg : args) {
                cmdLine.addArg(new ScriptArg(arg));
            }
        } else {
            cmdLine.setArgType(ScriptCmdLine.ArgType.NAMED);
            for (String arg : args) {
                cmdLine.addArg(this.parseNamedArg(arg));
            }
        }
        return cmdLine;
    }

    private NamedScriptArg parseNamedArg(String arg) {
        String[] tokens = arg.split("=");
        String name = tokens[0];
        String value = null;
        if (tokens.length > 1) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 1; i < tokens.length; ++i) {
                buffer.append(tokens[i]);
            }
            value = buffer.toString();
        }
        return new NamedScriptArg(name, value);
    }
}

