/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.client;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import mazz.i18n.Logger;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.client.ClientCommandSender;
import org.rhq.enterprise.communications.command.client.PollingListener;
import org.rhq.enterprise.communications.command.impl.identify.IdentifyCommand;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;
import org.rhq.enterprise.communications.util.CommUtils;

class ServerPollingThread
extends Thread {
    private static final Logger LOG = CommI18NFactory.getLogger(ServerPollingThread.class);
    private final ClientCommandSender m_clientSender;
    private final long m_interval;
    private boolean m_warnedAboutConnectionFailure;
    private final Set<PollingListener> m_pollingListeners = new CopyOnWriteArraySet<PollingListener>();

    public ServerPollingThread(ClientCommandSender client, long polling_interval) {
        super("RHQ Server Polling Thread");
        this.setDaemon(true);
        this.m_clientSender = client;
        this.m_interval = polling_interval;
        this.m_warnedAboutConnectionFailure = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        LOG.debug("ServerPollingThread.started", new Object[]{this.m_interval});
        try {
            while (!this.isInterrupted()) {
                block14: {
                    try {
                        IdentifyCommand id_cmd = new IdentifyCommand();
                        this.m_clientSender.preprocessCommand(id_cmd);
                        CommandResponse response = this.m_clientSender.send(id_cmd);
                        for (PollingListener listener : this.m_pollingListeners) {
                            try {
                                listener.pollResponse(response);
                            }
                            catch (Throwable t) {}
                        }
                        if (CommUtils.isExceptionFailoverable(response.getException())) {
                            throw response.getException();
                        }
                        if (this.m_clientSender.startSending()) {
                            LOG.info("ServerPollingThread.server-online", new Object[0]);
                            this.m_warnedAboutConnectionFailure = false;
                        }
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        if (!this.m_warnedAboutConnectionFailure) {
                            this.m_warnedAboutConnectionFailure = true;
                            LOG.debug("ServerPollingThread.server-poll-failure", new Object[]{ThrowableUtil.getAllMessages((Throwable)t)});
                        }
                        if (!this.m_clientSender.stopSending(false)) break block14;
                        LOG.warn("ServerPollingThread.server-offline", new Object[0]);
                    }
                }
                ServerPollingThread t = this;
                synchronized (t) {
                    this.wait(this.m_interval);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOG.debug("ServerPollingThread.stopped", new Object[0]);
    }

    public void stopPolling() {
        this.interrupt();
        try {
            this.join(this.m_interval * 2L);
        }
        catch (InterruptedException e) {
            this.interrupt();
        }
        this.m_pollingListeners.clear();
    }

    public void addPollingListener(PollingListener listener) {
        if (this.m_pollingListeners.add(listener)) {
            LOG.debug("ServerPollingThread.added-polling-listener", new Object[]{listener});
        }
    }

    public void removePollingListener(PollingListener listener) {
        if (this.m_pollingListeners.remove(listener)) {
            LOG.debug("ServerPollingThread.removed-polling-listener", new Object[]{listener});
        }
    }
}

