/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.param;

import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import mazz.i18n.Logger;
import org.rhq.enterprise.communications.command.param.InvalidParameterDefinitionException;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;

public class ParameterRenderingInformation
implements Serializable {
    private static final long serialVersionUID = -7640644266857817767L;
    private static final Logger LOG = CommI18NFactory.getLogger(ParameterRenderingInformation.class);
    private final String labelKey;
    private final String descriptionKey;
    private String label;
    private String description;
    private boolean hidden;
    private boolean readOnly;
    private boolean obfuscated;

    public ParameterRenderingInformation(String labelKey, String descriptionKey) {
        this.labelKey = labelKey;
        this.descriptionKey = descriptionKey;
        this.hidden = false;
        this.readOnly = false;
        this.obfuscated = false;
    }

    public ParameterRenderingInformation() {
        this(null, null);
    }

    public String getLabelKey() {
        return this.labelKey;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void applyResourceBundle(ResourceBundle resourceBundle) throws MissingResourceException {
        if (resourceBundle != null) {
            if (this.labelKey != null) {
                this.label = resourceBundle.getString(this.labelKey);
            } else {
                LOG.trace("ParameterRenderingInformation.not-using-label-key", new Object[0]);
            }
            if (this.descriptionKey != null) {
                this.description = resourceBundle.getString(this.descriptionKey);
            } else {
                LOG.trace("ParameterRenderingInformation.not-using-desc-key", new Object[0]);
            }
        } else if (this.labelKey != null || this.descriptionKey != null) {
            throw new InvalidParameterDefinitionException("ParameterRenderingInformation.no-resource-bundle");
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isObfuscated() {
        return this.obfuscated;
    }

    public void setObfuscated(boolean obfuscated) {
        this.obfuscated = obfuscated;
    }
}

